/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net;

import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.util.Properties;

public class OUI {
    private static OUI instance;
    private static final Object lock;
    private Properties ouiList = IO.getMergedProps("/OUI");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OUI getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new OUI();
                }
            }
        }
        return instance;
    }

    private OUI() {
    }

    public String lookup(String macAddress) {
        if (macAddress == null || macAddress.isEmpty() || macAddress.length() < 7) {
            return "";
        }
        try {
            macAddress = macAddress.toUpperCase().replaceAll("-", ":").replaceAll(" ", ":");
            String match = this.ouiList.getProperty(macAddress.length() == 7 ? macAddress : macAddress.substring(0, 8));
            if (match != null) {
                return match;
            }
            if (macAddress.length() > 12 && (match = this.ouiList.getProperty(macAddress.substring(0, 13) + "0:00")) != null) {
                return match;
            }
        }
        catch (Exception e) {
            Logger.debug("Failed to lookup OUI", e);
        }
        return "";
    }

    static {
        lock = new Object();
    }
}

