/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net;

import ch.rakudave.jnetmap.controller.Actions;
import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.IF.TransparentIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.Host;
import ch.rakudave.jnetmap.net.PortScan;
import ch.rakudave.jnetmap.net.SNMP;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.IsReachable;
import ch.rakudave.jnetmap.net.status.NativePing;
import ch.rakudave.jnetmap.net.status.OpenSocket;
import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NetworkScan
implements ChangeListener {
    public static final String IP_REGEX = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private Subnet subnet;
    private Map<InetAddress, PingMethod> found;
    private ChangeListener listener;
    private ExecutorService ex;

    public NetworkScan() {
    }

    public NetworkScan(Subnet subnet, ChangeListener updateListener) {
        this.subnet = subnet;
        this.listener = updateListener;
        this.found = new HashMap<InetAddress, PingMethod>();
    }

    public void start(boolean doPortScan) {
        String[] addresses;
        if (this.ex != null) {
            return;
        }
        this.ex = Executors.newFixedThreadPool(50);
        for (String address1 : addresses = this.subnet.getInfo().getAllAddresses()) {
            try {
                InetAddress address = InetAddress.getByName(address1);
                this.ex.submit(new HostCheck(address, this, doPortScan));
            }
            catch (UnknownHostException uhe) {
                Logger.error("Invalid address: " + address1, uhe);
            }
            catch (RejectedExecutionException ree) {
                Logger.debug("Scan interrupted: " + address1, ree);
            }
        }
        this.ex.shutdown();
    }

    public boolean isDone() {
        return this.ex.isTerminated();
    }

    public void cancel() {
        if (this.ex != null) {
            this.ex.shutdownNow();
        }
    }

    public Map<InetAddress, PingMethod> getFoundHosts() {
        return this.found;
    }

    public void addToMap(Map<InetAddress, PingMethod> hosts, ch.rakudave.jnetmap.model.Map map) {
        Device gateway;
        if (hosts == null || hosts.isEmpty() || map == null) {
            return;
        }
        Connection gToS = new Connection();
        Device aSwitch = null;
        NetworkIF gatewayIF = null;
        try {
            gatewayIF = NetworkScan.tryFindIP(map, InetAddress.getByName(this.subnet.getInfo().getLowAddress()));
        }
        catch (UnknownHostException ex) {
            Logger.debug("Unable to find gateway-interface", ex);
        }
        if (gatewayIF == null) {
            gateway = new Host("Router");
            gatewayIF = new PhysicalIF(gateway, gToS, this.subnet.getInfo().getLowAddress());
            map.addVertex(gateway);
            gateway.addInterface(gatewayIF);
        } else {
            gateway = gatewayIF.getDevice();
        }
        try {
            aSwitch = map.getOpposite(gateway, gatewayIF.getConnection());
            if (aSwitch != null && !aSwitch.getType().toLowerCase().contains("switch")) {
                aSwitch = null;
            }
        }
        catch (Exception e) {
            Logger.debug("Unable to find opposite", e);
        }
        if (aSwitch == null) {
            aSwitch = new Host("Switch");
            map.addVertex(aSwitch);
            aSwitch.addInterface(new TransparentIF(aSwitch, gToS, gatewayIF));
            map.addEdge(gToS, gateway, aSwitch);
        }
        Device gw = gateway;
        Device sw = aSwitch;
        NetworkIF gif = gatewayIF;
        for (InetAddress address : hosts.keySet()) {
            Scheduler.execute(() -> {
                try {
                    if (!address.equals(gif.getAddress())) {
                        if (NetworkScan.tryFindIP(map, address) != null) {
                            return;
                        }
                        Logger.debug("Adding Interface " + address);
                        Connection c = new Connection();
                        Host d = new Host();
                        d.setName(address.getHostName());
                        PhysicalIF pif = new PhysicalIF(d, c, address.getHostAddress());
                        pif.setPingMethod((PingMethod)hosts.get(address));
                        pif.setSubnet(this.subnet.getInfo().getNetmask());
                        pif.setGateway(this.subnet.getInfo().getLowAddress());
                        d.addInterface(pif);
                        SNMP.inferProperties(d);
                        sw.addInterface(new TransparentIF(sw, c, pif));
                        map.addVertex(d);
                        map.addEdge(c, d, sw);
                    } else {
                        if (gif instanceof PhysicalIF) {
                            ((PhysicalIF)gif).setPingMethod((PingMethod)hosts.get(address));
                        }
                        gw.setName(address.getHostName());
                    }
                }
                catch (Exception e) {
                    Logger.error("Unable to add address " + address + " to map", e);
                }
            });
        }
        Actions.refresh().actionPerformed(null);
    }

    public static NetworkIF tryFindIP(ch.rakudave.jnetmap.model.Map m, InetAddress address) {
        for (Device d : m.getVertices()) {
            for (NetworkIF nif : d.getInterfaces()) {
                if (!address.equals(nif.getAddress())) continue;
                return nif;
            }
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Tuple tuple = (Tuple)e.getSource();
        if (!this.found.containsKey(tuple.getFirst())) {
            this.found.put((InetAddress)tuple.getFirst(), (PingMethod)tuple.getSecond());
            if (this.listener != null) {
                this.listener.stateChanged(new ChangeEvent(tuple));
            }
        }
    }

    public static String getLocalAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            Logger.debug("Unable to get local interfaces", e);
            return null;
        }
        for (NetworkInterface netint : Collections.list(nets)) {
            for (InetAddress inetAddress : Collections.list(netint.getInetAddresses())) {
                if (inetAddress.isLoopbackAddress() || !inetAddress.getHostAddress().matches(IP_REGEX)) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }

    public class HostCheck
    implements Runnable {
        private InetAddress address;
        private ChangeListener l;
        private boolean doPortScan;

        public HostCheck(InetAddress address, ChangeListener l, boolean doPortScan) {
            this.address = address;
            this.l = l;
            this.doPortScan = doPortScan;
        }

        @Override
        public void run() {
            int port;
            if (new Subnet(this.address.getHostAddress() + "/24").getInfo().getBroadcastAddress().equals(this.address.getHostAddress()) || new Subnet(this.address.getHostAddress() + "/16").getInfo().getBroadcastAddress().equals(this.address.getHostAddress()) || new Subnet(this.address.getHostAddress() + "/8").getInfo().getBroadcastAddress().equals(this.address.getHostAddress())) {
                return;
            }
            Logger.trace("Checking if " + this.address.getHostAddress() + " is up");
            Tuple<InetAddress, PingMethod> result = IsReachable.getInstance().getStatus(this.address) == Status.UP ? new Tuple<InetAddress, IsReachable>(this.address, IsReachable.getInstance()) : (NativePing.getInstance().getStatus(this.address) == Status.UP ? new Tuple<InetAddress, NativePing>(this.address, NativePing.getInstance()) : (this.doPortScan ? ((port = PortScan.sweepCommon(this.address)) != -1 ? new Tuple<InetAddress, OpenSocket>(this.address, new OpenSocket(port)) : null) : null));
            this.l.stateChanged(new ChangeEvent(result));
        }
    }
}

