/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model.device;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.LogicalIF;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.DeviceEvent;
import ch.rakudave.jnetmap.model.device.DeviceListener;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@XStreamAlias(value="Device")
public class Host
implements Device {
    private String name = "";
    private String vendor = "";
    private String model = "";
    private String location = "";
    private String otherID = "";
    private String description = "";
    private Status status;
    private int nrOfPorts = 1;
    private boolean ignore;
    @XStreamOmitField
    private Date lastStatusChange;
    private String type;
    private List<NetworkIF> interfaces;
    private List<DeviceListener> listeners;
    private Map<String, String> metadata;
    private LinkedList<Tuple<Date, Status>> statusHistory;

    public Host() {
        this("Workstation");
    }

    public Host(String type) {
        this.type = type;
        this.interfaces = new ArrayList<NetworkIF>();
        this.listeners = new ArrayList<DeviceListener>();
        this.initMetadata();
        this.status = Status.UNKNOWN;
    }

    @Override
    public void addInterface(NetworkIF i) {
        if (i != null) {
            this.interfaces.add(i);
        }
    }

    @Override
    public void addDeviceListener(DeviceListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public List<NetworkIF> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces.stream().sorted(Comparator.comparing(NetworkIF::getName)).collect(Collectors.toList()));
    }

    @Override
    public Date getLastSeen() {
        return this.lastStatusChange;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOtherID() {
        return this.otherID;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public void notifyListeners(DeviceEvent e) {
        if (this.ignore && e.getType() == DeviceEvent.Type.STATUS_CHANGED) {
            return;
        }
        for (DeviceListener l : this.listeners) {
            try {
                l.deviceChanged(e);
            }
            catch (Exception ex) {
                Logger.error("Unable to notify DeviceListener", ex);
            }
        }
    }

    @Override
    public void removeInterface(NetworkIF i) {
        this.interfaces.remove(i);
    }

    @Override
    public void removeDeviceListener(DeviceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setLocation(String location) {
        if (this.location.equals(location) || location == null) {
            return;
        }
        this.location = location;
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, location));
    }

    @Override
    public void setModel(String modelNr) {
        if (this.model.equals(modelNr) || modelNr == null) {
            return;
        }
        this.model = modelNr;
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, modelNr));
    }

    @Override
    public void setName(String name) {
        if (this.name.equals(name) || name == null) {
            return;
        }
        this.name = name;
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, name));
    }

    @Override
    public void setOtherID(String other) {
        if (this.otherID.equals(other) || other == null) {
            return;
        }
        if (other != null) {
            this.otherID = other;
        }
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, other));
    }

    @Override
    public void setType(String type) {
        if (type == null || type.endsWith(this.type)) {
            return;
        }
        this.type = type;
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, type));
    }

    @Override
    public void setVendor(String vendor) {
        if (this.vendor.equals(vendor) || vendor == null) {
            return;
        }
        this.vendor = vendor;
        this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, vendor));
    }

    @Override
    public void updateStatus() {
        Status newStatus = Status.UNKNOWN;
        for (NetworkIF i : this.interfaces) {
            i.updateStatus();
            Status intStatus = i.getStatus();
            if (newStatus.compareTo(intStatus) >= 0 || i instanceof LogicalIF) continue;
            newStatus = intStatus;
        }
        if (!this.status.equals((Object)newStatus)) {
            Date now;
            Logger.debug(this.name + " has changes status from " + (Object)((Object)this.status) + " to " + (Object)((Object)newStatus));
            this.status = newStatus;
            this.lastStatusChange = now = new Date(System.currentTimeMillis());
            this.putInStatusHistory(now, newStatus);
            this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.STATUS_CHANGED, null));
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toHtmlString() {
        return "<span style=\"color: " + this.getStatus().getHtmlValue() + "\">" + this.toString() + "</span>";
    }

    @Override
    public NetworkIF getInterfaceFor(Connection c) {
        if (c == null) {
            return null;
        }
        for (NetworkIF nif : this.getInterfaces()) {
            if (c != nif.getConnection()) continue;
            return nif;
        }
        Logger.debug("getInterfaceFor: nothing found");
        return null;
    }

    @Override
    public String getDesctription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    @Override
    public void setMetadata(String id, String data) {
        this.initMetadata();
        if (this.metadata.put(id, data) != null) {
            this.notifyListeners(new DeviceEvent(this, DeviceEvent.Type.PROPERTY_CHANGED, id + "=" + data));
        }
    }

    @Override
    public String getMetadata(String id) {
        this.initMetadata();
        return this.metadata.get(id);
    }

    @Override
    public void removeMetadata(String id) {
        this.initMetadata();
        this.metadata.remove(id);
    }

    @Override
    public LinkedList<Tuple<Date, Status>> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new LinkedList();
        }
        return this.statusHistory;
    }

    private void putInStatusHistory(Date date, Status status) {
        if (this.statusHistory == null) {
            this.statusHistory = new LinkedList();
        }
        if (!(status == null || this.statusHistory.size() != 0 && status.equals((Object)this.statusHistory.getLast().getSecond()))) {
            this.statusHistory.add(new Tuple<Date, Status>(date, status));
            if (this.statusHistory.size() > Settings.getInt("device.history.maxsize", 20)) {
                this.statusHistory.removeFirst();
            }
        }
    }

    @Override
    public void addStatusUnknownToHistory() {
        this.putInStatusHistory(new Date(System.currentTimeMillis()), Status.UNKNOWN);
        for (NetworkIF nif : this.getInterfaces()) {
            nif.addStatusUnknownToHistory();
        }
    }

    private void initMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    @Override
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public int compareTo(Device o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public int getNrOfPorts() {
        return Math.max(this.nrOfPorts, this.interfaces.size());
    }

    @Override
    public void setNrOfPorts(int nrOfPorts) {
        this.nrOfPorts = nrOfPorts;
    }
}

