/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;

public final class Blackboard {
    private final SleuthkitCase caseDb;

    Blackboard(SleuthkitCase casedb) {
        this.caseDb = casedb;
    }

    public List<BlackboardArtifact.Type> getArtifactTypesInUse(long dataSourceObjId) throws TskCoreException {
        ArrayList<BlackboardArtifact.Type> arrayList;
        String queryString = "SELECT DISTINCT arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name FROM blackboard_artifact_types AS types INNER JOIN blackboard_artifacts AS arts ON arts.artifact_type_id = types.artifact_type_id WHERE arts.data_source_obj_id = " + dataSourceObjId;
        SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
        this.caseDb.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, queryString);
            ArrayList<BlackboardArtifact.Type> uniqueArtifactTypes = new ArrayList<BlackboardArtifact.Type>();
            while (resultSet.next()) {
                uniqueArtifactTypes.add(new BlackboardArtifact.Type(resultSet.getInt("artifact_type_id"), resultSet.getString("type_name"), resultSet.getString("display_name")));
            }
            arrayList = uniqueArtifactTypes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types is use for data source." + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.caseDb.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public long getArtifactsCount(int artifactTypeID, long dataSourceObjId) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactTypeID, "blackboard_artifacts.data_source_obj_id = '" + dataSourceObjId + "';");
    }

    public List<BlackboardArtifact> getArtifacts(int artifactTypeID, long dataSourceObjId) throws TskCoreException {
        return this.caseDb.getArtifactsHelper("blackboard_artifacts.data_source_obj_id = " + dataSourceObjId + " AND blackboard_artifact_types.artifact_type_id = " + artifactTypeID + ";");
    }

    private long getArtifactsCountHelper(int artifactTypeID, String whereClause) throws TskCoreException {
        long l;
        String queryString = "SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE blackboard_artifacts.artifact_type_id = " + artifactTypeID + " AND blackboard_artifacts.review_status_id !=" + BlackboardArtifact.ReviewStatus.REJECTED.getID() + " AND " + whereClause;
        SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
        this.caseDb.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, queryString);
            long count = 0L;
            if (resultSet.next()) {
                count = resultSet.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types is use for data source." + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.caseDb.releaseSingleUserCaseReadLock();
        return l;
    }

    public boolean artifactExists(Content content, BlackboardArtifact.ARTIFACT_TYPE artifactType, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifactsList = content.getArtifacts(artifactType);
        if (artifactsList.isEmpty()) {
            return false;
        }
        for (BlackboardArtifact artifact : artifactsList) {
            if (!this.attributesMatch(artifact.getAttributes(), attributesList)) continue;
            return true;
        }
        return false;
    }

    private boolean attributesMatch(Collection<BlackboardAttribute> fileAttributesList, Collection<BlackboardAttribute> expectedAttributesList) {
        for (BlackboardAttribute expectedAttribute : expectedAttributesList) {
            boolean match = false;
            for (BlackboardAttribute fileAttribute : fileAttributesList) {
                Object expectedAttributeValue;
                Object fileAttributeValue;
                BlackboardAttribute.Type attributeType = fileAttribute.getAttributeType();
                if (attributeType.getTypeID() != expectedAttribute.getAttributeType().getTypeID()) continue;
                switch (attributeType.getValueType()) {
                    case BYTE: {
                        fileAttributeValue = fileAttribute.getValueBytes();
                        expectedAttributeValue = expectedAttribute.getValueBytes();
                        break;
                    }
                    case DOUBLE: {
                        fileAttributeValue = fileAttribute.getValueDouble();
                        expectedAttributeValue = expectedAttribute.getValueDouble();
                        break;
                    }
                    case INTEGER: {
                        fileAttributeValue = fileAttribute.getValueInt();
                        expectedAttributeValue = expectedAttribute.getValueInt();
                        break;
                    }
                    case LONG: 
                    case DATETIME: {
                        fileAttributeValue = fileAttribute.getValueLong();
                        expectedAttributeValue = expectedAttribute.getValueLong();
                        break;
                    }
                    case STRING: {
                        fileAttributeValue = fileAttribute.getValueString();
                        expectedAttributeValue = expectedAttribute.getValueString();
                        break;
                    }
                    default: {
                        fileAttributeValue = fileAttribute.getDisplayString();
                        expectedAttributeValue = expectedAttribute.getDisplayString();
                    }
                }
                if (fileAttributeValue instanceof byte[]) {
                    if (!Arrays.equals((byte[])fileAttributeValue, expectedAttributeValue)) continue;
                    match = true;
                    break;
                }
                if (!fileAttributeValue.equals(expectedAttributeValue)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

