/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.io.InputStream;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.TskCoreException;

public final class ReadContentInputStream
extends InputStream {
    private long currentOffset;
    private final long contentSize;
    private final Content content;

    public ReadContentInputStream(Content content) {
        this.content = content;
        this.currentOffset = 0L;
        this.contentSize = content.getSize();
    }

    @Override
    public int read() throws ReadContentInputStreamException {
        byte[] buff = new byte[1];
        return this.read(buff) != -1 ? buff[0] : -1;
    }

    @Override
    public int read(byte[] b) throws ReadContentInputStreamException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws ReadContentInputStreamException {
        int buffLen = b.length;
        if (buffLen == 0 || len == 0) {
            return 0;
        }
        if (this.contentSize == 0L) {
            return -1;
        }
        if (off < 0 || off >= buffLen) {
            return -1;
        }
        if (this.currentOffset >= this.contentSize) {
            return -1;
        }
        int lenToRead = (int)Math.min(this.contentSize - this.currentOffset, (long)len);
        lenToRead = Math.min(lenToRead, buffLen - off);
        byte[] retBuf = off == 0 ? b : new byte[lenToRead];
        try {
            int lenRead = this.content.read(retBuf, this.currentOffset, lenToRead);
            if (lenRead == 0 || lenRead == -1) {
                return -1;
            }
            this.currentOffset += (long)lenRead;
            if (off != 0) {
                System.arraycopy(retBuf, 0, b, off, lenRead);
            }
            return lenRead;
        }
        catch (TskCoreException ex) {
            throw new ReadContentInputStreamException(String.format("Error reading file '%s' (id=%d) at offset %d.", this.content.getName(), this.content.getId(), this.currentOffset), ex);
        }
    }

    @Override
    public int available() throws IOException {
        long len = this.contentSize - this.currentOffset;
        if (len < 0L) {
            return 0;
        }
        return (int)len;
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = Math.min(n, this.contentSize - this.currentOffset);
        this.currentOffset += toSkip;
        return toSkip;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long getLength() {
        return this.contentSize;
    }

    public long getCurPosition() {
        return this.currentOffset;
    }

    public long seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("Illegal negative new position in the stream");
        }
        this.currentOffset = Math.min(newPosition, this.contentSize);
        return this.currentOffset;
    }

    public static final class ReadContentInputStreamException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ReadContentInputStreamException(String message) {
            super(message);
        }

        public ReadContentInputStreamException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

