/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.FsContent;
import org.sleuthkit.datamodel.OSInfo;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;

public class OSUtility {
    private OSUtility() {
    }

    public static List<OSInfo> getOSInfo(SleuthkitCase skCase) throws TskCoreException {
        return OSUtility.getOSInfoInternal(skCase, false, false, 0L);
    }

    public static List<OSInfo> getOSInfo(SleuthkitCase skCase, FsContent fsc) throws TskCoreException {
        return OSUtility.getOSInfoInternal(skCase, false, true, fsc.getFileSystemId());
    }

    public static List<OSInfo> getAllOSInfo(SleuthkitCase skCase) throws TskCoreException {
        return OSUtility.getOSInfoInternal(skCase, true, false, 0L);
    }

    private static List<OSInfo> getOSInfoInternal(SleuthkitCase skCase, boolean includeBackups, boolean restrictFs, long fsId) throws TskCoreException {
        ArrayList<OSInfo> infoList = new ArrayList<OSInfo>();
        ArrayList<BlackboardArtifact> results = skCase.getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_OS_INFO);
        for (BlackboardArtifact art : results) {
            boolean isBackup;
            AbstractFile file = skCase.getAbstractFileById(art.getObjectID());
            if (file == null || (isBackup = file.getParentPath().contains("RegBack")) && !includeBackups) continue;
            if (file instanceof FsContent) {
                FsContent fsc = (FsContent)file;
                if (restrictFs && fsId != fsc.getFileSystemId()) continue;
                OSInfo newInfo = new OSInfo(art, isBackup, fsc.getFileSystemId(), file.getParent());
                boolean mergedInfo = false;
                for (OSInfo info : infoList) {
                    if (!info.matches(newInfo)) continue;
                    info.combine(newInfo);
                    mergedInfo = true;
                    break;
                }
                if (mergedInfo) continue;
                infoList.add(newInfo);
                continue;
            }
            if (restrictFs) continue;
            OSInfo newInfo = new OSInfo(art, isBackup, file.getParent());
            boolean mergedInfo = false;
            for (OSInfo info : infoList) {
                if (!info.matches(newInfo)) continue;
                info.combine(newInfo);
                mergedInfo = true;
                break;
            }
            if (mergedInfo) continue;
            infoList.add(newInfo);
        }
        return infoList;
    }
}

