/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.sleuthkit.datamodel.SleuthkitJNI;

public class LibraryUtils {
    public static final String[] EXTS = new String[]{".so", ".dylib", ".dll", ".jnilib"};

    public static boolean loadSleuthkitJNI() {
        boolean loaded = LibraryUtils.loadNativeLibFromTskJar(Lib.TSK_JNI);
        if (!loaded) {
            System.out.println("SleuthkitJNI: failed to load " + Lib.TSK_JNI.getLibName());
        } else {
            System.out.println("SleuthkitJNI: loaded " + Lib.TSK_JNI.getLibName());
        }
        return loaded;
    }

    private static String getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (LibraryUtils.isWindows()) {
            os = "win";
        } else if (LibraryUtils.isMac()) {
            os = "mac";
        } else if (LibraryUtils.isLinux()) {
            os = "linux";
        }
        String arch = System.getProperty("os.arch");
        return arch.toLowerCase() + "/" + os.toLowerCase();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").equals("Linux");
    }

    private static boolean loadNativeLibFromTskJar(Lib library) {
        String libName = library.getLibName();
        String userName = System.getProperty("user.name");
        StringBuilder pathInJarBase = new StringBuilder();
        pathInJarBase.append("/NATIVELIBS/");
        pathInJarBase.append(LibraryUtils.getPlatform());
        pathInJarBase.append("/");
        pathInJarBase.append(libName);
        URL urlInJar = null;
        String libExt = null;
        for (String ext : EXTS) {
            urlInJar = SleuthkitJNI.class.getResource(pathInJarBase.toString() + ext);
            if (urlInJar == null) continue;
            libExt = ext;
            break;
        }
        if (urlInJar == null) {
            System.out.println("Library not found in jar (" + libName + ")");
            return false;
        }
        StringBuilder pathToTempFile = new StringBuilder();
        pathToTempFile.append(System.getProperty("java.io.tmpdir"));
        pathToTempFile.append(File.separator);
        pathToTempFile.append(libName);
        pathToTempFile.append("_");
        pathToTempFile.append(userName);
        pathToTempFile.append(libExt);
        try {
            int length;
            File tempLibFile = new File(pathToTempFile.toString());
            System.out.println("Temp Folder for Libraries: " + tempLibFile.getParent());
            for (Lib l : Lib.values()) {
                String ext = LibraryUtils.getExtByPlatform();
                File f = new File(l.getLibName() + ext);
                if (f.exists()) {
                    f.delete();
                    continue;
                }
                File fUnix = new File(l.getUnixName() + ext);
                if (!fUnix.exists()) continue;
                fUnix.delete();
            }
            if (tempLibFile.exists() && !tempLibFile.delete()) {
                System.out.println("Error deleting old native library.  Is the app already running? (" + tempLibFile.toString() + ")");
                return false;
            }
            InputStream in = urlInJar.openStream();
            FileOutputStream out = new FileOutputStream(tempLibFile);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            in.close();
            ((OutputStream)out).close();
            System.load(tempLibFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("Error loading library: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static String getExtByPlatform() {
        if (LibraryUtils.isWindows()) {
            return ".dll";
        }
        if (LibraryUtils.isMac()) {
            return ".dylib";
        }
        return ".so";
    }

    public static enum Lib {
        MSVCP("msvcp100", ""),
        MSVCR("msvcr100", ""),
        ZLIB("zlib", "z"),
        LIBEWF("libewf", "ewf"),
        LIBVMDK("libvmdk", "vmdk"),
        LIBVHDI("libvhdi", "vhd"),
        TSK_JNI("libtsk_jni", "tsk_jni");

        private final String name;
        private final String unixName;

        private Lib(String name, String unixName) {
            this.name = name;
            this.unixName = unixName;
        }

        public String getLibName() {
            return this.name;
        }

        public String getUnixName() {
            return this.unixName;
        }
    }
}

