/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ReadContentInputStream;
import org.sleuthkit.datamodel.TskCoreException;

public class HashUtility {
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateMd5Hash(Content content) throws IOException {
        String hashText = "";
        Logger logger = Logger.getLogger(HashUtility.class.getName());
        try (ReadContentInputStream in = new ReadContentInputStream(content);){
            byte[] buffer = new byte[16384];
            MessageDigest md = MessageDigest.getInstance("md5");
            int len = ((InputStream)in).read(buffer);
            while (len != -1) {
                md.update(buffer, 0, len);
                len = ((InputStream)in).read(buffer);
            }
            byte[] hash = md.digest();
            BigInteger bigInt = new BigInteger(1, hash);
            hashText = bigInt.toString(16);
            while (hashText.length() < 32) {
                hashText = "0" + hashText;
            }
        }
        return hashText;
    }

    public static boolean isValidMd5Hash(String md5Hash) {
        return md5Hash.matches("^[A-Fa-f0-9]{32}$");
    }

    public static boolean isValidSha1Hash(String sha1Hash) {
        return sha1Hash.matches("^[A-Fa-f0-9]{40}$");
    }

    public static boolean isValidSha256Hash(String sha256Hash) {
        return sha256Hash.matches("^[A-Fa-f0-9]{64}$");
    }

    public static boolean isNoDataMd5(String md5) {
        return md5.toLowerCase().equals("d41d8cd98f00b204e9800998ecf8427e");
    }

    @Deprecated
    public static String calculateMd5(AbstractFile file) throws IOException {
        Logger logger = Logger.getLogger(HashUtility.class.getName());
        String md5Hash = HashUtility.calculateMd5Hash(file);
        try {
            file.getSleuthkitCase().setMd5Hash(file, md5Hash);
        }
        catch (TskCoreException ex) {
            logger.log(Level.WARNING, "Error updating content's md5 in database", ex);
        }
        return md5Hash;
    }
}

