/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.sleuthkit.datamodel.TskData;

class EncodedFileUtil {
    private static final int HEADER_LENGTH = 32;
    private static final String XOR1_HEADER = "TSK_CONTAINER_XOR1_xxxxxxxxxxxxx";

    EncodedFileUtil() {
    }

    static String getHeader(TskData.EncodingType type) throws IOException {
        switch (type) {
            case XOR1: {
                return XOR1_HEADER;
            }
        }
        throw new IOException("Can not get header for " + type.toString());
    }

    static byte[] getEncodedHeader(TskData.EncodingType type) throws IOException {
        if (type.equals((Object)TskData.EncodingType.NONE)) {
            throw new IOException("Can not get encoded header for " + type.toString());
        }
        byte[] encHeader = new byte[32];
        byte[] plainHeader = EncodedFileUtil.getHeader(type).getBytes();
        for (int i = 0; i < 32; ++i) {
            encHeader[i] = EncodedFileUtil.encodeByte(plainHeader[i], type);
        }
        return encHeader;
    }

    static int getHeaderLength() {
        return 32;
    }

    static byte encodeByte(byte b, TskData.EncodingType type) throws IOException {
        switch (type) {
            case XOR1: {
                return (byte)(b ^ 0xCA);
            }
        }
        throw new IOException("Can not encode byte with encoding type " + type.toString());
    }

    static byte decodeByte(byte b, TskData.EncodingType type) throws IOException {
        switch (type) {
            case XOR1: {
                return (byte)(b ^ 0xCA);
            }
        }
        throw new IOException("Can not decode byte with encoding type " + type.toString());
    }

    static TskData.EncodingType getEncoding(RandomAccessFile fileHandle) {
        try {
            byte[] header;
            int bytesRead;
            long curOffset = fileHandle.getFilePointer();
            if (curOffset != 0L) {
                fileHandle.seek(0L);
            }
            if ((bytesRead = fileHandle.read(header = new byte[32], 0, 32)) != 32) {
                return TskData.EncodingType.NONE;
            }
            return EncodedFileUtil.getTypeFromHeader(header);
        }
        catch (IOException ex) {
            return TskData.EncodingType.NONE;
        }
    }

    private static TskData.EncodingType getTypeFromHeader(byte[] header) {
        if (header.length != 32) {
            return TskData.EncodingType.NONE;
        }
        if (Arrays.equals(header, XOR1_HEADER.getBytes())) {
            return TskData.EncodingType.XOR1;
        }
        return TskData.EncodingType.NONE;
    }
}

