/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public final class CaseDbAccessManager {
    private static final Logger logger = Logger.getLogger(CaseDbAccessManager.class.getName());
    private final SleuthkitCase tskDB;

    CaseDbAccessManager(SleuthkitCase skCase) {
        this.tskDB = skCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(String tableName, String columnName) throws TskCoreException {
        boolean doesColumnExists = false;
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            doesColumnExists = this.columnExists(tableName, columnName, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
        return doesColumnExists;
    }

    public boolean columnExists(String tableName, String columnName, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        boolean columnExists;
        block13: {
            columnExists = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
                statement = connection.createStatement();
                if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
                    String tableInfoQuery = "PRAGMA table_info(%s)";
                    resultSet = statement.executeQuery(String.format(tableInfoQuery, tableName));
                    while (resultSet.next()) {
                        if (!resultSet.getString("name").equalsIgnoreCase(columnName)) continue;
                        columnExists = true;
                        break block13;
                    }
                    break block13;
                }
                String tableInfoQueryTemplate = "SELECT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='%s' AND column_name='%s')";
                resultSet = statement.executeQuery(String.format(tableInfoQueryTemplate, tableName.toLowerCase(), columnName.toLowerCase()));
                if (resultSet.next()) {
                    columnExists = resultSet.getBoolean(1);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error checking if column  " + columnName + "exists ", ex);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex2) {
                        logger.log(Level.WARNING, "Failed to to close resultset after checking column", ex2);
                    }
                }
                SleuthkitCase.closeStatement(statement);
            }
        }
        return columnExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws TskCoreException {
        boolean doesTableExist = false;
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            doesTableExist = this.tableExists(tableName, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
        return doesTableExist;
    }

    public boolean tableExists(String tableName, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        boolean tableExists;
        block13: {
            tableExists = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
                statement = connection.createStatement();
                if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
                    resultSet = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                    while (resultSet.next()) {
                        if (!resultSet.getString("name").equalsIgnoreCase(tableName)) continue;
                        tableExists = true;
                        break block13;
                    }
                    break block13;
                }
                String tableInfoQueryTemplate = "SELECT EXISTS (SELECT 1 FROM information_schema.tables WHERE table_name='%s')";
                resultSet = statement.executeQuery(String.format(tableInfoQueryTemplate, tableName.toLowerCase()));
                if (resultSet.next()) {
                    tableExists = resultSet.getBoolean(1);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error checking if table  " + tableName + "exists ", ex);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex2) {
                        logger.log(Level.WARNING, "Failed to to close resultset after checking table", ex2);
                    }
                }
                SleuthkitCase.closeStatement(statement);
            }
        }
        return tableExists;
    }

    public void createTable(String tableName, String tableSchema) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(tableSchema);
        SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
        this.tskDB.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        String createSQL = "CREATE TABLE IF NOT EXISTS " + tableName + " " + tableSchema;
        try {
            statement = connection.createStatement();
            statement.execute(createSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating table " + tableName, ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTable(String tableName, String alterSQL) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            this.alterTable(tableName, alterSQL, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public void alterTable(String tableName, String alterSQL, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(alterSQL);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        transaction.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        String sql = "ALTER TABLE " + tableName + " " + alterSQL;
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error altering table  %s with SQL = %s", tableName, sql), ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
        }
    }

    public void createIndex(String indexName, String tableName, String colsSQL) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateIndexName(indexName);
        this.validateSQL(colsSQL);
        SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
        this.tskDB.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        String indexSQL = "CREATE INDEX IF NOT EXISTS " + indexName + " ON " + tableName + " " + colsSQL;
        try {
            statement = connection.createStatement();
            statement.execute(indexSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating index " + tableName, ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            long rowId = this.insert(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
            long l = rowId;
            return l;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public long insert(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        long rowId = 0L;
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        transaction.acquireSingleUserCaseWriteLock();
        PreparedStatement statement = null;
        String insertSQL = "INSERT";
        if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
            insertSQL = insertSQL + " OR IGNORE";
        }
        insertSQL = insertSQL + " INTO " + tableName + " " + sql;
        try {
            statement = connection.prepareStatement(insertSQL, 1);
            connection.executeUpdate(statement);
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                rowId = resultSet.getLong(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error inserting row in table " + tableName + " with sql = " + insertSQL, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertOrUpdate(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            long rowId = this.insertOrUpdate(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
            long l = rowId;
            return l;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public long insertOrUpdate(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        long rowId = 0L;
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        transaction.acquireSingleUserCaseWriteLock();
        PreparedStatement statement = null;
        String insertSQL = "INSERT";
        if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
            insertSQL = insertSQL + " OR REPLACE";
        }
        insertSQL = insertSQL + " INTO " + tableName + " " + sql;
        try {
            statement = connection.prepareStatement(insertSQL, 1);
            connection.executeUpdate(statement);
            ResultSet resultSet = statement.getGeneratedKeys();
            resultSet.next();
            rowId = resultSet.getLong(1);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error inserting row in table " + tableName + " with sql = " + insertSQL, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            this.update(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public void update(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        transaction.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        String updateSQL = "UPDATE " + tableName + " " + sql;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(updateSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error Updating table " + tableName, ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
        }
    }

    public void select(String sql, CaseDbAccessQueryCallback queryCallback) throws TskCoreException {
        if (queryCallback == null) {
            throw new TskCoreException("Callback is null");
        }
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
        this.tskDB.acquireSingleUserCaseReadLock();
        Statement statement = null;
        String selectSQL = "SELECT " + sql;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(selectSQL);
            queryCallback.process(resultSet);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error running SELECT query.", ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.tskDB.releaseSingleUserCaseReadLock();
        }
    }

    public void delete(String tableName, String sql) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
        this.tskDB.acquireSingleUserCaseWriteLock();
        Statement statement = null;
        String deleteSQL = "DELETE FROM " + tableName + " " + sql;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(deleteSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from table " + tableName, ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    private void validateTableName(String tableName) throws TskCoreException {
        if (SleuthkitCase.getCoreTableNames().contains(tableName.toLowerCase())) {
            throw new TskCoreException("Attempt to modify a core TSK table " + tableName);
        }
        if (tableName.toLowerCase().startsWith("tsk_")) {
            throw new TskCoreException("Modifying tables with tsk_ prefix is not allowed. ");
        }
    }

    private void validateIndexName(String indexName) throws TskCoreException {
        if (indexName.isEmpty()) {
            throw new TskCoreException("Invalid index name " + indexName);
        }
        if (SleuthkitCase.getCoreIndexNames().contains(indexName.toLowerCase())) {
            throw new TskCoreException("Attempt to modify a core TSK index " + indexName);
        }
    }

    private void validateSQL(String sql) throws TskCoreException {
        if (sql.contains(";")) {
            throw new TskCoreException("SQL unsafe to execute, it contains a ; ");
        }
    }

    public static interface CaseDbAccessQueryCallback {
        public void process(ResultSet var1);
    }
}

