/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimeUtilities;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskException;

public class BlackboardAttribute {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final Logger LOGGER = Logger.getLogger(BlackboardAttribute.class.getName());
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private Type attributeType;
    private final int valueInt;
    private final long valueLong;
    private final double valueDouble;
    private final String valueString;
    private final byte[] valueBytes;
    private String context;
    private long artifactID;
    private SleuthkitCase sleuthkitCase;
    private String sources;

    public BlackboardAttribute(ATTRIBUTE_TYPE attributeType, String source, int valueInt) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
            throw new IllegalArgumentException("Value types do not match");
        }
        this.artifactID = 0L;
        this.attributeType = new Type(attributeType);
        this.sources = this.replaceNulls(source);
        this.valueInt = valueInt;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(Type attributeType, String source, int valueInt) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.artifactID = 0L;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.valueInt = valueInt;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(ATTRIBUTE_TYPE attributeType, String source, long valueLong) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG && attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME) {
            throw new IllegalArgumentException("Value types do not match");
        }
        this.artifactID = 0L;
        this.attributeType = new Type(attributeType);
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = valueLong;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(Type attributeType, String source, long valueLong) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG && attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.artifactID = 0L;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = valueLong;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(ATTRIBUTE_TYPE attributeType, String source, double valueDouble) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
            throw new IllegalArgumentException("Value types do not match");
        }
        this.artifactID = 0L;
        this.attributeType = new Type(attributeType);
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = valueDouble;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(Type attributeType, String source, double valueDouble) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.artifactID = 0L;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = valueDouble;
        this.valueString = "";
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(ATTRIBUTE_TYPE attributeType, String source, String valueString) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING) {
            throw new IllegalArgumentException("Value types do not match");
        }
        this.artifactID = 0L;
        this.attributeType = new Type(attributeType);
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = valueString == null ? "" : this.replaceNulls(valueString).trim();
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(Type attributeType, String source, String valueString) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.artifactID = 0L;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = valueString == null ? "" : this.replaceNulls(valueString).trim();
        this.valueBytes = new byte[0];
        this.context = "";
    }

    public BlackboardAttribute(ATTRIBUTE_TYPE attributeType, String source, byte[] valueBytes) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
            throw new IllegalArgumentException("Value types do not match");
        }
        this.artifactID = 0L;
        this.attributeType = new Type(attributeType);
        this.sources = this.replaceNulls(source);
        this.context = "";
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = valueBytes == null ? new byte[0] : valueBytes;
    }

    public BlackboardAttribute(Type attributeType, String source, byte[] valueBytes) throws IllegalArgumentException {
        if (attributeType.getValueType() != TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.artifactID = 0L;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.context = "";
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = valueBytes == null ? new byte[0] : valueBytes;
    }

    public long getArtifactID() {
        return this.artifactID;
    }

    public Type getAttributeType() {
        return this.attributeType;
    }

    public TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE getValueType() {
        return this.attributeType.getValueType();
    }

    public int getValueInt() {
        return this.valueInt;
    }

    public long getValueLong() {
        return this.valueLong;
    }

    public double getValueDouble() {
        return this.valueDouble;
    }

    public String getValueString() {
        return this.valueString;
    }

    public byte[] getValueBytes() {
        return Arrays.copyOf(this.valueBytes, this.valueBytes.length);
    }

    public List<String> getSources() {
        if (null != this.sources && !this.sources.isEmpty()) {
            List<String> modules = Arrays.asList(this.sources.split(","));
            return modules;
        }
        return Collections.emptyList();
    }

    public void addSource(String source) throws TskCoreException {
        this.sources = this.sleuthkitCase.addSourceToArtifactAttribute(this, source);
    }

    public BlackboardArtifact getParentArtifact() throws TskCoreException {
        return this.sleuthkitCase.getBlackboardArtifact(this.artifactID);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (int)(this.artifactID ^ this.artifactID >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlackboardAttribute other = (BlackboardAttribute)obj;
        return this.artifactID == other.getArtifactID();
    }

    public String toString() {
        return "BlackboardAttribute{artifactID=" + this.artifactID + ", attributeType=" + this.attributeType.toString() + ", moduleName=" + this.sources + ", context=" + this.context + ", valueInt=" + this.valueInt + ", valueLong=" + this.valueLong + ", valueDouble=" + this.valueDouble + ", valueString=" + this.valueString + ", valueBytes=" + Arrays.toString(this.valueBytes) + ", Case=" + this.sleuthkitCase + '}';
    }

    public String getDisplayString() {
        switch (this.attributeType.getValueType()) {
            case STRING: {
                return this.getValueString();
            }
            case INTEGER: {
                if (this.attributeType.getTypeID() == ATTRIBUTE_TYPE.TSK_READ_STATUS.getTypeID()) {
                    if (this.getValueInt() == 0) {
                        return "Unread";
                    }
                    return "Read";
                }
                return Integer.toString(this.getValueInt());
            }
            case LONG: {
                return Long.toString(this.getValueLong());
            }
            case DOUBLE: {
                return Double.toString(this.getValueDouble());
            }
            case BYTE: {
                return BlackboardAttribute.bytesToHexString(this.getValueBytes());
            }
            case DATETIME: {
                try {
                    Content dataSource = this.getParentArtifact().getDataSource();
                    if (dataSource != null && dataSource instanceof Image) {
                        Image image = (Image)dataSource;
                        TimeZone tzone = TimeZone.getTimeZone(image.getTimeZone());
                        return TimeUtilities.epochToTime(this.getValueLong(), tzone);
                    }
                    break;
                }
                catch (TskException ex) {
                    LOGGER.log(Level.WARNING, "Could not get timezone for image", ex);
                    return TimeUtilities.epochToTime(this.getValueLong());
                }
            }
        }
        return "";
    }

    BlackboardAttribute(long artifactID, Type attributeType, String source, String context, int valueInt, long valueLong, double valueDouble, String valueString, byte[] valueBytes, SleuthkitCase sleuthkitCase) {
        this.artifactID = artifactID;
        this.attributeType = attributeType;
        this.sources = this.replaceNulls(source);
        this.context = this.replaceNulls(context);
        this.valueInt = valueInt;
        this.valueLong = valueLong;
        this.valueDouble = valueDouble;
        this.valueString = valueString == null ? "" : this.replaceNulls(valueString).trim();
        this.valueBytes = valueBytes == null ? new byte[0] : valueBytes;
        this.sleuthkitCase = sleuthkitCase;
    }

    void setCaseDatabase(SleuthkitCase sleuthkitCase) {
        this.sleuthkitCase = sleuthkitCase;
    }

    void setArtifactId(long artifactID) {
        this.artifactID = artifactID;
    }

    String getSourcesCSV() {
        return this.sources;
    }

    static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private String replaceNulls(String text) {
        return text.replace('\u0000', '\u001a');
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, int valueInt) throws IllegalArgumentException {
        this(ATTRIBUTE_TYPE.fromID(attributeTypeID), moduleName, valueInt);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String context, int valueInt) {
        this(attributeTypeID, moduleName, valueInt);
        this.context = this.replaceNulls(context);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, long valueLong) throws IllegalArgumentException {
        this(ATTRIBUTE_TYPE.fromID(attributeTypeID), moduleName, valueLong);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String context, long valueLong) {
        this(attributeTypeID, moduleName, valueLong);
        this.context = this.replaceNulls(context);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, double valueDouble) throws IllegalArgumentException {
        this(ATTRIBUTE_TYPE.fromID(attributeTypeID), moduleName, valueDouble);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String context, double valueDouble) {
        this(attributeTypeID, moduleName, valueDouble);
        this.context = this.replaceNulls(context);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String valueString) throws IllegalArgumentException {
        this(ATTRIBUTE_TYPE.fromID(attributeTypeID), moduleName, valueString);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String context, String valueString) {
        this(attributeTypeID, moduleName, valueString);
        this.context = this.replaceNulls(context);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, byte[] valueBytes) throws IllegalArgumentException {
        this(ATTRIBUTE_TYPE.fromID(attributeTypeID), moduleName, valueBytes);
    }

    @Deprecated
    public BlackboardAttribute(int attributeTypeID, String moduleName, String context, byte[] valueBytes) {
        this(attributeTypeID, moduleName, valueBytes);
        this.context = this.replaceNulls(context);
    }

    @Deprecated
    protected void setArtifactID(long artifactID) {
        this.setArtifactId(artifactID);
    }

    @Deprecated
    protected void setCase(SleuthkitCase sleuthkitCase) {
        this.setCaseDatabase(sleuthkitCase);
    }

    @Deprecated
    public String getContext() {
        return this.context;
    }

    @Deprecated
    String getContextString() {
        return this.context;
    }

    @Deprecated
    public int getAttributeTypeID() {
        return this.attributeType.getTypeID();
    }

    @Deprecated
    public String getAttributeTypeName() throws TskCoreException {
        return this.attributeType.getTypeName();
    }

    @Deprecated
    public String getAttributeTypeDisplayName() throws TskCoreException {
        return this.attributeType.getDisplayName();
    }

    @Deprecated
    public String getModuleName() {
        return this.sources;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return bundle;
    }

    public static enum ATTRIBUTE_TYPE {
        TSK_URL(1, "TSK_URL", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskUrl.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DATETIME(2, "TSK_DATETIME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDatetime.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_NAME(3, "TSK_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PROG_NAME(4, "TSK_PROG_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskProgName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_VALUE(6, "TSK_VALUE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskValue.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_FLAG(7, "TSK_FLAG", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskFlag.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PATH(8, "TSK_PATH", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPath.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD(10, "TSK_KEYWORD", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeyword.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD_REGEXP(11, "TSK_KEYWORD_REGEXP", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeywordRegexp.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD_PREVIEW(12, "TSK_KEYWORD_PREVIEW", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeywordPreview.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD_SET(13, "TSK_KEYWORD_SET", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeywordSet.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_USER_NAME(14, "TSK_USER_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskUserName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DOMAIN(15, "TSK_DOMAIN", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDomain.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PASSWORD(16, "TSK_PASSWORD", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPassword.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_NAME_PERSON(17, "TSK_NAME_PERSON", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskNamePerson.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DEVICE_MODEL(18, "TSK_DEVICE_MODEL", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDeviceModel.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DEVICE_MAKE(19, "TSK_DEVICE_MAKE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDeviceMake.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DEVICE_ID(20, "TSK_DEVICE_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDeviceId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL(21, "TSK_EMAIL", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmail.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_HASH_MD5(22, "TSK_HASH_MD5", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHashMd5.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_HASH_SHA1(23, "TSK_HASH_SHA1", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHashSha1.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_HASH_SHA2_256(24, "TSK_HASH_SHA2_256", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHashSha225.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_HASH_SHA2_512(25, "TSK_HASH_SHA2_512", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHashSha2512.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TEXT(26, "TSK_TEXT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskText.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TEXT_FILE(27, "TSK_TEXT_FILE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTextFile.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TEXT_LANGUAGE(28, "TSK_TEXT_LANGUAGE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTextLanguage.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ENTROPY(29, "TSK_ENTROPY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEntropy.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_HASHSET_NAME(30, "TSK_HASHSET_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHashsetName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_INTERESTING_FILE(31, "TSK_INTERESTING_FILE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskInterestingFile.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG),
        TSK_REFERRER(32, "TSK_REFERRER", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskReferrer.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DATETIME_ACCESSED(33, "TSK_DATETIME_ACCESSED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeAccessed.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_IP_ADDRESS(34, "TSK_IP_ADDRESS", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskIpAddress.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER(35, "TSK_PHONE_NUMBER", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumber.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PATH_ID(36, "TSK_PATH_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPathId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG),
        TSK_SET_NAME(37, "TSK_SET_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskSetName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ENCRYPTION_DETECTED(38, "TSK_ENCRYPTION_DETECTED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEncryptionDetected.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_MALWARE_DETECTED(39, "TSK_MALWARE_DETECTED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMalwareDetected.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_STEG_DETECTED(40, "TSK_STEG_DETECTED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskStegDetected.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_EMAIL_TO(41, "TSK_EMAIL_TO", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailTo.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_CC(42, "TSK_EMAIL_CC", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailCc.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_BCC(43, "TSK_EMAIL_BCC", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailBcc.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_FROM(44, "TSK_EMAIL_FROM", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailFrom.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_CONTENT_PLAIN(45, "TSK_EMAIL_CONTENT_PLAIN", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailContentPlain.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_CONTENT_HTML(46, "TSK_EMAIL_CONTENT_HTML", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailContentHtml.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_CONTENT_RTF(47, "TSK_EMAIL_CONTENT_RTF", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailContentRtf.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_MSG_ID(48, "TSK_MSG_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMsgId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_MSG_REPLY_ID(49, "TSK_MSG_REPLY_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMsgReplyId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DATETIME_RCVD(50, "TSK_DATETIME_RCVD", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeRcvd.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_DATETIME_SENT(51, "TSK_DATETIME_SENT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeSent.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_SUBJECT(52, "TSK_SUBJECT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskSubject.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TITLE(53, "TSK_TITLE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTitle.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_GEO_LATITUDE(54, "TSK_GEO_LATITUDE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLatitude.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_LONGITUDE(55, "TSK_GEO_LONGITUDE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLongitude.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_VELOCITY(56, "TSK_GEO_VELOCITY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoVelocity.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_ALTITUDE(57, "TSK_GEO_ALTITUDE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoAltitude.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_BEARING(58, "TSK_GEO_BEARING", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoBearing.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_GEO_HPRECISION(59, "TSK_GEO_HPRECISION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoHPrecision.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_VPRECISION(60, "TSK_GEO_VPRECISION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoVPrecision.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_MAPDATUM(61, "TSK_GEO_MAPDATUM", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoMapDatum.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_FILE_TYPE_SIG(62, "TSK_FILE_TYPE_SIG", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskFileTypeSig.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_FILE_TYPE_EXT(63, "TSK_FILE_TYPE_EXT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskFileTypeExt.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TAGGED_ARTIFACT(64, "TSK_TAGGED_ARTIFACT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTaggedArtifact.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG),
        TSK_TAG_NAME(65, "TSK_TAG_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTagName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_COMMENT(66, "TSK_COMMENT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskComment.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_URL_DECODED(67, "TSK_URL_DECODED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskUrlDecoded.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DATETIME_CREATED(68, "TSK_DATETIME_CREATED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeCreated.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_DATETIME_MODIFIED(69, "TSK_DATETIME_MODIFIED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeModified.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_PROCESSOR_ARCHITECTURE(70, "TSK_PROCESSOR_ARCHITECTURE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskProcessorArchitecture.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_VERSION(71, "TSK_VERSION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskVersion.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_USER_ID(72, "TSK_USER_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskUserId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DESCRIPTION(73, "TSK_DESCRIPTION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDescription.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_MESSAGE_TYPE(74, "TSK_MESSAGE_TYPE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMessageType.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER_HOME(75, "TSK_PHONE_NUMBER_HOME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumberHome.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER_OFFICE(76, "TSK_PHONE_NUMBER_OFFICE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumberOffice.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER_MOBILE(77, "TSK_PHONE_NUMBER_MOBILE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumberMobile.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER_FROM(78, "TSK_PHONE_NUMBER_FROM", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumberFrom.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PHONE_NUMBER_TO(79, "TSK_PHONE_NUMBER_TO", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPhoneNumberTo.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DIRECTION(80, "TSK_DIRECTION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDirection.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_HOME(81, "TSK_EMAIL_HOME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailHome.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_OFFICE(82, "TSK_EMAIL_OFFICE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailOffice.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DATETIME_START(83, "TSK_DATETIME_START", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeStart.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_DATETIME_END(84, "TSK_DATETIME_END", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDateTimeEnd.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME),
        TSK_CALENDAR_ENTRY_TYPE(85, "TSK_CALENDAR_ENTRY_TYPE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCalendarEntryType.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_LOCATION(86, "TSK_LOCATION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskLocation.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_SHORTCUT(87, "TSK_SHORTCUT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskShortcut.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_DEVICE_NAME(88, "TSK_DEVICE_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskDeviceName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CATEGORY(89, "TSK_CATEGORY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCategory.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_EMAIL_REPLYTO(90, "TSK_EMAIL_REPLYTO", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskEmailReplyTo.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_SERVER_NAME(91, "TSK_SERVER_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskServerName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_COUNT(92, "TSK_COUNT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCount.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_MIN_COUNT(93, "TSK_MIN_COUNT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMinCount.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_PATH_SOURCE(94, "TSK_PATH_SOURCE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPathSource.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PERMISSIONS(95, "TSK_PERMISSIONS", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskPermissions.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ASSOCIATED_ARTIFACT(96, "TSK_ASSOCIATED_ARTIFACT", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskAssociatedArtifact.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG),
        TSK_ISDELETED(97, "TSK_ISDELETED", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskIsDeleted.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_GEO_LATITUDE_START(98, "TSK_GEO_LATITUDE_START", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLatitudeStart.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_LATITUDE_END(99, "TSK_GEO_LATITUDE_END", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLatitudeEnd.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_LONGITUDE_START(100, "TSK_GEO_LONGITUDE_START", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLongitudeStart.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_GEO_LONGITUDE_END(101, "TSK_GEO_LONGITUDE_END", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskGeoLongitudeEnd.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE),
        TSK_READ_STATUS(102, "TSK_READ_STATUS", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskReadStatus.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_LOCAL_PATH(103, "TSK_LOCAL_PATH", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskLocalPath.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_REMOTE_PATH(104, "TSK_REMOTE_PATH", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskRemotePath.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_TEMP_DIR(105, "TSK_TEMP_DIR", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskTempDir.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_PRODUCT_ID(106, "TSK_PRODUCT_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskProductId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_OWNER(107, "TSK_OWNER", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskOwner.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ORGANIZATION(108, "TSK_ORGANIZATION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskOrganization.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_NUMBER(109, "TSK_CARD_NUMBER", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardNumber.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_EXPIRATION(110, "TSK_CARD_EXPIRATION", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardExpiration.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_SERVICE_CODE(111, "TSK_CARD_SERVICE_CODE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardServiceCode.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_DISCRETIONARY(112, "TSK_CARD_DISCRETIONARY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardDiscretionary.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_LRC(113, "TSK_CARD_LRC", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardLRC.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD_SEARCH_DOCUMENT_ID(114, "TSK_KEYWORD_SEARCH_DOCUMENT_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeywordSearchDocumentID.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_SCHEME(115, "TSK_CARD_SCHEME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardScheme.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CARD_TYPE(116, "TSK_CARD_TYPE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCardType.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_BRAND_NAME(117, "TSK_BRAND_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskBrandName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_BANK_NAME(118, "TSK_BANK_NAME", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskBankName.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_COUNTRY(119, "TSK_COUNTRY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCountry.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_CITY(120, "TSK_CITY", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskCity.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ACCOUNT_TYPE(121, "TSK_ACCOUNT_TYPE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskAccountType.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_KEYWORD_SEARCH_TYPE(122, "TSK_KEYWORD_SEARCH_TYPE", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskKeywordSearchType.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER),
        TSK_HEADERS(123, "TSK_HEADERS", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskHeaders.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ID(124, "TSK_ID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskId.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_SSID(125, "TSK_SSID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskSsid.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_BSSID(126, "TSK_BSSID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskBssid.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_MAC_ADDRESS(127, "TSK_MAC_ADDRESS", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskMacAddress.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_IMEI(128, "TSK_IMEI", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskImei.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_IMSI(129, "TSK_IMSI", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskImsi.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING),
        TSK_ICCID(130, "TSK_ICCID", BlackboardAttribute.access$000().getString("BlackboardAttribute.tskIccid.text"), TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING);

        private final int typeID;
        private final String typeName;
        private final String displayName;
        private final TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType;

        private ATTRIBUTE_TYPE(int typeID, String typeName, String displayName, TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType) {
            this.typeID = typeID;
            this.typeName = typeName;
            this.displayName = displayName;
            this.valueType = valueType;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public String getLabel() {
            return this.typeName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE getValueType() {
            return this.valueType;
        }

        public static ATTRIBUTE_TYPE fromID(int typeID) {
            for (ATTRIBUTE_TYPE attrType : ATTRIBUTE_TYPE.values()) {
                if (attrType.getTypeID() != typeID) continue;
                return attrType;
            }
            throw new IllegalArgumentException("No ATTRIBUTE_TYPE matching type: " + typeID);
        }

        public static ATTRIBUTE_TYPE fromLabel(String typeName) {
            for (ATTRIBUTE_TYPE attrType : ATTRIBUTE_TYPE.values()) {
                if (!attrType.getLabel().equals(typeName)) continue;
                return attrType;
            }
            throw new IllegalArgumentException("No ATTRIBUTE_TYPE matching type: " + typeName);
        }
    }

    public static enum TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE {
        STRING(0L, "String"),
        INTEGER(1L, "Integer"),
        LONG(2L, "Long"),
        DOUBLE(3L, "Double"),
        BYTE(4L, "Byte"),
        DATETIME(5L, "DateTime");

        private final long typeId;
        private final String typeName;

        private TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE(long type, String typeName) {
            this.typeId = type;
            this.typeName = typeName;
        }

        public long getType() {
            return this.typeId;
        }

        public String getLabel() {
            return this.typeName;
        }

        public static TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE fromType(long typeId) {
            for (TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType : TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.values()) {
                if (valueType.getType() != typeId) continue;
                return valueType;
            }
            throw new IllegalArgumentException("No TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE matching type: " + typeId);
        }

        public static TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE fromLabel(String typeName) {
            for (TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType : TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.values()) {
                if (!valueType.getLabel().equals(typeName)) continue;
                return valueType;
            }
            throw new IllegalArgumentException("No TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE matching type: " + typeName);
        }
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String typeName;
        private final int typeID;
        private final String displayName;
        private final TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType;

        public Type(int typeID, String typeName, String displayName, TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType) {
            this.typeID = typeID;
            this.typeName = typeName;
            this.displayName = displayName;
            this.valueType = valueType;
        }

        public Type(ATTRIBUTE_TYPE type) {
            this.typeID = type.getTypeID();
            this.typeName = type.getLabel();
            this.displayName = type.getDisplayName();
            this.valueType = type.getValueType();
        }

        public TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE getValueType() {
            return this.valueType;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Type)) {
                return false;
            }
            return ((Type)that).sameType(this);
        }

        private boolean sameType(Type that) {
            return this.typeName.equals(that.getTypeName()) && this.displayName.equals(that.getDisplayName()) && this.typeID == that.getTypeID() && this.valueType == that.getValueType();
        }

        public int hashCode() {
            int hash = 7;
            hash = 63 * hash + Objects.hashCode(this.typeID);
            hash = 63 * hash + Objects.hashCode(this.displayName);
            hash = 63 * hash + Objects.hashCode(this.typeName);
            hash = 63 * hash + Objects.hashCode((Object)this.valueType);
            return hash;
        }

        public String toString() {
            return "(typeID= " + this.typeID + ", displayName=" + this.displayName + ", typeName=" + this.typeName + ", valueType=" + (Object)((Object)this.valueType) + ")";
        }
    }
}

