/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitVisitableItem;
import org.sleuthkit.datamodel.TskCoreException;

public class BlackboardArtifact
implements Content {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final long artifactId;
    private final long sourceObjId;
    private final long artifactObjId;
    private final long dataSourceObjId;
    private final int artifactTypeId;
    private final String artifactTypeName;
    private final String displayName;
    private ReviewStatus reviewStatus;
    private final SleuthkitCase sleuthkitCase;
    private final List<BlackboardAttribute> attrsCache = new ArrayList<BlackboardAttribute>();
    private boolean loadedCacheFromDb = false;
    private Content parent;
    private String uniquePath;
    private byte[] contentBytes = null;
    private volatile boolean checkedHasChildren;
    private volatile boolean hasChildren;
    private volatile int childrenCount;

    BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long sourceObjId, long artifactObjId, long dataSourceObjId, int artifactTypeID, String artifactTypeName, String displayName, ReviewStatus reviewStatus) {
        this.sleuthkitCase = sleuthkitCase;
        this.artifactId = artifactID;
        this.sourceObjId = sourceObjId;
        this.artifactObjId = artifactObjId;
        this.artifactTypeId = artifactTypeID;
        this.dataSourceObjId = dataSourceObjId;
        this.artifactTypeName = artifactTypeName;
        this.displayName = displayName;
        this.reviewStatus = reviewStatus;
        this.checkedHasChildren = false;
        this.hasChildren = false;
        this.childrenCount = -1;
    }

    BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long sourceObjId, long artifactObjID, long dataSourceObjID, int artifactTypeID, String artifactTypeName, String displayName, ReviewStatus reviewStatus, boolean isNew) {
        this(sleuthkitCase, artifactID, sourceObjId, artifactObjID, dataSourceObjID, artifactTypeID, artifactTypeName, displayName, reviewStatus);
        if (isNew) {
            this.loadedCacheFromDb = true;
        }
    }

    public SleuthkitCase getSleuthkitCase() {
        return this.sleuthkitCase;
    }

    public long getArtifactID() {
        return this.artifactId;
    }

    public long getObjectID() {
        return this.sourceObjId;
    }

    long getDataSourceObjectID() {
        return this.dataSourceObjId;
    }

    public int getArtifactTypeID() {
        return this.artifactTypeId;
    }

    public String getArtifactTypeName() {
        return this.artifactTypeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() throws TskCoreException {
        BlackboardAttribute.ATTRIBUTE_TYPE[] typesThatCanHaveDate;
        BlackboardAttribute attr = null;
        StringBuilder shortDescription = new StringBuilder("");
        switch (ARTIFACT_TYPE.fromID(this.artifactTypeId)) {
            case TSK_WEB_BOOKMARK: 
            case TSK_WEB_COOKIE: 
            case TSK_WEB_DOWNLOAD: 
            case TSK_WEB_HISTORY: {
                attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN));
                break;
            }
            case TSK_KEYWORD_HIT: {
                attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_KEYWORD_PREVIEW));
                break;
            }
            case TSK_DEVICE_ATTACHED: {
                attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_ID));
                break;
            }
            case TSK_CONTACT: 
            case TSK_MESSAGE: 
            case TSK_CALLLOG: {
                BlackboardAttribute.ATTRIBUTE_TYPE t;
                BlackboardAttribute.ATTRIBUTE_TYPE[] typesThatCanHaveName;
                BlackboardAttribute.ATTRIBUTE_TYPE[] aTTRIBUTE_TYPEArray = typesThatCanHaveName = new BlackboardAttribute.ATTRIBUTE_TYPE[]{BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_HOME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_MOBILE, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_OFFICE, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_FROM, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_TO, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_HOME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_OFFICE};
                int n = aTTRIBUTE_TYPEArray.length;
                for (int i = 0; i < n && ((attr = this.getAttribute(new BlackboardAttribute.Type(t = aTTRIBUTE_TYPEArray[i]))) == null || attr.getDisplayString().isEmpty()); ++i) {
                }
                break;
            }
        }
        if (attr != null) {
            shortDescription.append(attr.getAttributeType().getDisplayName()).append(": ").append(attr.getDisplayString());
        } else {
            shortDescription.append(this.getDisplayName());
        }
        for (BlackboardAttribute.ATTRIBUTE_TYPE t : typesThatCanHaveDate = new BlackboardAttribute.ATTRIBUTE_TYPE[]{BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_SENT, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_RCVD, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_MODIFIED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END}) {
            BlackboardAttribute date = this.getAttribute(new BlackboardAttribute.Type(t));
            if (date == null || date.getDisplayString().isEmpty()) continue;
            shortDescription.append(" ");
            shortDescription.append(MessageFormat.format(bundle.getString("BlackboardArtifact.shortDescriptionDate.text"), date.getDisplayString()));
            break;
        }
        return shortDescription.toString();
    }

    public ReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(ReviewStatus newStatus) throws TskCoreException {
        this.getSleuthkitCase().setReviewStatus(this, newStatus);
        this.reviewStatus = newStatus;
    }

    public void addAttribute(BlackboardAttribute attribute) throws TskCoreException {
        attribute.setArtifactId(this.artifactId);
        attribute.setCaseDatabase(this.getSleuthkitCase());
        this.getSleuthkitCase().addBlackboardAttribute(attribute, this.artifactTypeId);
        this.attrsCache.add(attribute);
    }

    public List<BlackboardAttribute> getAttributes() throws TskCoreException {
        ArrayList<BlackboardAttribute> attributes;
        if (!this.loadedCacheFromDb) {
            attributes = this.getSleuthkitCase().getBlackboardAttributes(this);
            this.attrsCache.clear();
            this.attrsCache.addAll(attributes);
            this.loadedCacheFromDb = true;
        } else {
            attributes = new ArrayList<BlackboardAttribute>(this.attrsCache);
        }
        return attributes;
    }

    public BlackboardAttribute getAttribute(BlackboardAttribute.Type attributeType) throws TskCoreException {
        List<BlackboardAttribute> attributes = this.getAttributes();
        for (BlackboardAttribute attribute : attributes) {
            if (!attribute.getAttributeType().equals(attributeType)) continue;
            return attribute;
        }
        return null;
    }

    public void addAttributes(Collection<BlackboardAttribute> attributes) throws TskCoreException {
        if (attributes.isEmpty()) {
            return;
        }
        for (BlackboardAttribute attribute : attributes) {
            attribute.setArtifactId(this.artifactId);
            attribute.setCaseDatabase(this.getSleuthkitCase());
        }
        this.getSleuthkitCase().addBlackboardAttributes(attributes, this.artifactTypeId);
        this.attrsCache.addAll(attributes);
    }

    @Override
    public synchronized String getUniquePath() throws TskCoreException {
        if (this.uniquePath == null) {
            this.uniquePath = "";
            Content myParent = this.getParent();
            if (myParent != null) {
                this.uniquePath = myParent.getUniquePath();
            }
        }
        return this.uniquePath;
    }

    @Override
    public synchronized Content getParent() throws TskCoreException {
        if (this.parent == null) {
            SleuthkitCase.ObjectInfo parentInfo = this.getSleuthkitCase().getParentInfo(this);
            this.parent = parentInfo == null ? null : this.getSleuthkitCase().getContentById(parentInfo.getId());
        }
        return this.parent;
    }

    @Override
    public ArrayList<BlackboardArtifact> getAllArtifacts() throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(String artifactTypeName) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(int artifactTypeID) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(ARTIFACT_TYPE type) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public long getAllArtifactsCount() throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(String artifactTypeName) throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(int artifactTypeID) throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(ARTIFACT_TYPE type) throws TskCoreException {
        return 0L;
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact() throws TskCoreException {
        return null;
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact(boolean create) throws TskCoreException {
        if (create) {
            throw new TskCoreException("Artifacts of artifacts are not supported.");
        }
        return null;
    }

    @Override
    public ArrayList<BlackboardAttribute> getGenInfoAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attr_type) throws TskCoreException {
        return new ArrayList<BlackboardAttribute>();
    }

    @Override
    public Set<String> getHashSetNames() throws TskCoreException {
        return new HashSet<String>();
    }

    @Override
    public BlackboardArtifact newArtifact(int artifactTypeID) throws TskCoreException {
        throw new TskCoreException("Cannot create artifact of an artifact. Not supported.");
    }

    @Override
    public BlackboardArtifact newArtifact(ARTIFACT_TYPE type) throws TskCoreException {
        throw new TskCoreException("Cannot create artifact of an artifact. Not supported.");
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BlackboardArtifact other = (BlackboardArtifact)object;
        return this.artifactId == other.getArtifactID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (int)(this.artifactId ^ this.artifactId >>> 32);
        return hash;
    }

    public String toString() {
        return "BlackboardArtifact{artifactID=" + this.artifactId + ", objID=" + this.getObjectID() + ", artifactObjID=" + this.artifactObjId + ", artifactTypeID=" + this.artifactTypeId + ", artifactTypeName=" + this.artifactTypeName + ", displayName=" + this.displayName + ", Case=" + this.getSleuthkitCase() + '}';
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public long getSize() {
        if (this.contentBytes == null) {
            try {
                this.loadArtifactContent();
            }
            catch (TskCoreException ex) {
                return 0L;
            }
        }
        return this.contentBytes.length;
    }

    @Override
    public void close() {
        this.contentBytes = null;
    }

    @Override
    public final int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.contentBytes == null) {
            this.loadArtifactContent();
        }
        if (0 == this.contentBytes.length) {
            return 0;
        }
        long readLen = Math.min((long)this.contentBytes.length - offset, len);
        System.arraycopy(this.contentBytes, 0, buf, 0, (int)readLen);
        return (int)readLen;
    }

    @Override
    public String getName() {
        return this.displayName + this.getArtifactID();
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        Content myParent = this.getParent();
        if (myParent == null) {
            return null;
        }
        return myParent.getDataSource();
    }

    private void loadArtifactContent() throws TskCoreException {
        StringBuilder artifactContents = new StringBuilder();
        Content dataSource = null;
        try {
            dataSource = this.getDataSource();
        }
        catch (TskCoreException ex) {
            throw new TskCoreException("Unable to get datasource for artifact: " + this.toString(), ex);
        }
        if (dataSource == null) {
            throw new TskCoreException("Datasource was null for artifact: " + this.toString());
        }
        try {
            for (BlackboardAttribute attribute : this.getAttributes()) {
                artifactContents.append(attribute.getAttributeType().getDisplayName());
                artifactContents.append(" : ");
                artifactContents.append(attribute.getDisplayString());
                artifactContents.append(System.lineSeparator());
            }
        }
        catch (TskCoreException ex) {
            throw new TskCoreException("Unable to get attributes for artifact: " + this.toString(), ex);
        }
        try {
            this.contentBytes = artifactContents.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TskCoreException("Failed to convert artifact string to bytes for artifact: " + this.toString(), ex);
        }
    }

    @Deprecated
    protected BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long objID, long artifactObjID, long dataSourceObjId, int artifactTypeID, String artifactTypeName, String displayName) {
        this(sleuthkitCase, artifactID, objID, artifactObjID, dataSourceObjId, artifactTypeID, artifactTypeName, displayName, ReviewStatus.UNDECIDED);
    }

    @Deprecated
    public List<BlackboardAttribute> getAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attributeType) throws TskCoreException {
        if (!this.loadedCacheFromDb) {
            ArrayList<BlackboardAttribute> attrs = this.getSleuthkitCase().getBlackboardAttributes(this);
            this.attrsCache.clear();
            this.attrsCache.addAll(attrs);
            this.loadedCacheFromDb = true;
        }
        ArrayList<BlackboardAttribute> filteredAttributes = new ArrayList<BlackboardAttribute>();
        for (BlackboardAttribute attr : this.attrsCache) {
            if (attr.getAttributeType().getTypeID() != attributeType.getTypeID()) continue;
            filteredAttributes.add(attr);
        }
        return filteredAttributes;
    }

    @Override
    public long getId() {
        return this.artifactObjId;
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        ArrayList<Long> childrenIDs = new ArrayList<Long>();
        childrenIDs.addAll(this.getSleuthkitCase().getAbstractFileChildrenIds(this));
        childrenIDs.addAll(this.getSleuthkitCase().getBlackboardArtifactChildrenIds(this));
        return childrenIDs;
    }

    @Override
    public int getChildrenCount() throws TskCoreException {
        if (this.childrenCount != -1) {
            return this.childrenCount;
        }
        this.childrenCount = this.getSleuthkitCase().getContentChildrenCount(this);
        this.hasChildren = this.childrenCount > 0;
        this.checkedHasChildren = true;
        return this.childrenCount;
    }

    @Override
    public boolean hasChildren() throws TskCoreException {
        if (this.checkedHasChildren) {
            return this.hasChildren;
        }
        this.childrenCount = this.getSleuthkitCase().getContentChildrenCount(this);
        this.hasChildren = this.childrenCount > 0;
        this.checkedHasChildren = true;
        return this.hasChildren;
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        ArrayList<Content> children = new ArrayList<Content>();
        children.addAll(this.getSleuthkitCase().getAbstractFileChildren(this));
        children.addAll(this.getSleuthkitCase().getBlackboardArtifactChildren(this));
        return children;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return bundle;
    }

    public static enum ReviewStatus {
        APPROVED(1, "APPROVED", "ReviewStatus.Approved"),
        REJECTED(2, "REJECTED", "ReviewStatus.Rejected"),
        UNDECIDED(3, "UNDECIDED", "ReviewStatus.Undecided");

        private final Integer id;
        private final String name;
        private final String displayName;
        private static final Map<Integer, ReviewStatus> idToStatus;

        private ReviewStatus(Integer id, String name, String displayNameKey) {
            this.id = id;
            this.name = name;
            this.displayName = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle").getString(displayNameKey);
        }

        public static ReviewStatus withID(int id) {
            return idToStatus.get(id);
        }

        public Integer getID() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        static {
            idToStatus = new HashMap<Integer, ReviewStatus>();
            for (ReviewStatus status : ReviewStatus.values()) {
                idToStatus.put(status.getID(), status);
            }
        }
    }

    public static enum ARTIFACT_TYPE implements SleuthkitVisitableItem
    {
        TSK_GEN_INFO(1, "TSK_GEN_INFO", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGenInfo.text")),
        TSK_WEB_BOOKMARK(2, "TSK_WEB_BOOKMARK", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebBookmark.text")),
        TSK_WEB_COOKIE(3, "TSK_WEB_COOKIE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebCookie.text")),
        TSK_WEB_HISTORY(4, "TSK_WEB_HISTORY", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebHistory.text")),
        TSK_WEB_DOWNLOAD(5, "TSK_WEB_DOWNLOAD", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebDownload.text")),
        TSK_RECENT_OBJECT(6, "TSK_RECENT_OBJ", BlackboardArtifact.access$000().getString("BlackboardArtifact.tsk.recentObject.text")),
        TSK_GPS_TRACKPOINT(7, "TSK_GPS_TRACKPOINT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGpsTrackpoint.text")),
        TSK_INSTALLED_PROG(8, "TSK_INSTALLED_PROG", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskInstalledProg.text")),
        TSK_KEYWORD_HIT(9, "TSK_KEYWORD_HIT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskKeywordHits.text")),
        TSK_HASHSET_HIT(10, "TSK_HASHSET_HIT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskHashsetHit.text")),
        TSK_DEVICE_ATTACHED(11, "TSK_DEVICE_ATTACHED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskDeviceAttached.text")),
        TSK_INTERESTING_FILE_HIT(12, "TSK_INTERESTING_FILE_HIT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskInterestingFileHit.text")),
        TSK_EMAIL_MSG(13, "TSK_EMAIL_MSG", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskEmailMsg.text")),
        TSK_EXTRACTED_TEXT(14, "TSK_EXTRACTED_TEXT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskExtractedText.text")),
        TSK_WEB_SEARCH_QUERY(15, "TSK_WEB_SEARCH_QUERY", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebSearchQuery.text")),
        TSK_METADATA_EXIF(16, "TSK_METADATA_EXIF", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskMetadataExif.text")),
        TSK_TAG_FILE(17, "TSK_TAG_FILE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tagFile.text")),
        TSK_TAG_ARTIFACT(18, "TSK_TAG_ARTIFACT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskTagArtifact.text")),
        TSK_OS_INFO(19, "TSK_OS_INFO", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskOsInfo.text")),
        TSK_OS_ACCOUNT(20, "TSK_OS_ACCOUNT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskOsAccount.text")),
        TSK_SERVICE_ACCOUNT(21, "TSK_SERVICE_ACCOUNT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskServiceAccount.text")),
        TSK_TOOL_OUTPUT(22, "TSK_TOOL_OUTPUT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskToolOutput.text")),
        TSK_CONTACT(23, "TSK_CONTACT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskContact.text")),
        TSK_MESSAGE(24, "TSK_MESSAGE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskMessage.text")),
        TSK_CALLLOG(25, "TSK_CALLLOG", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskCalllog.text")),
        TSK_CALENDAR_ENTRY(26, "TSK_CALENDAR_ENTRY", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskCalendarEntry.text")),
        TSK_SPEED_DIAL_ENTRY(27, "TSK_SPEED_DIAL_ENTRY", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskSpeedDialEntry.text")),
        TSK_BLUETOOTH_PAIRING(28, "TSK_BLUETOOTH_PAIRING", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskBluetoothPairing.text")),
        TSK_GPS_BOOKMARK(29, "TSK_GPS_BOOKMARK", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGpsBookmark.text")),
        TSK_GPS_LAST_KNOWN_LOCATION(30, "TSK_GPS_LAST_KNOWN_LOCATION", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGpsLastKnownLocation.text")),
        TSK_GPS_SEARCH(31, "TSK_GPS_SEARCH", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGpsSearch.text")),
        TSK_PROG_RUN(32, "TSK_PROG_RUN", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskProgRun.text")),
        TSK_ENCRYPTION_DETECTED(33, "TSK_ENCRYPTION_DETECTED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskEncryptionDetected.text")),
        TSK_EXT_MISMATCH_DETECTED(34, "TSK_EXT_MISMATCH_DETECTED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskExtMismatchDetected.text")),
        TSK_INTERESTING_ARTIFACT_HIT(35, "TSK_INTERESTING_ARTIFACT_HIT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskInterestingArtifactHit.text")),
        TSK_GPS_ROUTE(36, "TSK_GPS_ROUTE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskGpsRoute.text")),
        TSK_REMOTE_DRIVE(37, "TSK_REMOTE_DRIVE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskRemoteDrive.text")),
        TSK_FACE_DETECTED(38, "TSK_FACE_DETECTED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskFaceDetected.text")),
        TSK_ACCOUNT(39, "TSK_ACCOUNT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskAccount.text")),
        TSK_ENCRYPTION_SUSPECTED(40, "TSK_ENCRYPTION_SUSPECTED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskEncryptionSuspected.text")),
        TSK_OBJECT_DETECTED(41, "TSK_OBJECT_DETECTED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskObjectDetected.text")),
        TSK_WIFI_NETWORK(42, "TSK_WIFI_NETWORK", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWIFINetwork.text")),
        TSK_DEVICE_INFO(43, "TSK_DEVICE_INFO", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskDeviceInfo.text")),
        TSK_SIM_ATTACHED(44, "TSK_SIM_ATTACHED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskSimAttached.text")),
        TSK_BLUETOOTH_ADAPTER(45, "TSK_BLUETOOTH_ADAPTER", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskBluetoothAdapter.text")),
        TSK_WIFI_NETWORK_ADAPTER(46, "TSK_WIFI_NETWORK_ADAPTER", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWIFINetworkAdapter.text")),
        TSK_VERIFICATION_FAILED(47, "TSK_VERIFICATION_FAILED", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskVerificationFailed.text")),
        TSK_DATA_SOURCE_USAGE(48, "TSK_DATA_SOURCE_USAGE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskDataSourceUsage.text")),
        TSK_WEB_FORM_AUTOFILL(49, "TSK_WEB_FORM_AUTOFILL", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebFormAutofill.text")),
        TSK_WEB_FORM_ADDRESS(50, "TSK_WEB_FORM_ADDRESSES ", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebFormAddresses.text")),
        TSK_DOWNLOAD_SOURCE(51, "TSK_DOWNLOAD_SOURCE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskDownloadSource.text")),
        TSK_WEB_CACHE(52, "TSK_WEB_CACHE", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskWebCache.text")),
        TSK_CLIPBOARD_CONTENT(53, "TSK_CLIPBOARD_CONTENT", BlackboardArtifact.access$000().getString("BlackboardArtifact.tskClipboardContent.text"));

        private final String label;
        private final int typeId;
        private final String displayName;

        private ARTIFACT_TYPE(int typeId, String label, String displayName) {
            this.typeId = typeId;
            this.label = label;
            this.displayName = displayName;
        }

        public int getTypeID() {
            return this.typeId;
        }

        public String getLabel() {
            return this.label;
        }

        public static ARTIFACT_TYPE fromLabel(String label) {
            for (ARTIFACT_TYPE value : ARTIFACT_TYPE.values()) {
                if (!value.getLabel().equals(label)) continue;
                return value;
            }
            throw new IllegalArgumentException("No ARTIFACT_TYPE matching type: " + label);
        }

        public static ARTIFACT_TYPE fromID(int id) {
            for (ARTIFACT_TYPE value : ARTIFACT_TYPE.values()) {
                if (value.getTypeID() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No ARTIFACT_TYPE matching type: " + id);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public <T> T accept(SleuthkitItemVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String typeName;
        private final int typeID;
        private final String displayName;

        public Type(int typeID, String typeName, String displayName) {
            this.typeID = typeID;
            this.typeName = typeName;
            this.displayName = displayName;
        }

        public Type(ARTIFACT_TYPE type) {
            this(type.getTypeID(), type.getLabel(), type.getDisplayName());
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Type)) {
                return false;
            }
            return ((Type)that).sameType(this);
        }

        private boolean sameType(Type that) {
            return this.typeName.equals(that.getTypeName()) && this.displayName.equals(that.getDisplayName()) && this.typeID == that.getTypeID();
        }

        public int hashCode() {
            int hash = 11;
            hash = 83 * hash + Objects.hashCode(this.typeID);
            hash = 83 * hash + Objects.hashCode(this.displayName);
            hash = 83 * hash + Objects.hashCode(this.typeName);
            return hash;
        }
    }
}

