/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.EncodedFileUtil;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimeUtilities;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskFileRange;

public abstract class AbstractFile
extends AbstractContent {
    protected final TskData.TSK_DB_FILES_TYPE_ENUM fileType;
    protected final TskData.TSK_FS_NAME_TYPE_ENUM dirType;
    protected final TskData.TSK_FS_META_TYPE_ENUM metaType;
    protected final TskData.TSK_FS_NAME_FLAG_ENUM dirFlag;
    protected final Set<TskData.TSK_FS_META_FLAG_ENUM> metaFlags;
    protected long size;
    protected final long metaAddr;
    protected final long ctime;
    protected final long crtime;
    protected final long atime;
    protected final long mtime;
    protected final int metaSeq;
    protected final int uid;
    protected final int gid;
    protected final int attrId;
    protected final TskData.TSK_FS_ATTR_TYPE_ENUM attrType;
    protected final Set<TskData.TSK_FS_META_MODE_ENUM> modes;
    private boolean localPathSet = false;
    private String localPath;
    private String localAbsPath;
    private volatile RandomAccessFile localFileHandle;
    private volatile File localFile;
    private TskData.EncodingType encodingType;
    private List<TskFileRange> ranges;
    protected final String parentPath;
    protected TskData.FileKnown knownState;
    private boolean knownStateDirty = false;
    protected String md5Hash;
    private boolean md5HashDirty = false;
    private String mimeType;
    private boolean mimeTypeDirty = false;
    private static final Logger LOGGER = Logger.getLogger(AbstractFile.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private long dataSourceObjectId;
    private final String extension;

    AbstractFile(SleuthkitCase db, long objId, long dataSourceObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String extension) {
        super(db, objId, name);
        this.dataSourceObjectId = dataSourceObjectId;
        this.attrType = attrType;
        this.attrId = attrId;
        this.fileType = fileType;
        this.metaAddr = metaAddr;
        this.metaSeq = metaSeq;
        this.dirType = dirType;
        this.metaType = metaType;
        this.dirFlag = dirFlag;
        this.metaFlags = TskData.TSK_FS_META_FLAG_ENUM.valuesOf(metaFlags);
        this.size = size;
        this.ctime = ctime;
        this.crtime = crtime;
        this.atime = atime;
        this.mtime = mtime;
        this.uid = uid;
        this.gid = gid;
        this.modes = TskData.TSK_FS_META_MODE_ENUM.valuesOf(modes);
        this.md5Hash = md5Hash;
        this.knownState = knownState == null ? TskData.FileKnown.UNKNOWN : knownState;
        this.parentPath = parentPath;
        this.mimeType = mimeType;
        this.extension = extension == null ? "" : extension;
        this.encodingType = TskData.EncodingType.NONE;
    }

    public TskData.TSK_DB_FILES_TYPE_ENUM getType() {
        return this.fileType;
    }

    public TskData.TSK_FS_ATTR_TYPE_ENUM getAttrType() {
        return this.attrType;
    }

    public int getAttributeId() {
        return this.attrId;
    }

    public long getCtime() {
        return this.ctime;
    }

    public String getCtimeAsDate() {
        return AbstractFile.epochToTime(this.ctime);
    }

    public long getCrtime() {
        return this.crtime;
    }

    public String getCrtimeAsDate() {
        return AbstractFile.epochToTime(this.crtime);
    }

    public long getAtime() {
        return this.atime;
    }

    public String getAtimeAsDate() {
        return AbstractFile.epochToTime(this.atime);
    }

    public long getMtime() {
        return this.mtime;
    }

    public String getMtimeAsDate() {
        return AbstractFile.epochToTime(this.mtime);
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public long getMetaAddr() {
        return this.metaAddr;
    }

    public long getMetaSeq() {
        return this.metaSeq;
    }

    public String getModesAsString() {
        short mode = TskData.TSK_FS_META_MODE_ENUM.toInt(this.modes);
        String result = "";
        short isuid = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISUID.getMode();
        short isgid = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISGID.getMode();
        short isvtx = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISVTX.getMode();
        short irusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IRUSR.getMode();
        short iwusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWUSR.getMode();
        short ixusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXUSR.getMode();
        short irgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IRGRP.getMode();
        short iwgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWGRP.getMode();
        short ixgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXGRP.getMode();
        short iroth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IROTH.getMode();
        short iwoth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWOTH.getMode();
        short ixoth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXOTH.getMode();
        result = result + this.metaType.toString();
        result = (mode & irusr) == irusr ? result + "r" : result + "-";
        result = (mode & iwusr) == iwusr ? result + "w" : result + "-";
        result = (mode & isuid) == isuid ? ((mode & ixusr) == ixusr ? result + "s" : result + "S") : ((mode & ixusr) == ixusr ? result + "x" : result + "-");
        result = (mode & irgrp) == irgrp ? result + "r" : result + "-";
        result = (mode & iwgrp) == iwgrp ? result + "w" : result + "-";
        result = (mode & isgid) == isgid ? ((mode & ixgrp) == ixgrp ? result + "s" : result + "S") : ((mode & ixgrp) == ixgrp ? result + "x" : result + "-");
        result = (mode & iroth) == iroth ? result + "r" : result + "-";
        result = (mode & iwoth) == iwoth ? result + "w" : result + "-";
        result = (mode & isvtx) == isvtx ? ((mode & ixoth) == ixoth ? result + "t" : result + "T") : ((mode & ixoth) == ixoth ? result + "x" : result + "-");
        if (result.length() != 10) {
            result = "ERROR";
        }
        return result;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
        this.mimeTypeDirty = true;
    }

    public boolean isModeSet(TskData.TSK_FS_META_MODE_ENUM mode) {
        return this.modes.contains((Object)mode);
    }

    public void setMd5Hash(String md5Hash) {
        this.md5Hash = md5Hash;
        this.md5HashDirty = true;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public void setKnown(TskData.FileKnown knownState) {
        if (this.knownState.compareTo(knownState) > 0) {
            return;
        }
        this.knownState = knownState;
        this.knownStateDirty = true;
    }

    public TskData.FileKnown getKnown() {
        return this.knownState;
    }

    public String getNameExtension() {
        return this.extension;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        return this.getSleuthkitCase().getContentById(this.dataSourceObjectId);
    }

    public long getDataSourceObjectId() {
        return this.dataSourceObjectId;
    }

    public List<TskFileRange> getRanges() throws TskCoreException {
        if (this.ranges == null) {
            this.ranges = this.getSleuthkitCase().getFileRanges(this.getId());
        }
        return this.ranges;
    }

    public long convertToImgOffset(long fileOffset) throws TskCoreException {
        long imgOffset = -1L;
        for (TskFileRange byteRange : this.getRanges()) {
            long rangeLength = byteRange.getByteLen();
            if (fileOffset < rangeLength) {
                imgOffset = byteRange.getByteStart() + fileOffset;
                break;
            }
            fileOffset -= rangeLength;
        }
        return imgOffset;
    }

    public boolean isVirtual() {
        return this.fileType.equals((Object)TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR) || this.dirType.equals((Object)TskData.TSK_FS_NAME_TYPE_ENUM.VIRT) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT);
    }

    public boolean isFile() {
        return this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_UNDEF) && this.dirType.equals((Object)TskData.TSK_FS_NAME_TYPE_ENUM.REG);
    }

    public boolean isDir() {
        return this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR);
    }

    public abstract boolean isRoot();

    public static String createNonUniquePath(String uniquePath) {
        String[] pathSegments = uniquePath.split("/");
        int index = 0;
        if (pathSegments[0].startsWith("img_")) {
            ++index;
        }
        if (pathSegments[1].startsWith("vol_")) {
            ++index;
        }
        StringBuilder strbuf = new StringBuilder();
        while (index < pathSegments.length) {
            if (!pathSegments[index].isEmpty()) {
                strbuf.append("/").append(pathSegments[index]);
            }
            ++index;
        }
        return strbuf.toString();
    }

    public List<AbstractFile> listFiles() throws TskCoreException {
        List<Content> children = this.getChildren();
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        for (Content child : children) {
            if (!(child instanceof AbstractFile)) continue;
            AbstractFile afChild = (AbstractFile)child;
            files.add(afChild);
        }
        return files;
    }

    public TskData.TSK_FS_META_TYPE_ENUM getMetaType() {
        return this.metaType;
    }

    public String getMetaTypeAsString() {
        return this.metaType.toString();
    }

    public TskData.TSK_FS_NAME_TYPE_ENUM getDirType() {
        return this.dirType;
    }

    public String getDirTypeAsString() {
        return this.dirType.toString();
    }

    public boolean isDirNameFlagSet(TskData.TSK_FS_NAME_FLAG_ENUM flag) {
        return this.dirFlag == flag;
    }

    public String getDirFlagAsString() {
        return this.dirFlag.toString();
    }

    public String getMetaFlagsAsString() {
        String str = "";
        if (this.metaFlags.contains((Object)TskData.TSK_FS_META_FLAG_ENUM.ALLOC)) {
            str = TskData.TSK_FS_META_FLAG_ENUM.ALLOC.toString();
        } else if (this.metaFlags.contains((Object)TskData.TSK_FS_META_FLAG_ENUM.UNALLOC)) {
            str = TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.toString();
        }
        return str;
    }

    public boolean isMetaFlagSet(TskData.TSK_FS_META_FLAG_ENUM metaFlag) {
        return this.metaFlags.contains((Object)metaFlag);
    }

    @Override
    public final int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.localPathSet) {
            return this.readLocal(buf, offset, len);
        }
        return this.readInt(buf, offset, len);
    }

    protected int readInt(byte[] buf, long offset, long len) throws TskCoreException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int readLocal(byte[] buf, long offset, long len) throws TskCoreException {
        if (!this.localPathSet) {
            throw new TskCoreException(BUNDLE.getString("AbstractFile.readLocal.exception.msg1.text"));
        }
        if (this.isDir()) {
            return 0;
        }
        if (this.getSize() == 0L) {
            return 0;
        }
        this.loadLocalFile();
        if (!this.localFile.exists()) {
            throw new TskCoreException(MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg2.text"), this.localAbsPath));
        }
        if (!this.localFile.canRead()) {
            throw new TskCoreException(MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg3.text"), this.localAbsPath));
        }
        int bytesRead = 0;
        if (this.localFileHandle == null) {
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.localFileHandle == null) {
                    try {
                        this.localFileHandle = new RandomAccessFile(this.localFile, "r");
                    }
                    catch (FileNotFoundException ex) {
                        String msg = MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg4.text"), this.localAbsPath);
                        LOGGER.log(Level.SEVERE, msg, ex);
                        throw new TskCoreException(msg, ex);
                    }
                }
            }
        }
        try {
            if (!this.encodingType.equals((Object)TskData.EncodingType.NONE)) {
                long encodedOffset = offset + (long)EncodedFileUtil.getHeaderLength();
                long curOffset = this.localFileHandle.getFilePointer();
                if (curOffset != encodedOffset) {
                    this.localFileHandle.seek(encodedOffset);
                }
                bytesRead = this.localFileHandle.read(buf, 0, (int)len);
                for (int i = 0; i < bytesRead; ++i) {
                    buf[i] = EncodedFileUtil.decodeByte(buf[i], this.encodingType);
                }
                return bytesRead;
            }
            long curOffset = this.localFileHandle.getFilePointer();
            if (curOffset != offset) {
                this.localFileHandle.seek(offset);
            }
            return this.localFileHandle.read(buf, 0, (int)len);
        }
        catch (IOException ex) {
            String msg = MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg5.text"), this.localAbsPath);
            LOGGER.log(Level.SEVERE, msg, ex);
            throw new TskCoreException(msg, ex);
        }
    }

    void setLocalFilePath(String localPath) {
        if (localPath == null || localPath.equals("")) {
            this.localPath = "";
            this.localAbsPath = null;
            this.localPathSet = false;
        } else {
            this.localPath = localPath;
            this.localAbsPath = this instanceof DerivedFile ? this.getSleuthkitCase().getDbDirPath() + File.separator + localPath : (localPath.startsWith("/") || localPath.startsWith("\\") || localPath.matches("[A-Za-z]:[/\\\\].*") ? localPath : this.getSleuthkitCase().getDbDirPath() + File.separator + localPath);
            this.localPathSet = true;
        }
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getLocalAbsPath() {
        return this.localAbsPath;
    }

    final void setEncodingType(TskData.EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public boolean exists() {
        if (!this.localPathSet) {
            return true;
        }
        try {
            this.loadLocalFile();
            return this.localFile.exists();
        }
        catch (TskCoreException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            return false;
        }
    }

    public boolean canRead() {
        if (!this.localPathSet) {
            return true;
        }
        try {
            this.loadLocalFile();
            return this.localFile.canRead();
        }
        catch (TskCoreException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalFile() throws TskCoreException {
        if (!this.localPathSet) {
            throw new TskCoreException(BUNDLE.getString("AbstractFile.readLocal.exception.msg1.text"));
        }
        if (this.localFile != null) {
            return;
        }
        AbstractFile abstractFile = this;
        synchronized (abstractFile) {
            if (this.localFile == null) {
                this.localFile = new File(this.localAbsPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.localFileHandle != null) {
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.localFileHandle != null) {
                    try {
                        this.localFileHandle.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Could not close file handle for file: " + this.getParentPath() + this.getName(), ex);
                    }
                    this.localFileHandle = null;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "AbstractFile [\t\tfileType " + (Object)((Object)this.fileType) + "\tctime " + this.ctime + "\tcrtime " + this.crtime + "\tmtime " + this.mtime + "\tatime " + this.atime + "\tattrId " + this.attrId + "\tattrType " + (Object)((Object)this.attrType) + "\tdirFlag " + (Object)((Object)this.dirFlag) + "\tdirType " + (Object)((Object)this.dirType) + "\tuid " + this.uid + "\tgid " + this.gid + "\tmetaAddr " + this.metaAddr + "\tmetaSeq " + this.metaSeq + "\tmetaFlags " + this.metaFlags + "\tmetaType " + (Object)((Object)this.metaType) + "\tmodes " + this.modes + "\tparentPath " + this.parentPath + "\tsize " + this.size + "\tknownState " + (Object)((Object)this.knownState) + "\tmd5Hash " + this.md5Hash + "\tlocalPathSet " + this.localPathSet + "\tlocalPath " + this.localPath + "\tlocalAbsPath " + this.localAbsPath + "\tlocalFile " + this.localFile + "]\t";
    }

    public MimeMatchEnum isMimeType(SortedSet<String> mimeTypes) {
        if (this.mimeType == null) {
            return MimeMatchEnum.UNDEFINED;
        }
        if (mimeTypes.contains(this.mimeType)) {
            return MimeMatchEnum.TRUE;
        }
        return MimeMatchEnum.FALSE;
    }

    public void save() throws TskCoreException {
        if (!(this.md5HashDirty || this.mimeTypeDirty || this.knownStateDirty)) {
            return;
        }
        String queryStr = "";
        if (this.mimeTypeDirty) {
            queryStr = "mime_type = '" + this.getMIMEType() + "'";
        }
        if (this.md5HashDirty) {
            if (!queryStr.isEmpty()) {
                queryStr = queryStr + ", ";
            }
            queryStr = queryStr + "md5 = '" + this.getMd5Hash() + "'";
        }
        if (this.knownStateDirty) {
            if (!queryStr.isEmpty()) {
                queryStr = queryStr + ", ";
            }
            queryStr = queryStr + "known = '" + this.getKnown().getFileKnownValue() + "'";
        }
        queryStr = "UPDATE tsk_files SET " + queryStr + " WHERE obj_id = " + this.getId();
        SleuthkitCase.CaseDbConnection connection = this.getSleuthkitCase().getConnection();
        Statement statement = null;
        this.getSleuthkitCase().acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            connection.executeUpdate(statement, queryStr);
            this.md5HashDirty = false;
            this.mimeTypeDirty = false;
            this.knownStateDirty = false;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error saving properties for file (obj_id = %s)", this.getId()), ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            connection.close();
            this.getSleuthkitCase().releaseSingleUserCaseWriteLock();
        }
    }

    @Deprecated
    protected AbstractFile(SleuthkitCase db, long objId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, short attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, TskData.FileKnown knownState, String parentPath) {
        this(db, objId, db.getDataSourceObjectId(objId), attrType, attrId, name, fileType, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, knownState, parentPath, null, null);
    }

    @Deprecated
    AbstractFile(SleuthkitCase db, long objId, long dataSourceObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, short attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, TskData.FileKnown knownState, String parentPath, String mimeType) {
        this(db, objId, dataSourceObjectId, attrType, attrId, name, fileType, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, knownState, parentPath, null, null);
    }

    @Deprecated
    public short getAttrId() {
        return (short)this.attrId;
    }

    @Deprecated
    protected void setLocalPath(String localPath, boolean isAbsolute) {
        this.setLocalFilePath(localPath);
    }

    @Deprecated
    public static String epochToTime(long epoch) {
        return TimeUtilities.epochToTime(epoch);
    }

    @Deprecated
    public static String epochToTime(long epoch, TimeZone tzone) {
        return TimeUtilities.epochToTime(epoch, tzone);
    }

    @Deprecated
    public static long timeToEpoch(String time) {
        return TimeUtilities.timeToEpoch(time);
    }

    public static enum MimeMatchEnum {
        UNDEFINED,
        TRUE,
        FALSE;

    }
}

