/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.util.DirectoryFileFilter;
import ro.fortsoft.pf4j.util.JarFileFilter;
import ro.fortsoft.pf4j.util.Unzip;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final List<String> ZIP_EXTENSIONS = Arrays.asList(".zip", ".ZIP", ".Zip");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, boolean ignoreComments) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return new ArrayList<String>();
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!ignoreComments || line.startsWith("#") || lines.contains(line)) continue;
                lines.add(line);
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Collection<String> lines, File file) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(file));
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    public static void delete(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isSymbolicLink()) {
                    Files.delete(path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<File> getJars(Path folder) {
        ArrayList<File> bucket = new ArrayList<File>();
        FileUtils.getJars(bucket, folder);
        return bucket;
    }

    private static void getJars(List<File> bucket, Path folder) {
        JarFileFilter jarFilter = new JarFileFilter();
        DirectoryFileFilter directoryFilter = new DirectoryFileFilter();
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            File[] jars = folder.toFile().listFiles(jarFilter);
            for (int i = 0; jars != null && i < jars.length; ++i) {
                bucket.add(jars[i]);
            }
            File[] directories = folder.toFile().listFiles(directoryFilter);
            for (int i = 0; directories != null && i < directories.length; ++i) {
                File directory = directories[i];
                FileUtils.getJars(bucket, directory.toPath());
            }
        }
    }

    public static Path findWithEnding(Path basePath, String ... endings) {
        for (String ending : endings) {
            Path newPath = basePath.resolveSibling(basePath.getFileName() + ending);
            if (!Files.exists(newPath, new LinkOption[0])) continue;
            return newPath;
        }
        return null;
    }

    public static void optimisticDelete(Path path) {
        if (path == null) {
            return;
        }
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Path expandIfZip(Path filePath) throws IOException {
        if (!FileUtils.isZipFile(filePath)) {
            return filePath;
        }
        FileTime pluginZipDate = Files.getLastModifiedTime(filePath, new LinkOption[0]);
        String fileName = filePath.getFileName().toString();
        Path pluginDirectory = filePath.resolveSibling(fileName.substring(0, fileName.lastIndexOf(".")));
        if (!Files.exists(pluginDirectory, new LinkOption[0]) || pluginZipDate.compareTo(Files.getLastModifiedTime(pluginDirectory, new LinkOption[0])) > 0) {
            if (Files.exists(pluginDirectory, new LinkOption[0])) {
                FileUtils.delete(pluginDirectory);
            }
            Files.createDirectories(pluginDirectory, new FileAttribute[0]);
            Unzip unzip = new Unzip();
            unzip.setSource(filePath.toFile());
            unzip.setDestination(pluginDirectory.toFile());
            unzip.extract();
            log.info("Expanded plugin zip '{}' in '{}'", (Object)filePath.getFileName(), (Object)pluginDirectory.getFileName());
        }
        return pluginDirectory;
    }

    public static boolean isZipFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.toString().toLowerCase().endsWith(".zip");
    }
}

