/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.pf4j.PluginStatusProvider;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginStatusProvider
implements PluginStatusProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginStatusProvider.class);
    private final Path pluginsRoot;
    private List<String> enabledPlugins;
    private List<String> disabledPlugins;

    public DefaultPluginStatusProvider(Path pluginsRoot) {
        this.pluginsRoot = pluginsRoot;
        try {
            this.enabledPlugins = FileUtils.readLines(pluginsRoot.resolve("enabled.txt"), true);
            log.info("Enabled plugins: {}", (Object)this.enabledPlugins);
            this.disabledPlugins = FileUtils.readLines(pluginsRoot.resolve("disabled.txt"), true);
            log.info("Disabled plugins: {}", (Object)this.disabledPlugins);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enabledPlugins.isEmpty() && !this.enabledPlugins.contains(pluginId);
    }

    @Override
    public boolean disablePlugin(String pluginId) {
        if (this.disabledPlugins.add(pluginId)) {
            try {
                FileUtils.writeLines(this.disabledPlugins, this.pluginsRoot.resolve("disabled.txt").toFile());
            }
            catch (IOException e) {
                log.error("Failed to disable plugin {}", (Object)pluginId, (Object)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean enablePlugin(String pluginId) {
        if (this.disabledPlugins.remove(pluginId)) {
            try {
                FileUtils.writeLines(this.disabledPlugins, this.pluginsRoot.resolve("disabled.txt").toFile());
            }
            catch (IOException e) {
                log.error("Failed to enable plugin {}", (Object)pluginId, (Object)e);
                return false;
            }
        }
        return true;
    }
}

