/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.functors.NOPClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForClosure<T>
implements Closure<T>,
Serializable {
    static final long serialVersionUID = -1190120533393621674L;
    private final int iCount;
    private final Closure<T> iClosure;

    public static <T> Closure<T> getInstance(int count, Closure<T> closure) {
        if (count <= 0 || closure == null) {
            return NOPClosure.INSTANCE;
        }
        if (count == 1) {
            return closure;
        }
        return new ForClosure<T>(count, closure);
    }

    public ForClosure(int count, Closure<T> closure) {
        this.iCount = count;
        this.iClosure = closure;
    }

    @Override
    public void execute(T input) {
        for (int i = 0; i < this.iCount; ++i) {
            this.iClosure.execute(input);
        }
    }

    public Closure<T> getClosure() {
        return this.iClosure;
    }

    public int getCount() {
        return this.iCount;
    }
}

