/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends PreferencePanel {
    private JComboBox languageSelector;
    private SpinnerNumberModel undoSize;
    private SpinnerNumberModel historySize;
    private SpinnerNumberModel updateThreads;
    private JTextField dateFormat;
    private JLabel dateFormatPreview;
    private boolean isDateValid = true;
    private JCheckBox restoreMaps;
    private JCheckBox restordeWH;
    private JCheckBox restordeXY;
    private JCheckBox queryArp;
    private JCheckBox dotDesktopFile;
    private JRadioButton viewNormal;
    private JRadioButton viewMinimized;
    private JRadioButton viewMaximized;

    public GeneralPanel(final Window parent) {
        this.title = Lang.getNoHTML("preferences.general");
        JPanel languageWrapper = new JPanel(new GridLayout(1, 2, 5, 5)){
            {
                super(layout);
                this.setMaximumSize(new Dimension(9999, 25));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.general.language")));
                GeneralPanel.this.languageSelector = new JComboBox<String>(Lang.getLanguages());
                GeneralPanel.this.languageSelector.setSelectedItem(Lang.currentLanguage());
                this.add(GeneralPanel.this.languageSelector);
                this.add(SwingHelper.createAlignedButton(new AbstractAction(Lang.get("action.install"), Icons.get("install")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File f = SwingHelper.openDialog(parent, null);
                        if (f == null) {
                            return;
                        }
                        IO.copy(f, new File("/lang", f.getName()), null);
                        GeneralPanel.this.languageSelector.setModel(new DefaultComboBoxModel<String>(Lang.getLanguages()));
                        GeneralPanel.this.languageSelector.setSelectedItem(Lang.currentLanguage());
                        GeneralPanel.this.languageSelector.showPopup();
                    }
                }));
            }
        };
        JPanel restorePanel = new JPanel(new GridLayout(0, 1, 5, 5));
        restorePanel.setMaximumSize(new Dimension(9999, 60));
        restorePanel.setBorder(new TitledBorder(Lang.getNoHTML("preferences.appearance.window")));
        JPanel viewState = new JPanel(new GridLayout(1, 0, 5, 5));
        this.viewNormal = new JRadioButton(Lang.get("preferences.appearance.viewstate.normal"), Settings.getInt("view.extendedstate", 0) == 0);
        this.viewMaximized = new JRadioButton(Lang.get("preferences.appearance.viewstate.maximized"), Settings.getInt("view.extendedstate", 0) == 6);
        this.viewMinimized = new JRadioButton(Lang.get("preferences.appearance.viewstate.minimized"), Settings.getInt("view.extendedstate", 0) == 1);
        ButtonGroup viewGroup = new ButtonGroup();
        viewGroup.add(this.viewNormal);
        viewState.add(this.viewNormal);
        viewGroup.add(this.viewMaximized);
        viewState.add(this.viewMaximized);
        viewGroup.add(this.viewMinimized);
        viewState.add(this.viewMinimized);
        this.viewNormal.addChangeListener(e -> {
            this.restordeWH.setEnabled(this.viewNormal.isSelected());
            this.restordeXY.setEnabled(this.viewNormal.isSelected());
        });
        this.restordeWH = new JCheckBox(Lang.get("preferences.appearance.remember.wh"), Settings.getBoolean("mapview.remember.wh", true));
        this.restordeWH.setEnabled(this.viewNormal.isSelected());
        this.restordeXY = new JCheckBox(Lang.get("preferences.appearance.remember.xy"), Settings.getBoolean("mapview.remember.xy", true));
        this.restordeXY.setEnabled(this.viewNormal.isSelected());
        restorePanel.add(viewState);
        restorePanel.add(this.restordeWH);
        restorePanel.add(this.restordeXY);
        JPanel miscWrapper = new JPanel(new GridLayout(0, 2, 5, 5));
        miscWrapper.setMaximumSize(new Dimension(9999, 90));
        miscWrapper.add(new JLabel(Lang.get("preferences.general.undosize")));
        this.undoSize = new SpinnerNumberModel(Settings.getInt("commandhistory.size", 20), 5, 100, 1);
        miscWrapper.add(new JSpinner(this.undoSize));
        miscWrapper.add(new JLabel(Lang.get("preferences.general.historysize")));
        this.historySize = new SpinnerNumberModel(Settings.getInt("device.history.maxsize", 20), 5, 100, 1);
        miscWrapper.add(new JSpinner(this.historySize));
        miscWrapper.add(new JLabel(Lang.get("preferences.general.updatethreads")));
        this.updateThreads = new SpinnerNumberModel(Settings.getInt("status.update.threads", 5), 1, 20, 1);
        miscWrapper.add(new JSpinner(this.updateThreads));
        miscWrapper.add(new JLabel(Lang.get("preferences.general.dateformat")));
        this.dateFormat = new JTextField(Settings.get("view.dateformat", "yyyy-MM-dd HH:mm"));
        miscWrapper.add(this.dateFormat);
        miscWrapper.add(new JLabel(""));
        this.dateFormatPreview = new JLabel("");
        miscWrapper.add(this.dateFormatPreview);
        this.dateFormat.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                try {
                    GeneralPanel.this.dateFormatPreview.setText(new SimpleDateFormat(GeneralPanel.this.dateFormat.getText()).format(new Date()));
                    GeneralPanel.this.isDateValid = true;
                }
                catch (Exception e) {
                    Logger.debug("Invalid date format", e);
                    GeneralPanel.this.dateFormatPreview.setText("---");
                    GeneralPanel.this.isDateValid = false;
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JPanel cbWrapper = new JPanel(new GridLayout(0, 1, 5, 5));
        cbWrapper.setMaximumSize(new Dimension(9999, 90));
        this.restoreMaps = new JCheckBox(Lang.get("maps.restore"), Settings.getBoolean("maps.restore", false));
        cbWrapper.add(this.restoreMaps);
        this.queryArp = new JCheckBox(Lang.get("preferences.general.arp"), Settings.getBoolean("arp.query", true));
        cbWrapper.add(this.queryArp);
        if (IO.isLinux) {
            this.dotDesktopFile = new JCheckBox(Lang.get("preferences.general.dotdesktopfile"), Settings.getBoolean("recent.desktop.file", true));
            cbWrapper.add(this.dotDesktopFile);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(languageWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(restorePanel);
        this.add(Box.createVerticalStrut(5));
        this.add(miscWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(cbWrapper);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public String getParentTitle() {
        return this.parentTitle == null ? "" : this.parentTitle;
    }

    @Override
    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public void save() {
        Settings.put("lang", this.languageSelector.getSelectedItem().toString());
        Settings.put("view.extendedstate", this.viewMaximized.isSelected() ? 6 : (this.viewMinimized.isSelected() ? 1 : 0));
        Settings.put("mapview.remember.wh", this.restordeWH.isSelected());
        Settings.put("mapview.remember.xy", this.restordeXY.isSelected());
        Settings.put("status.update.threads", this.updateThreads.getNumber().intValue());
        if (this.isDateValid) {
            Settings.put("view.dateformat", this.dateFormat.getText());
        }
        Settings.put("commandhistory.size", this.undoSize.getNumber().intValue());
        Settings.put("device.history.maxsize", this.historySize.getNumber().intValue());
        Settings.put("maps.restore", this.restoreMaps.isSelected());
        Settings.put("arp.query", this.queryArp.isSelected());
        if (IO.isLinux) {
            Settings.put("recent.desktop.file", this.dotDesktopFile.isSelected());
        }
    }
}

