/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.jung.EdgeTransformers;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import ch.rakudave.jnetmap.view.preferences.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AppearancePanel
extends PreferencePanel {
    private Window owner;
    private Preferences prefs;
    private JComboBox lafSelector;
    private JComboBox iconSelector;
    private JComboBox deviceSelector;
    private JComboBox fontNameSelector;
    private JComboBox shapeSelector;
    private JPanel bgButton;
    private JPanel selectedButton;
    private JPanel upButton;
    private JPanel downButton;
    private JPanel unknownButton;
    private JPanel notFoundButton;
    private JCheckBox deviceLabelName;
    private JCheckBox deviceLabelDescription;
    private JCheckBox deviceLabelLocation;
    private JCheckBox deviceLabelVendor;
    private JCheckBox deviceLabelModel;
    private JCheckBox deviceLabelIP;
    private JCheckBox deviceLabelMAC;
    private JCheckBox connectionLabelName;
    private JCheckBox connectionLabelLatency;
    private JCheckBox connectionLabelStatus;
    private SpinnerModel fontSizeSpinner;
    private HashMap<Object, LookAndFeel> lafLookup = new HashMap();

    public AppearancePanel(Window parent, Preferences preferences) {
        this.owner = parent;
        this.prefs = preferences;
        this.title = Lang.getNoHTML("preferences.appearance");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel lafWrapper = new JPanel(new GridLayout(1, 2, 5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 25));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.general.laf") + " " + Lang.getNoHTML("message.restart")));
                UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
                String[] lafClassNames = new String[lafInfos.length];
                for (int i = 0; i < lafInfos.length; ++i) {
                    lafClassNames[i] = lafInfos[i].getClassName();
                }
                AppearancePanel.this.lafSelector = new JComboBox<String>(lafClassNames);
                AppearancePanel.this.lafSelector.setRenderer(new LafListRenderer());
                AppearancePanel.this.lafSelector.setSelectedItem(Settings.get("laf.theme", UIManager.getSystemLookAndFeelClassName()));
                this.add(AppearancePanel.this.lafSelector);
                this.add(SwingHelper.createAlignedButton(new AbstractAction(Lang.get("action.reset"), Icons.get("undo")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AppearancePanel.this.lafSelector.setSelectedItem(UIManager.getSystemLookAndFeelClassName());
                    }
                }));
            }
        };
        JPanel iconWrapper = new JPanel(new GridLayout(1, 2, 5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 25));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.general.iconstyle") + " " + Lang.getNoHTML("message.restart")));
                AppearancePanel.this.iconSelector = new JComboBox<String>(Icons.getThemes());
                AppearancePanel.this.iconSelector.setRenderer(new IconListRenderer());
                AppearancePanel.this.iconSelector.setSelectedItem(Icons.currentTheme());
                this.add(AppearancePanel.this.iconSelector);
                this.add(SwingHelper.createAlignedButton(new AbstractAction(Lang.get("action.install"), Icons.get("install")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File zip = SwingHelper.openDialog(AppearancePanel.this.owner, new FileNameExtensionFilter("ZIP-file", "zip"));
                        if (zip != null) {
                            if (Icons.importTheme(zip)) {
                                AppearancePanel.this.iconSelector.addItem(zip.getName().replace(".zip", ""));
                                Logger.info("Successfully imported icon-theme " + AppearancePanel.this.iconSelector.getSelectedItem());
                            } else {
                                Logger.error("Failed to import icon-theme " + zip.getName());
                                JOptionPane.showMessageDialog(AppearancePanel.this.owner, Lang.get("message.import.error"), zip.getName(), 0);
                            }
                        }
                    }
                }));
            }
        };
        JPanel deviceIconWrapper = new JPanel(new GridLayout(1, 2, 5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 25));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.general.devicestyle")));
                AppearancePanel.this.deviceSelector = new JComboBox<String>(Icons.getDeviceThemes());
                AppearancePanel.this.deviceSelector.setRenderer(new DeviceIconListRenderer());
                AppearancePanel.this.deviceSelector.setSelectedItem(Icons.currentDeviceTheme());
                this.add(AppearancePanel.this.deviceSelector);
                this.add(SwingHelper.createAlignedButton(new AbstractAction(Lang.get("action.install"), Icons.get("install")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File zip = SwingHelper.openDialog(AppearancePanel.this.owner, new FileNameExtensionFilter("ZIP-file", "zip"));
                        if (zip != null) {
                            if (Icons.importDeviceTheme(zip)) {
                                AppearancePanel.this.deviceSelector.addItem(zip.getName().replace(".zip", ""));
                                Logger.info("Successfully imported icon-theme " + AppearancePanel.this.deviceSelector.getSelectedItem());
                            } else {
                                Logger.error("Failed to import device-theme " + zip.getName());
                                JOptionPane.showMessageDialog(AppearancePanel.this.owner, Lang.get("message.import.error"), zip.getName(), 0);
                            }
                        }
                    }
                }));
            }
        };
        JPanel fontWrapper = new JPanel(new BorderLayout(5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 25));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.appearance.font")));
                String[] fonts = (String[])Stream.concat(Stream.of(""), Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())).sorted(String::compareTo).toArray(String[]::new);
                AppearancePanel.this.fontNameSelector = new JComboBox<String>(fonts);
                AppearancePanel.this.fontNameSelector.setSelectedItem(Settings.get("view.font.name", ""));
                this.add((Component)AppearancePanel.this.fontNameSelector, "Center");
                AppearancePanel.this.fontSizeSpinner = new SpinnerNumberModel(Settings.getInt("view.font.size", 14), 5, 50, 1);
                this.add((Component)new JSpinner(AppearancePanel.this.fontSizeSpinner), "East");
            }
        };
        JPanel colors = new JPanel(new GridLayout(3, 2, 5, 5));
        colors.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.appearance.color")));
        colors.setMaximumSize(new Dimension(9999, 120));
        this.bgButton = this.createColorPanel(null, new Color(Settings.getInt("background.color", Color.white.getRGB())), Lang.get("preferences.appearance.background"));
        this.selectedButton = this.createColorPanel(null, new Color(Settings.getInt("edge.selected.color", Color.black.getRGB())), Lang.get("preferences.appearance.edge.selected"));
        this.upButton = this.createColorPanel(Status.UP, null, null);
        this.downButton = this.createColorPanel(Status.DOWN, null, null);
        this.unknownButton = this.createColorPanel(Status.UNKNOWN, null, null);
        this.notFoundButton = this.createColorPanel(Status.NOT_FOUND, null, null);
        colors.add(this.bgButton);
        colors.add(this.createResetButton(this.bgButton, Color.white));
        colors.add(this.selectedButton);
        colors.add(this.createResetButton(this.selectedButton, Color.black));
        colors.add(this.upButton);
        colors.add(this.createResetButton(this.upButton, Color.green));
        colors.add(this.notFoundButton);
        colors.add(this.createResetButton(this.notFoundButton, Color.orange));
        colors.add(this.downButton);
        colors.add(this.createResetButton(this.downButton, Color.red));
        colors.add(this.unknownButton);
        colors.add(this.createResetButton(this.unknownButton, Color.gray));
        JPanel deviceWrapper = new JPanel(new GridLayout(3, 3, 5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 120));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.appearance.device.label")));
                AppearancePanel.this.deviceLabelName = new JCheckBox(Lang.get("device.name"), Settings.getBoolean("device.label.name", true));
                AppearancePanel.this.deviceLabelDescription = new JCheckBox(Lang.get("device.description"), Settings.getBoolean("device.label.description", false));
                AppearancePanel.this.deviceLabelLocation = new JCheckBox(Lang.get("device.location"), Settings.getBoolean("device.label.location", false));
                AppearancePanel.this.deviceLabelVendor = new JCheckBox(Lang.get("device.vendor"), Settings.getBoolean("device.label.vendor", false));
                AppearancePanel.this.deviceLabelModel = new JCheckBox(Lang.get("device.model"), Settings.getBoolean("device.label.model", false));
                AppearancePanel.this.deviceLabelIP = new JCheckBox(Lang.get("interface.address"), Settings.getBoolean("device.label.ip", false));
                AppearancePanel.this.deviceLabelMAC = new JCheckBox(Lang.get("interface.mac"), Settings.getBoolean("device.label.mac", false));
                this.add(AppearancePanel.this.deviceLabelName);
                this.add(AppearancePanel.this.deviceLabelDescription);
                this.add(AppearancePanel.this.deviceLabelLocation);
                this.add(AppearancePanel.this.deviceLabelVendor);
                this.add(AppearancePanel.this.deviceLabelModel);
                this.add(AppearancePanel.this.deviceLabelIP);
                this.add(AppearancePanel.this.deviceLabelMAC);
            }
        };
        JPanel shapeWrapper = new JPanel(new GridLayout(2, 2, 5, 5)){
            {
                this.setMaximumSize(new Dimension(9999, 80));
                this.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("connection")));
                AppearancePanel.this.shapeSelector = new JComboBox<EdgeTransformers.Shape>(EdgeTransformers.Shape.values());
                AppearancePanel.this.shapeSelector.setSelectedItem((Object)EdgeTransformers.Shape.valueOf(Settings.get("edge.shape", "Quad")));
                AppearancePanel.this.connectionLabelName = new JCheckBox(Lang.get("connection.name"), Settings.getBoolean("connection.label.name", false));
                AppearancePanel.this.connectionLabelStatus = new JCheckBox(Lang.get("message.status"), Settings.getBoolean("connection.label.status", false));
                AppearancePanel.this.connectionLabelLatency = new JCheckBox(Lang.get("connection.latency"), Settings.getBoolean("connection.label.latency", false));
                this.add(AppearancePanel.this.shapeSelector);
                this.add(AppearancePanel.this.connectionLabelStatus);
                this.add(AppearancePanel.this.connectionLabelName);
                this.add(AppearancePanel.this.connectionLabelLatency);
            }
        };
        this.setLayout(new BoxLayout(this, 1));
        this.add(lafWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(iconWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(deviceIconWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(fontWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(colors);
        this.add(Box.createVerticalStrut(5));
        this.add(deviceWrapper);
        this.add(Box.createVerticalStrut(5));
        this.add(shapeWrapper);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createColorPanel(Status status, Color overrideColor, String overrideName) {
        final JPanel panel = new JPanel();
        panel.setBackground(overrideColor != null ? overrideColor : status.getColor());
        panel.add(new JLabel(overrideName != null ? overrideName : status.getMessage()));
        panel.setCursor(Cursor.getPredefinedCursor(12));
        panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Color initialBackground = panel.getBackground();
                Color background = JColorChooser.showDialog(AppearancePanel.this.owner, Lang.getNoHTML("preferences.appearance.color"), initialBackground);
                if (background != null) {
                    panel.setBackground(background);
                }
            }
        });
        return panel;
    }

    private JButton createResetButton(final JComponent display, final Color color) {
        return new JButton(new AbstractAction(Lang.get("action.reset"), Icons.get("undo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                display.setBackground(color);
            }
        });
    }

    @Override
    public void save() {
        Settings.put("icon.theme", this.iconSelector.getSelectedItem().toString());
        Settings.put("device.theme", this.deviceSelector.getSelectedItem().toString());
        Icons.loadDevices(this.deviceSelector.getSelectedItem().toString());
        String fontName = this.fontNameSelector.getSelectedItem().toString();
        Settings.put("view.font.name", fontName);
        Settings.put("view.font.size", this.fontSizeSpinner.getValue().toString());
        Settings.put("background.color", this.bgButton.getBackground().getRGB());
        Settings.put("edge.selected.color", this.selectedButton.getBackground().getRGB());
        Status.UP.setColor(this.upButton.getBackground());
        Status.DOWN.setColor(this.downButton.getBackground());
        Status.UNKNOWN.setColor(this.unknownButton.getBackground());
        Status.NOT_FOUND.setColor(this.notFoundButton.getBackground());
        Settings.put("device.label.name", this.deviceLabelName.isSelected());
        Settings.put("device.label.description", this.deviceLabelDescription.isSelected());
        Settings.put("device.label.location", this.deviceLabelLocation.isSelected());
        Settings.put("device.label.vendor", this.deviceLabelVendor.isSelected());
        Settings.put("device.label.model", this.deviceLabelModel.isSelected());
        Settings.put("device.label.ip", this.deviceLabelIP.isSelected());
        Settings.put("device.label.mac", this.deviceLabelMAC.isSelected());
        Settings.put("connection.label.name", this.connectionLabelName.isSelected());
        Settings.put("connection.label.status", this.connectionLabelStatus.isSelected());
        Settings.put("connection.label.latency", this.connectionLabelLatency.isSelected());
        Settings.put("edge.shape", this.shapeSelector.getSelectedItem().toString());
        try {
            UIManager.setLookAndFeel(this.lafSelector.getSelectedItem().toString());
            Settings.put("laf.theme", this.lafSelector.getSelectedItem().toString());
            SwingHelper.setUIFont(fontName, Settings.getInt("view.font.size", 14));
            SwingUtilities.updateComponentTreeUI(this.prefs);
            SwingUtilities.updateComponentTreeUI(this.owner);
        }
        catch (Exception e) {
            Logger.debug("Failed to set L&F", e);
        }
        Controller.refreshAll();
    }

    private class LafListRenderer
    extends DefaultListCellRenderer {
        private LafListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            try {
                LookAndFeel lnf = (LookAndFeel)AppearancePanel.this.lafLookup.get(value);
                if (lnf == null) {
                    Class<?> lnfClass = Class.forName((String)value, true, Thread.currentThread().getContextClassLoader());
                    lnf = (LookAndFeel)lnfClass.newInstance();
                    AppearancePanel.this.lafLookup.put(value, lnf);
                }
                label.setText(" " + lnf.getName());
                label.setToolTipText(lnf.getDescription());
            }
            catch (Throwable e) {
                Logger.warn("Unable to load L&F", e);
            }
            return label;
        }
    }

    private class DeviceIconListRenderer
    extends DefaultListCellRenderer {
        private DeviceIconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            try {
                String theme = (String)value;
                label.setIcon(Icons.loadImageIcon("/devices/" + theme, "workstation_small.png"));
            }
            catch (Exception e) {
                Logger.trace("Unable to get icon", e);
            }
            return label;
        }
    }

    private class IconListRenderer
    extends DefaultListCellRenderer {
        private IconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            try {
                String theme = (String)value;
                label.setIcon(Icons.loadImageIcon("/icons/" + theme, "jnetmap_small.png"));
            }
            catch (Exception e) {
                Logger.trace("Unable to get icon", e);
            }
            return label;
        }
    }
}

