/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.model.CurrentMapListener;
import ch.rakudave.jnetmap.model.Layer;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class LayerPanel
extends JPanel
implements CurrentMapListener {
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private JButton add;
    private JButton remove;
    private DefaultTreeModel treeModel;

    public LayerPanel(Frame owner) {
        Controller.addCurrentMapListener(this);
        this.setLayout(new BorderLayout());
        JTree tree = new JTree(this.rootNode);
        this.treeModel = (DefaultTreeModel)tree.getModel();
        tree.setRootVisible(false);
        tree.setAutoscrolls(true);
        tree.setDragEnabled(true);
        tree.setTransferHandler(new LayerTransferHandler());
        tree.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        tree.getSelectionModel().setSelectionMode(4);
        tree.setCellRenderer(new LayerRenderer());
        JPanel bottom = new JPanel(new GridLayout(1, 2));
        this.putAddButton(bottom);
        this.putRemoveButton(bottom);
        this.add((Component)new JScrollPane(tree, 20, 31), "Center");
        this.add((Component)bottom, "South");
    }

    private void putAddButton(JPanel panel) {
        this.add = new JButton(new AbstractAction(Lang.get("action.add"), Icons.get("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerPanel.this.rootNode.add(new DefaultMutableTreeNode(new Layer("new"), true));
                LayerPanel.this.treeModel.reload();
            }
        });
        panel.add(this.add);
    }

    private void putRemoveButton(JPanel panel) {
        this.remove = new JButton(new AbstractAction(Lang.get("action.delete"), Icons.get("remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        panel.add(this.remove);
    }

    @Override
    public void mapChanged(Map map) {
        this.rootNode.removeAllChildren();
        DefaultMutableTreeNode def = new DefaultMutableTreeNode(new Layer("new"), true);
        this.rootNode.add(def);
        for (Device device : map.getVertices()) {
            def.add(new DefaultMutableTreeNode(device, false));
        }
        this.treeModel.reload();
    }

    private class LayerTransferHandler
    extends TransferHandler {
        private LayerTransferHandler() {
        }
    }

    private class LayerRenderer
    extends JLabel
    implements TreeCellRenderer {
        private LayerRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof Device) {
                Device device = (Device)userObject;
                this.setText(device.getName());
                this.setIcon(Icons.get("new"));
            } else if (userObject instanceof Layer) {
                Layer layer = (Layer)userObject;
                return layer.getComponent();
            }
            this.setPreferredSize(new Dimension(999, 24));
            return this;
        }
    }
}

