/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util;

import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;

public class SkippingCollectionConverter
extends AbstractCollectionConverter {
    public SkippingCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(ArrayList.class) || type.equals(HashSet.class) || type.equals(LinkedList.class) || type.equals(Vector.class) || type.getName().equals("java.util.LinkedHashSet");
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Collection collection = (Collection)source;
        for (Object item : collection) {
            this.writeItem(item, context, writer);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Collection collection = (Collection)this.createCollection(context.getRequiredType());
        this.populateCollection(reader, context, collection);
        return collection;
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                Object item = this.readItem(reader, context, collection);
                collection.add(item);
            }
            catch (Exception e) {
                Logger.debug("Class not found, item will be ignored", e);
            }
            reader.moveUp();
        }
    }
}

