/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util;

import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.DeviceEvent;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Lang;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class DeviceEventFilter {
    private boolean onDeviceChange = true;
    private boolean onIFChange;
    private boolean[] status = new boolean[]{true, true, true, true};
    private String deviceNameMatcher = "";
    private String statusMatcher = "";
    private String ipMatcher = "";
    private String subnetMatcher = "";
    private int quietFrom;
    private int quietTo;

    public DeviceEventFilter() {
    }

    public DeviceEventFilter(boolean onDeviceChange, boolean onIFChange) {
        this.onDeviceChange = onDeviceChange;
        this.onIFChange = onIFChange;
    }

    public boolean matches(DeviceEvent e) {
        this.legacyFilterRestoration();
        if (!this.onDeviceChange && !this.onIFChange) {
            return false;
        }
        Device d = (Device)e.getSource();
        if (!this.deviceNameMatcher.isEmpty() && !d.getName().matches(this.deviceNameMatcher)) {
            return false;
        }
        if (this.onDeviceChange && DeviceEvent.Type.STATUS_CHANGED.equals((Object)e.getType())) {
            if (Status.UP.equals((Object)d.getStatus()) && !this.status[0] || Status.DOWN.equals((Object)d.getStatus()) && !this.status[1] || Status.NOT_FOUND.equals((Object)d.getStatus()) && !this.status[2] || Status.UNKNOWN.equals((Object)d.getStatus()) && !this.status[3]) {
                return false;
            }
            for (NetworkIF nif : d.getInterfaces()) {
                if (!this.ipMatcher.isEmpty() && nif.getAddress() != null && !nif.getAddress().getHostAddress().matches(this.ipMatcher)) {
                    return false;
                }
                if (this.subnetMatcher.isEmpty() || nif.getSubnet() == null || nif.getSubnet().getInfo().getBroadcastAddress().matches(this.ipMatcher)) continue;
                return false;
            }
            return this.isWithinTimeLimit(e);
        }
        if (this.onIFChange && DeviceEvent.Type.INTERFACE_STATUS_CHANGED.equals((Object)e.getType())) {
            NetworkIF nif = (NetworkIF)e.getSubject();
            if (Status.UP.equals((Object)d.getStatus()) && !this.status[0] || Status.DOWN.equals((Object)d.getStatus()) && !this.status[1] || Status.NOT_FOUND.equals((Object)d.getStatus()) && !this.status[2] || Status.UNKNOWN.equals((Object)d.getStatus()) && !this.status[3]) {
                return false;
            }
            if (!this.ipMatcher.isEmpty() && nif.getAddress() != null && !nif.getAddress().getHostAddress().matches(this.ipMatcher)) {
                return false;
            }
            return (this.subnetMatcher.isEmpty() || nif.getSubnet() == null || nif.getSubnet().getInfo().getBroadcastAddress().matches(this.ipMatcher)) && this.statusMatcher.isEmpty() && this.ipMatcher.isEmpty() && this.subnetMatcher.isEmpty() && this.isWithinTimeLimit(e);
        }
        return false;
    }

    private boolean isWithinTimeLimit(DeviceEvent e) {
        if (this.quietFrom == this.quietTo) {
            return true;
        }
        int now = e.getTime().getHours() * 60 + e.getTime().getMinutes();
        if (this.quietFrom < this.quietTo) {
            return now < this.quietFrom || now > this.quietTo;
        }
        return now < this.quietFrom && now > this.quietTo;
    }

    public JPanel settingsPanel() {
        this.legacyFilterRestoration();
        JPanel p = new JPanel(new GridLayout(0, 2, 5, 5));
        p.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("filter")));
        final JCheckBox deviceChange = new JCheckBox(Lang.get("device"), this.onDeviceChange);
        final JCheckBox ifChange = new JCheckBox(Lang.get("interface"), this.onIFChange);
        JPanel statusFilter1 = new JPanel(new GridLayout(1, 2));
        JCheckBox up = new JCheckBox(Status.UP.getMessage(), this.status[0]);
        JCheckBox down = new JCheckBox(Status.DOWN.getMessage(), this.status[1]);
        statusFilter1.add(up);
        statusFilter1.add(down);
        JPanel statusFilter2 = new JPanel(new GridLayout(1, 2));
        JCheckBox not_found = new JCheckBox(Status.NOT_FOUND.getMessage(), this.status[2]);
        JCheckBox unknown = new JCheckBox(Status.UNKNOWN.getMessage(), this.status[3]);
        statusFilter2.add(not_found);
        statusFilter2.add(unknown);
        final JTextField deviceFilter = new JTextField(this.deviceNameMatcher);
        deviceFilter.setToolTipText("Regular Expression");
        final JTextField ipFilter = new JTextField(this.ipMatcher);
        ipFilter.setToolTipText("Regular Expression");
        final JTextField subFilter = new JTextField(this.subnetMatcher);
        subFilter.setToolTipText("Regular Expression");
        FocusListener f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DeviceEventFilter.this.onDeviceChange = deviceChange.isSelected();
                DeviceEventFilter.this.onIFChange = ifChange.isSelected();
                DeviceEventFilter.this.deviceNameMatcher = deviceFilter.getText();
                DeviceEventFilter.this.ipMatcher = ipFilter.getText();
                DeviceEventFilter.this.subnetMatcher = subFilter.getText();
            }
        };
        deviceChange.addFocusListener(f);
        ifChange.addFocusListener(f);
        deviceFilter.addFocusListener(f);
        ipFilter.addFocusListener(f);
        subFilter.addFocusListener(f);
        ActionListener al = arg0 -> {
            this.status[0] = up.isSelected();
            this.status[1] = down.isSelected();
            this.status[2] = not_found.isSelected();
            this.status[3] = unknown.isSelected();
        };
        up.addActionListener(al);
        down.addActionListener(al);
        not_found.addActionListener(al);
        unknown.addActionListener(al);
        JPanel quietTime = new JPanel(new GridLayout(1, 5, 5, 5));
        SpinnerNumberModel quietFromHour = new SpinnerNumberModel(this.quietFrom / 60, 0, 23, 1);
        SpinnerNumberModel quietFromMin = new SpinnerNumberModel(this.quietFrom % 60, 0, 59, 1);
        ChangeListener cl = e -> {
            this.quietFrom = quietFromHour.getNumber().intValue() * 60 + quietFromMin.getNumber().intValue();
        };
        quietFromHour.addChangeListener(cl);
        quietFromMin.addChangeListener(cl);
        SpinnerNumberModel quietToHour = new SpinnerNumberModel(this.quietTo / 60, 0, 23, 1);
        SpinnerNumberModel quietToMin = new SpinnerNumberModel(this.quietTo % 60, 0, 59, 1);
        cl = e -> {
            this.quietTo = quietToHour.getNumber().intValue() * 60 + quietToMin.getNumber().intValue();
        };
        quietToHour.addChangeListener(cl);
        quietToMin.addChangeListener(cl);
        quietTime.add(new JSpinner(quietFromHour));
        quietTime.add(new JSpinner(quietFromMin));
        quietTime.add(new JLabel("-", 0));
        quietTime.add(new JSpinner(quietToHour));
        quietTime.add(new JSpinner(quietToMin));
        p.add(new JLabel(Lang.get("event.from")));
        p.add(deviceChange);
        p.add(new JLabel(Lang.get("event.from")));
        p.add(ifChange);
        p.add(new JLabel(Lang.get("filter.status")));
        p.add(statusFilter1);
        p.add(new JLabel());
        p.add(statusFilter2);
        p.add(new JLabel(Lang.get("filter.name")));
        p.add(deviceFilter);
        p.add(new JLabel(Lang.get("filter.ip")));
        p.add(ipFilter);
        p.add(new JLabel(Lang.get("filter.subnet")));
        p.add(subFilter);
        p.add(new JLabel(Lang.get("event.quiet")));
        p.add(quietTime);
        return p;
    }

    private void legacyFilterRestoration() {
        if (this.status == null) {
            this.status = new boolean[]{true, true, true, true};
        }
        if (this.statusMatcher == null) {
            this.statusMatcher = "";
        }
        if (!this.statusMatcher.isEmpty()) {
            this.status[0] = Status.UP.getMessage().matches(this.statusMatcher);
            this.status[1] = Status.DOWN.getMessage().matches(this.statusMatcher);
            this.status[2] = Status.NOT_FOUND.getMessage().matches(this.statusMatcher);
            this.status[3] = Status.UNKNOWN.getMessage().matches(this.statusMatcher);
            this.statusMatcher = "";
        }
    }
}

