/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.plugins;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.plugins.extensions.RightClickAction;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.util.Arrays;
import javax.swing.Icon;

public class RightClickExec
implements RightClickAction {
    private String name;
    private String command;
    private String args;

    private RightClickExec() {
    }

    public RightClickExec(String name, String command, String args) {
        this();
        this.name = name;
        this.command = command;
        this.args = args;
    }

    @Override
    public void execute(Device d) {
        Scheduler.execute(() -> {
            Process process = null;
            try {
                Object[] commandAndArgs = IO.splitCommandArgs(this.command, this.fillArgs(this.args, d));
                Logger.debug("Executing script: " + Arrays.toString(commandAndArgs));
                process = Runtime.getRuntime().exec((String[])commandAndArgs);
                process.waitFor();
            }
            catch (Exception ex) {
                Logger.warn("Unable to execute script", ex);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        });
    }

    private String fillArgs(String args, Device d) {
        if (args == null || "".equals(args)) {
            return "";
        }
        String result = args.replaceAll("%s", d.getStatus().toString()).replaceAll("%n", d.getName()).replaceAll("%t", d.getType().toString()).replaceAll("%d", d.getDesctription()).replaceAll("%l", d.getLocation()).replaceAll("%m", d.getModel()).replaceAll("%v", d.getVendor());
        if (args.contains("%a")) {
            result = result.replaceAll("%a", SwingHelper.interfaceSelector(d, false) + "");
        }
        if (args.contains("%h")) {
            result = result.replaceAll("%h", SwingHelper.interfaceSelector(d, true) + "");
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return Icons.get("script");
    }
}

