/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net.status;

import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.InetAddress;
import java.util.Scanner;

@XStreamAlias(value="NmapPing")
public class NmapPing
implements PingMethod {
    private static NmapPing instance;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NmapPing getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new NmapPing();
                }
            }
        }
        return instance;
    }

    private NmapPing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getStatus(InetAddress address) {
        Status status;
        Process process = null;
        try {
            String command = Settings.get("ping.nmap.syntax", "nmap -sP");
            Logger.debug(command + " " + address.getHostAddress());
            process = Runtime.getRuntime().exec(command + " " + address.getHostAddress());
            try (Scanner s = new Scanner(process.getInputStream());){
                if (s.useDelimiter("\\A").hasNext() && s.next().contains(Settings.get("ping.nmap.contains", "Host is up"))) {
                    Status status2 = Status.UP;
                    return status2;
                }
            }
            process.waitFor();
            status = Status.DOWN;
            return status;
        }
        catch (Exception e) {
            Logger.trace("Failed to get nmap ping status " + address, e);
            status = Status.UNKNOWN;
            return status;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public String toString() {
        return "Nmap Ping";
    }

    static {
        lock = new Object();
    }
}

