/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.controller.command.CommandHistory;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.LogicalIF;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.IF.TransparentIF;
import ch.rakudave.jnetmap.model.Layer;
import ch.rakudave.jnetmap.model.MapEvent;
import ch.rakudave.jnetmap.model.MapListener;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.DeviceEvent;
import ch.rakudave.jnetmap.model.device.DeviceListener;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.plugins.extensions.Notifier;
import ch.rakudave.jnetmap.util.Crypto;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SkippingCollectionConverter;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.XStreamHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.apache.commons.collections15.Predicate;

@XStreamAlias(value="Map")
public class Map
implements MultiGraph<Device, Connection>,
Graph<Device, Connection>,
DirectedGraph<Device, Connection>,
DeviceListener {
    private Map _this = this;
    @XStreamOmitField
    private File mapFile;
    @XStreamOmitField
    private String password = "";
    @XStreamOmitField
    private CommandHistory history = new CommandHistory();
    private double updateInterval = 5.0;
    private Graph<Device, Connection> graph = new SparseMultigraph<Device, Connection>();
    private Layout<Device, Connection> layout = new StaticLayout<Device, Connection>(this);
    @XStreamOmitField
    private List<MapListener> mapListeners;
    @XStreamConverter(value=SkippingCollectionConverter.class)
    private List<Notifier> statusListeners;
    private File background;
    @XStreamOmitField
    private Image backgroundImage;
    private Set<Layer> layers;
    @XStreamOmitField
    private boolean saved = true;

    public Map() {
        this.layout.setSize(new Dimension(1000, 1000));
        this.mapListeners = new ArrayList<MapListener>();
        this.statusListeners = new ArrayList<Notifier>();
        this.layers = new LinkedHashSet<Layer>();
    }

    public boolean addMapListener(MapListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.mapListeners == null) {
            this.mapListeners = new ArrayList<MapListener>();
        }
        return this.mapListeners.add(listener);
    }

    public boolean removeMapListener(MapListener listener) {
        return listener != null && this.mapListeners != null && this.mapListeners.remove(listener);
    }

    public boolean addStatusListener(Notifier listener) {
        if (listener == null) {
            return false;
        }
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList<Notifier>();
        }
        return this.statusListeners.add(listener);
    }

    public boolean removeStatusListener(Notifier listener) {
        return listener != null && this.statusListeners != null && this.statusListeners.remove(listener);
    }

    public List<Notifier> getStatusListeners() {
        return this.statusListeners;
    }

    private void notifyListeners(MapEvent e) {
        Logger.trace("Received MapEvent " + e);
        if (this.mapListeners == null) {
            this.mapListeners = new ArrayList<MapListener>();
        }
        for (MapListener l : this.mapListeners) {
            try {
                l.mapChanged(e);
            }
            catch (Exception ex) {
                Logger.error("Unable to notify MapListener " + l, ex);
            }
        }
        if (e.getType() == MapEvent.Type.DEVICE_EVENT) {
            Logger.trace("Received DeviceEvent " + e);
            Scheduler.execute(() -> {
                DeviceEvent ev = (DeviceEvent)e.getSubject();
                if (ev.getType() == DeviceEvent.Type.STATUS_CHANGED || ev.getType() == DeviceEvent.Type.INTERFACE_STATUS_CHANGED) {
                    for (Notifier l : this.statusListeners) {
                        try {
                            l.statusChanged(ev, this._this);
                        }
                        catch (Exception e2) {
                            Logger.error("Unable to notify StatusListener " + l, e2);
                        }
                    }
                }
            });
        }
        if (e.getType() != MapEvent.Type.REFRESH) {
            this.refreshView(null);
            if (e.getType() != MapEvent.Type.SAVED && e.getType() != MapEvent.Type.SETTINGS_CHANGED) {
                this.setSaved(false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Map other = (Map)obj;
        return this.mapFile != null && other.mapFile != null && this.mapFile.equals(other.mapFile);
    }

    public String getFileName() {
        return this.mapFile != null ? this.mapFile.getName().replace(".jnm", "") : Lang.getNoHTML("map.newmap");
    }

    public String getFilePath() {
        return this.mapFile != null ? this.mapFile.getAbsolutePath() : Lang.getNoHTML("map.unsaved");
    }

    public Layout<Device, Connection> getGraphLayout() {
        return this.layout;
    }

    public CommandHistory getHistory() {
        if (this.history == null) {
            this.history = new CommandHistory();
        }
        return this.history;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.mapFile == null ? 0 : this.mapFile.hashCode());
        return result;
    }

    public boolean save() {
        XStream xs = XStreamHelper.getXStream();
        try {
            this.cleanupDevicesHistory(this.getVertices());
            this.cleanupDevicesHistory(this.layout.getGraph().getVertices());
            if (!(this.layout instanceof StaticLayout) && Settings.getBoolean("save.statify.layout", true)) {
                StaticLayout<Device, Connection> statify = new StaticLayout<Device, Connection>(this);
                statify.setInitializer(this.layout);
                statify.setSize(this.layout.getSize());
                this.setLayout(statify);
            }
            String xml = xs.toXML(this);
            if (this.password != null && !this.password.isEmpty()) {
                xml = Crypto.encrypt(xml, this.password);
            }
            if (IO.copy((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), new FileOutputStream(this.mapFile))) {
                this.setSaved(true);
                this.notifyListeners(new MapEvent(this, MapEvent.Type.SAVED, null));
                Logger.info("Saved " + this.mapFile.getAbsolutePath());
                return true;
            }
        }
        catch (Exception e) {
            Logger.error("Unable to save map to " + this.mapFile, e);
        }
        return false;
    }

    private void cleanupDevicesHistory(Collection<Device> devices) {
        for (Device d : devices) {
            this.cleanupHistory(d.getStatusHistory());
            for (NetworkIF nif : d.getInterfaces()) {
                if (!(nif instanceof PhysicalIF)) continue;
                this.cleanupHistory(nif.getStatusHistory());
            }
        }
    }

    private void cleanupHistory(LinkedList<Tuple<Date, Status>> cleanup) {
        cleanup.removeIf(tuple -> Status.UNKNOWN.equals(tuple.getSecond()));
        int maxSize = Settings.getInt("device.history.maxsize", 20);
        while (cleanup.size() > maxSize) {
            cleanup.removeFirst();
        }
    }

    public boolean setFile(File f) {
        if (f != null && f.exists() && f.canWrite()) {
            this.mapFile = f.getAbsoluteFile();
            return true;
        }
        return false;
    }

    public void setLayout(Layout<Device, Connection> layout) {
        if (layout != null) {
            this.layout = layout;
        }
    }

    @Override
    public boolean addEdge(Connection connection, Collection<? extends Device> devices, EdgeType edgeType) {
        return this.addEdge(connection, devices);
    }

    @Override
    public boolean addEdge(final Connection connection, final Collection<? extends Device> devices) {
        return (Boolean)this.getHistory().execute(new Command(){

            @Override
            public Object undo() {
                boolean b = Map.this.graph.removeEdge(connection);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_REMOVED, connection));
                return b;
            }

            @Override
            public Object redo() {
                boolean b = Map.this.graph.addEdge(connection, devices);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_ADDED, connection));
                return b;
            }

            @Override
            public String toString() {
                return Lang.getNoHTML("command.add.connection") + ": " + String.join((CharSequence)" \u2194 ", devices.stream().map(o -> o.getName()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public boolean addEdge(Connection connection, Device device1, Device device2, EdgeType edgeType) {
        return this.addEdge(connection, device1, device2);
    }

    @Override
    public boolean addEdge(final Connection connection, final Device device1, final Device device2) {
        return (Boolean)this.getHistory().execute(new Command(){

            @Override
            public Object undo() {
                device1.removeInterface(device1.getInterfaceFor(connection));
                device2.removeInterface(device2.getInterfaceFor(connection));
                boolean b = Map.this.graph.removeEdge(connection);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_REMOVED, connection));
                return b;
            }

            @Override
            public Object redo() {
                Map.this.addInterfaceIfMissing(connection, device1, device2);
                Map.this.addInterfaceIfMissing(connection, device2, device1);
                boolean b = Map.this.graph.addEdge(connection, device1, device2);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_ADDED, connection));
                return b;
            }

            @Override
            public String toString() {
                return Lang.getNoHTML("command.add.connection") + ": " + device1.getName() + " \u2194 " + device2.getName();
            }
        });
    }

    private void addInterfaceIfMissing(Connection conection, Device device1, Device device2) {
        if (device1.getInterfaceFor(conection) == null) {
            if (device1.equals(device2)) {
                device1.addInterface(new LogicalIF(device1, conection, ""));
            } else {
                String t = device1.getType().toString() + "";
                NetworkIF nif = t.contains("Switch") || t.contains("Hub") || t.contains("Wireless") ? new TransparentIF(device1, conection, device2.getInterfaceFor(conection)) : new PhysicalIF(device1, conection, "");
                device1.addInterface(nif);
                NetworkIF counterpart = device2.getInterfaceFor(conection);
                if (counterpart != null && counterpart instanceof TransparentIF) {
                    ((TransparentIF)counterpart).setCounterpart(nif);
                }
            }
        }
    }

    @Override
    public boolean addVertex(final Device device) {
        return (Boolean)this.getHistory().execute(new Command(){

            @Override
            public Object undo() {
                boolean b = Map.this.graph.removeVertex(device);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.VERTEX_REMOVED, device));
                device.removeDeviceListener(Map.this._this);
                return b;
            }

            @Override
            public Object redo() {
                boolean b = Map.this.graph.addVertex(device);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.VERTEX_ADDED, device));
                device.addDeviceListener(Map.this._this);
                return b;
            }

            @Override
            public String toString() {
                return Lang.getNoHTML("command.add.device") + ": " + device.getName();
            }
        });
    }

    @Override
    public boolean containsEdge(Connection connection) {
        return this.graph.containsEdge(connection);
    }

    @Override
    public boolean containsVertex(Device device) {
        return this.graph.containsVertex(device);
    }

    @Override
    public int degree(Device device) {
        return this.graph.degree(device);
    }

    @Override
    public Connection findEdge(Device device1, Device device2) {
        return (Connection)this.graph.findEdge(device1, device2);
    }

    @Override
    public Collection<Connection> findEdgeSet(Device device1, Device device2) {
        return this.graph.findEdgeSet(device1, device2);
    }

    @Override
    public EdgeType getDefaultEdgeType() {
        return this.graph.getDefaultEdgeType();
    }

    @Override
    public Device getDest(Connection connection) {
        return this.graph.getDest(connection);
    }

    @Override
    public int getEdgeCount() {
        return this.graph.getEdgeCount();
    }

    @Override
    public int getEdgeCount(EdgeType edgeType) {
        return this.graph.getEdgeCount(edgeType);
    }

    @Override
    public Collection<Connection> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public Collection<Connection> getEdges(EdgeType edgeType) {
        return this.graph.getEdges(edgeType);
    }

    @Override
    public EdgeType getEdgeType(Connection connection) {
        return this.graph.getEdgeType(connection);
    }

    @Override
    public Pair<Device> getEndpoints(Connection connection) {
        return this.graph.getEndpoints(connection);
    }

    @Override
    public int getIncidentCount(Connection connection) {
        return this.graph.getIncidentCount(connection);
    }

    @Override
    public Collection<Connection> getIncidentEdges(Device device) {
        return this.graph.getIncidentEdges(device);
    }

    @Override
    public Collection<Device> getIncidentVertices(Connection connection) {
        return this.graph.getIncidentVertices(connection);
    }

    @Override
    public Collection<Connection> getInEdges(Device device) {
        return this.graph.getInEdges(device);
    }

    @Override
    public int getNeighborCount(Device device) {
        return this.graph.getNeighborCount(device);
    }

    @Override
    public Collection<Device> getNeighbors(Device device) {
        return this.graph.getNeighbors(device);
    }

    @Override
    public Device getOpposite(Device device, Connection connection) {
        return this.graph.getOpposite(device, connection);
    }

    @Override
    public Collection<Connection> getOutEdges(Device device) {
        return this.graph.getOutEdges(device);
    }

    @Override
    public int getPredecessorCount(Device device) {
        return this.graph.getPredecessorCount(device);
    }

    @Override
    public Collection<Device> getPredecessors(Device device) {
        return this.graph.getPredecessors(device);
    }

    @Override
    public Device getSource(Connection connection) {
        return this.graph.getSource(connection);
    }

    @Override
    public int getSuccessorCount(Device device) {
        return this.graph.getSuccessorCount(device);
    }

    @Override
    public Collection<Device> getSuccessors(Device device) {
        return this.graph.getSuccessors(device);
    }

    @Override
    public int getVertexCount() {
        return this.graph.getVertexCount();
    }

    @Override
    public Collection<Device> getVertices() {
        return this.graph.getVertices();
    }

    @Override
    public int inDegree(Device device) {
        return this.graph.inDegree(device);
    }

    @Override
    public boolean isDest(Device device, Connection connection) {
        return this.graph.isDest(device, connection);
    }

    @Override
    public boolean isIncident(Device device, Connection connection) {
        return this.graph.isIncident(device, connection);
    }

    @Override
    public boolean isNeighbor(Device device1, Device device2) {
        return this.graph.isNeighbor(device1, device2);
    }

    @Override
    public boolean isPredecessor(Device device1, Device device2) {
        return this.graph.isPredecessor(device1, device2);
    }

    @Override
    public boolean isSource(Device device, Connection connection) {
        return this.graph.isSource(device, connection);
    }

    @Override
    public boolean isSuccessor(Device device1, Device device2) {
        return this.graph.isSuccessor(device1, device2);
    }

    @Override
    public int outDegree(Device device) {
        return this.graph.outDegree(device);
    }

    @Override
    public boolean removeEdge(final Connection connection) {
        return (Boolean)this.getHistory().execute(new Command(){
            private Pair<Device> pair;
            {
                this.pair = Map.this.getEndpoints(connection);
            }

            @Override
            public Object undo() {
                if (this.pair.getFirst() != null) {
                    this.pair.getFirst().addInterface(this.pair.getFirst().getInterfaceFor(connection));
                }
                if (this.pair.getSecond() != null) {
                    this.pair.getSecond().addInterface(this.pair.getSecond().getInterfaceFor(connection));
                }
                boolean b = Map.this.graph.addEdge(connection, this.pair);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_ADDED, connection));
                return b;
            }

            @Override
            public Object redo() {
                if (this.pair.getFirst() != null) {
                    this.pair.getFirst().removeInterface(this.pair.getFirst().getInterfaceFor(connection));
                }
                if (this.pair.getSecond() != null) {
                    this.pair.getSecond().removeInterface(this.pair.getSecond().getInterfaceFor(connection));
                }
                boolean b = Map.this.graph.removeEdge(connection);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.EDGE_REMOVED, connection));
                Map.this.refreshView(null);
                return b;
            }

            @Override
            public String toString() {
                return Lang.getNoHTML("command.remove.connection") + ": " + this.pair.getFirst().getName() + " \u2194 " + this.pair.getSecond().getName();
            }
        });
    }

    @Override
    public boolean removeVertex(final Device device) {
        return (Boolean)this.getHistory().execute(new Command(){
            HashMap<Pair<Device>, Connection> connectors = new HashMap();
            HashMap<Connection, NetworkIF> oppositeIFs = new HashMap();

            @Override
            public Object undo() {
                boolean b = Map.this.graph.addVertex(device);
                for (Pair<Device> p : this.connectors.keySet()) {
                    Connection c = this.connectors.get(p);
                    Map.this.graph.addEdge(c, p);
                    Device other = p.getFirst().equals(device) ? p.getSecond() : p.getFirst();
                    other.addInterface(this.oppositeIFs.get(c));
                }
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.VERTEX_ADDED, device));
                device.addDeviceListener(Map.this._this);
                return b;
            }

            @Override
            public Object redo() {
                for (Connection c : Map.this.graph.getOutEdges(device)) {
                    Pair pair = Map.this.graph.getEndpoints(c);
                    this.connectors.put(pair, c);
                    Device other = ((Device)pair.getFirst()).equals(device) ? (Device)pair.getSecond() : (Device)pair.getFirst();
                    NetworkIF nif = other.getInterfaceFor(c);
                    this.oppositeIFs.put(c, nif);
                    other.removeInterface(nif);
                }
                boolean b = Map.this.graph.removeVertex(device);
                Map.this.notifyListeners(new MapEvent(Map.this._this, MapEvent.Type.VERTEX_REMOVED, device));
                device.removeDeviceListener(Map.this._this);
                return b;
            }

            @Override
            public String toString() {
                return Lang.getNoHTML("command.remove.device") + ": " + device.getName();
            }
        });
    }

    @Override
    public void deviceChanged(DeviceEvent e) {
        this.notifyListeners(new MapEvent(this, MapEvent.Type.DEVICE_EVENT, e));
    }

    public void setPassword(String password) {
        if (password == null) {
            return;
        }
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUpdateInterval(double updateInterval) {
        if (updateInterval <= 0.0) {
            return;
        }
        this.updateInterval = updateInterval;
    }

    public double getUpdateInterval() {
        return this.updateInterval;
    }

    public File getBackground() {
        return this.background;
    }

    public void setBackground(File background) {
        this.background = background;
        try {
            if (background != null) {
                this.backgroundImage = new ImageIcon(background.getAbsolutePath()).getImage();
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to load background image", e);
            this.background = null;
        }
    }

    public Image getBackgroundImage() {
        if (this.backgroundImage == null && this.background != null) {
            this.setBackground(this.background);
        }
        return this.backgroundImage;
    }

    public Set<Layer> getLayers() {
        return this.layers;
    }

    public void addLayer(String name) {
        this.layers.add(new Layer(name));
    }

    public void removeLayer(Layer layer) {
        if (this.layers.size() > 1) {
            Set<Device> devices = layer.getDevices();
            this.layers.remove(layer);
            this.layers.iterator().next().addDevices(devices);
        }
    }

    public Predicate<Context<Graph<Device, Connection>, Device>> getDevicePredicate() {
        return context -> {
            if (this.layers != null && !this.layers.isEmpty()) {
                for (Layer layer : this.layers) {
                    if (!layer.containsDevice((Device)context.element)) continue;
                    return layer.isVisible();
                }
            }
            return true;
        };
    }

    public void refreshView() {
        this.refreshView(null);
    }

    public void refreshView(MapEvent.Type type) {
        if (type == null) {
            type = MapEvent.Type.REFRESH;
        }
        this.notifyListeners(new MapEvent(this, type, null));
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isSaved() {
        return this.saved;
    }
}

