/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model.IF;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.LinkedList;

@XStreamAlias(value="LogicalIF")
public class LogicalIF
implements NetworkIF {
    private String name = "";
    private InetAddress address;
    private Subnet subnet;
    private Device device;
    private Connection connection;

    public LogicalIF() {
    }

    public LogicalIF(Device parent, Connection connection, String addr) {
        this.device = parent;
        this.connection = connection;
        this.setAddress(addr);
        this.name = "lo" + parent.getInterfaces().size();
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String getCanonicalName() {
        return this.address.getCanonicalHostName();
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public InetAddress getGateway() {
        return null;
    }

    @Override
    public Date getLastSeen() {
        return this.device.getLastSeen();
    }

    @Override
    public String getName() {
        return this.address.getHostName();
    }

    @Override
    public Status getStatus() {
        return this.device.getStatus();
    }

    @Override
    public Subnet getSubnet() {
        if (this.subnet == null) {
            this.subnet = new Subnet("127.0.0.1/24");
        }
        return this.subnet;
    }

    @Override
    public boolean setAddress(String addr) {
        try {
            this.address = InetAddress.getByName(addr);
            return true;
        }
        catch (UnknownHostException e) {
            System.err.println("Address not found: " + addr);
            return false;
        }
    }

    @Override
    public boolean setGateway(String gateway) {
        return true;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public boolean setSubnet(String subnet) {
        if (subnet == null || subnet.isEmpty()) {
            return false;
        }
        if (!subnet.contains(".")) {
            try {
                this.subnet = new Subnet(subnet);
            }
            catch (Exception e) {
                Logger.warn("Invalid CIDR-format for subnet " + subnet);
                return false;
            }
        }
        try {
            this.subnet = new Subnet(this.address.getHostAddress(), subnet);
        }
        catch (Exception e) {
            Logger.warn("Address undefined or Subnet not found: " + subnet);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name + ": " + this.address.getHostAddress();
    }

    @Override
    public String toHtmlString() {
        return "<span style=\"color: " + this.getStatus().getHtmlValue() + "\">" + this.toString() + "</span>";
    }

    @Override
    public void updateStatus() {
        this.connection.setStatus(this, this.getStatus());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public LinkedList<Tuple<Date, Status>> getStatusHistory() {
        return this.device.getStatusHistory();
    }

    @Override
    public void addStatusUnknownToHistory() {
    }

    @Override
    public long getLatency() {
        return 0L;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

