/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model;

import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;

public class Connection {
    private Type type;
    private Status status;
    private double bandwidth;
    @XStreamOmitField
    private Long latency;
    private String name;
    private Map<NetworkIF, Status> statusMap;

    public Connection() {
        this(Type.Ethernet, 100.0);
    }

    public Connection(Type type) {
        this(type, 100.0);
    }

    public Connection(Type type, double bandwidth) {
        this.setType(type);
        this.setBandwidth(bandwidth);
        this.status = Status.UNKNOWN;
        this.statusMap = new HashMap<NetworkIF, Status>(2);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public Status getStatus() {
        return this.status;
    }

    public Type getType() {
        return this.type;
    }

    public void setBandwidth(double bandwidth) {
        if (bandwidth > 0.0) {
            this.bandwidth = bandwidth;
        }
    }

    public void setStatus(NetworkIF netIF, Status netStatus) {
        if (netIF == null) {
            return;
        }
        this.statusMap.put(netIF, netStatus);
        Logger.trace("Updating connection status from " + netIF.getName() + ": " + (Object)((Object)netStatus));
        Status newStatus = null;
        for (Status s : this.statusMap.values()) {
            if (newStatus != null && newStatus.compareTo(s) <= 0) continue;
            newStatus = s;
        }
        if (this.status != newStatus) {
            this.status = newStatus;
            Logger.trace("Connection status was " + (Object)((Object)this.status) + ", is " + (Object)((Object)newStatus));
        }
    }

    public void updateStatus() {
        for (NetworkIF nif : this.statusMap.keySet()) {
            nif.updateStatus();
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Long getLatency() {
        return this.latency;
    }

    public void setLatency(Long latency) {
        this.latency = latency;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void clearStatusMap() {
        this.statusMap.clear();
    }

    public static enum Type {
        Coaxial,
        Ethernet,
        Fiber,
        Phone,
        Serial,
        Tunnel,
        Wireless;

    }
}

