/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.controller;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.Arp;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.StatusBar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class StatusUpdater {
    private static Map<ch.rakudave.jnetmap.model.Map, ScheduledFuture<?>> maps = new HashMap();

    public static void addMap(ch.rakudave.jnetmap.model.Map m) {
        if (!maps.containsKey(m)) {
            Logger.debug("Adding scheduled task for " + m.getFileName() + ", running every " + m.getUpdateInterval() + "m");
            maps.put(m, Scheduler.scheduleAtFixedRate(() -> StatusUpdater.refresh(m), 0L, (int)(m.getUpdateInterval() * 60.0), TimeUnit.SECONDS));
        }
    }

    public static void removeMap(ch.rakudave.jnetmap.model.Map m) {
        if (maps.containsKey(m)) {
            maps.remove(m).cancel(true);
            Logger.debug("Removed scheduled task for " + m.getFileName());
        }
    }

    public static void updateTimeInterval(ch.rakudave.jnetmap.model.Map m) {
        StatusUpdater.removeMap(m);
        StatusUpdater.addMap(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(ch.rakudave.jnetmap.model.Map m) {
        Logger.debug("Updating devices on map " + m.getFileName());
        StatusBar.getInstance().setBusy(true);
        ExecutorService es = Executors.newFixedThreadPool(Settings.getInt("status.update.threads", 5));
        Collection<Connection> connections = m.getEdges();
        for (Connection connection : connections) {
            connection.clearStatusMap();
        }
        Collection<Device> vertecies = m.getVertices();
        CountDownLatch latch = new CountDownLatch(vertecies.size());
        StatusBar.getInstance().setMessage(Lang.getNoHTML("message.status.update").replaceAll("%name%", m.getFileName() + ".jnm"));
        for (Device d : vertecies) {
            es.submit(() -> {
                try {
                    d.updateStatus();
                    StatusBar.getInstance().setProgress((int)((double)((float)((long)vertecies.size() - latch.getCount()) / (float)vertecies.size()) * 100.0));
                }
                catch (Exception e) {
                    Logger.error("Unable to update device " + d.getName(), e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        es.shutdown();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Logger.debug("Failed to await map refresh latch", e);
        }
        finally {
            StatusBar.getInstance().clearMessage();
            StatusBar.getInstance().setProgress(-1);
            StatusBar.getInstance().setBusy(false);
        }
        if (Settings.getBoolean("arp.query", true)) {
            Arp.updateArpTable();
            HashMap<String, String> arpTable = Arp.getArpTable();
            for (Device device : m.getVertices()) {
                for (NetworkIF nif : device.getInterfaces()) {
                    PhysicalIF pif;
                    String macAddress;
                    if (!(nif instanceof PhysicalIF) || nif.getAddress() == null || (macAddress = arpTable.get((pif = (PhysicalIF)nif).getAddress().getHostAddress())) == null || macAddress.equals(pif.getMacAddress())) continue;
                    pif.setMacAddress(macAddress);
                    Logger.debug("Set MAC address for " + pif.getAddress() + " to " + macAddress);
                    m.setSaved(false);
                }
            }
        }
        System.gc();
    }
}

