/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;

final class SignatureAlgorithmsExtension {
    static final HandshakeProducer chNetworkProducer = new CHSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHSignatureSchemesConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new CHSignatureSchemesOnLoadAbsence();
    static final HandshakeConsumer chOnTradeConsumer = new CHSignatureSchemesUpdate();
    static final HandshakeAbsence chOnTradeAbsence = new CHSignatureSchemesOnTradeAbsence();
    static final HandshakeProducer crNetworkProducer = new CRSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRSignatureSchemesConsumer();
    static final HandshakeAbsence crOnLoadAbsence = new CRSignatureSchemesAbsence();
    static final HandshakeConsumer crOnTradeConsumer = new CRSignatureSchemesUpdate();
    static final SSLStringizer ssStringizer = new SignatureSchemesStringizer();

    SignatureAlgorithmsExtension() {
    }

    private static final class CHSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SignatureSchemesSpec signatureSchemesSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms extension", new Object[0]);
                }
                return;
            }
            try {
                signatureSchemesSpec = new SignatureSchemesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS, signatureSchemesSpec);
        }
    }

    private static final class CHSignatureSchemesOnLoadAbsence
    implements HandshakeAbsence {
        private CHSignatureSchemesOnLoadAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                serverHandshakeContext.conContext.fatal(Alert.MISSING_EXTENSION, "No mandatory signature_algorithms extension in the received CertificateRequest handshake message");
            }
        }
    }

    private static final class CHSignatureSchemesOnTradeAbsence
    implements HandshakeAbsence {
        private CHSignatureSchemesOnTradeAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.negotiatedProtocol.useTLS12PlusSpec()) {
                List<SignatureScheme> list;
                serverHandshakeContext.peerRequestedSignatureSchemes = list = Arrays.asList(SignatureScheme.RSA_PKCS1_SHA1, SignatureScheme.DSA_SHA1, SignatureScheme.ECDSA_SHA1);
                if (serverHandshakeContext.peerRequestedCertSignSchemes == null || serverHandshakeContext.peerRequestedCertSignSchemes.isEmpty()) {
                    serverHandshakeContext.peerRequestedCertSignSchemes = list;
                }
                serverHandshakeContext.handshakeSession.setUseDefaultPeerSignAlgs();
            }
        }
    }

    private static final class CHSignatureSchemesProducer
    implements HandshakeProducer {
        private CHSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms extension", new Object[0]);
                }
                return null;
            }
            if (clientHandshakeContext.localSupportedSignAlgs == null) {
                clientHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(clientHandshakeContext.sslConfig, clientHandshakeContext.algorithmConstraints, clientHandshakeContext.activeProtocols);
            }
            int n = SignatureScheme.sizeInRecord() * clientHandshakeContext.localSupportedSignAlgs.size();
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (SignatureScheme signatureScheme : clientHandshakeContext.localSupportedSignAlgs) {
                Record.putInt16(byteBuffer, signatureScheme.id);
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS, new SignatureSchemesSpec(clientHandshakeContext.localSupportedSignAlgs));
            return byArray;
        }
    }

    private static final class CHSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CHSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            List<SignatureScheme> list;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SignatureSchemesSpec signatureSchemesSpec = (SignatureSchemesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS);
            if (signatureSchemesSpec == null) {
                return;
            }
            serverHandshakeContext.peerRequestedSignatureSchemes = list = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.negotiatedProtocol, signatureSchemesSpec.signatureSchemes);
            SignatureSchemesSpec signatureSchemesSpec2 = (SignatureSchemesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT);
            if (signatureSchemesSpec2 == null) {
                serverHandshakeContext.peerRequestedCertSignSchemes = list;
                serverHandshakeContext.handshakeSession.setPeerSupportedSignatureAlgorithms(list);
            }
            if (!serverHandshakeContext.isResumption && serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                if (serverHandshakeContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_NONE) {
                    serverHandshakeContext.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                }
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
                serverHandshakeContext.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            }
        }
    }

    private static final class CRSignatureSchemesAbsence
    implements HandshakeAbsence {
        private CRSignatureSchemesAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.conContext.fatal(Alert.MISSING_EXTENSION, "No mandatory signature_algorithms extension in the received CertificateRequest handshake message");
        }
    }

    private static final class CRSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SignatureSchemesSpec signatureSchemesSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CR_SIGNATURE_ALGORITHMS)) {
                clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No available signature_algorithms extension for client certificate authentication");
                return;
            }
            try {
                signatureSchemesSpec = new SignatureSchemesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            LinkedList<SignatureScheme> linkedList = new LinkedList<SignatureScheme>();
            for (int n : signatureSchemesSpec.signatureSchemes) {
                SignatureScheme signatureScheme = SignatureScheme.valueOf(n);
                if (signatureScheme == null) continue;
                linkedList.add(signatureScheme);
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS, signatureSchemesSpec);
        }
    }

    private static final class CRSignatureSchemesProducer
    implements HandshakeProducer {
        private CRSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CR_SIGNATURE_ALGORITHMS)) {
                serverHandshakeContext.conContext.fatal(Alert.MISSING_EXTENSION, "No available signature_algorithms extension for client certificate authentication");
                return null;
            }
            List<SignatureScheme> list = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, Collections.singletonList(serverHandshakeContext.negotiatedProtocol));
            int n = SignatureScheme.sizeInRecord() * list.size();
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (SignatureScheme signatureScheme : list) {
                Record.putInt16(byteBuffer, signatureScheme.id);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS, new SignatureSchemesSpec(serverHandshakeContext.localSupportedSignAlgs));
            return byArray;
        }
    }

    private static final class CRSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CRSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            List<SignatureScheme> list;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SignatureSchemesSpec signatureSchemesSpec = (SignatureSchemesSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS);
            if (signatureSchemesSpec == null) {
                return;
            }
            clientHandshakeContext.peerRequestedSignatureSchemes = list = SignatureScheme.getSupportedAlgorithms(clientHandshakeContext.sslConfig, clientHandshakeContext.algorithmConstraints, clientHandshakeContext.negotiatedProtocol, signatureSchemesSpec.signatureSchemes);
            SignatureSchemesSpec signatureSchemesSpec2 = (SignatureSchemesSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT);
            if (signatureSchemesSpec2 == null) {
                clientHandshakeContext.peerRequestedCertSignSchemes = list;
                clientHandshakeContext.handshakeSession.setPeerSupportedSignatureAlgorithms(list);
            }
        }
    }

    static final class SignatureSchemesSpec
    implements SSLExtension.SSLExtensionSpec {
        final int[] signatureSchemes;

        SignatureSchemesSpec(List<SignatureScheme> list) {
            if (list != null) {
                this.signatureSchemes = new int[list.size()];
                int n = 0;
                for (SignatureScheme signatureScheme : list) {
                    this.signatureSchemes[n++] = signatureScheme.id;
                }
            } else {
                this.signatureSchemes = new int[0];
            }
        }

        SignatureSchemesSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid signature_algorithms: insufficient data");
            }
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid signature_algorithms: unknown extra data");
            }
            if (byArray == null || byArray.length == 0 || (byArray.length & 1) != 0) {
                throw new SSLProtocolException("Invalid signature_algorithms: incomplete data");
            }
            int[] nArray = new int[byArray.length / 2];
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                nArray[n2++] = (by & 0xFF) << 8 | by2 & 0xFF;
            }
            this.signatureSchemes = nArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"signature schemes\": '['{0}']'", Locale.ENGLISH);
            if (this.signatureSchemes == null || this.signatureSchemes.length == 0) {
                Object[] objectArray = new Object[]{"<no supported signature schemes specified>"};
                return messageFormat.format(objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (int n : this.signatureSchemes) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(SignatureScheme.nameOf(n));
            }
            Object[] objectArray = new Object[]{stringBuilder.toString()};
            return messageFormat.format(objectArray);
        }
    }

    private static final class SignatureSchemesStringizer
    implements SSLStringizer {
        private SignatureSchemesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SignatureSchemesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }
}

