/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherType;
import sun.security.ssl.ContentType;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLLogger;

enum SSLCipher {
    B_NULL("NULL", CipherType.NULL_CIPHER, 0, 0, 0, 0, true, true, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<NullReadCipherGenerator, ProtocolVersion[]>(new NullReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_NONE), new AbstractMap.SimpleImmutableEntry<NullReadCipherGenerator, ProtocolVersion[]>(new NullReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<NullWriteCipherGenerator, ProtocolVersion[]>(new NullWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_NONE), new AbstractMap.SimpleImmutableEntry<NullWriteCipherGenerator, ProtocolVersion[]>(new NullWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_13)}),
    B_RC4_40("RC4", CipherType.STREAM_CIPHER, 5, 16, 0, 0, true, true, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamReadCipherGenerator, ProtocolVersion[]>(new StreamReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamWriteCipherGenerator, ProtocolVersion[]>(new StreamWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}),
    B_RC2_40("RC2", CipherType.BLOCK_CIPHER, 5, 16, 8, 0, false, true, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamReadCipherGenerator, ProtocolVersion[]>(new StreamReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamWriteCipherGenerator, ProtocolVersion[]>(new StreamWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}),
    B_DES_40("DES/CBC/NoPadding", CipherType.BLOCK_CIPHER, 5, 8, 8, 0, true, true, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockReadCipherGenerator, ProtocolVersion[]>(new T10BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockWriteCipherGenerator, ProtocolVersion[]>(new T10BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10)}),
    B_RC4_128("RC4", CipherType.STREAM_CIPHER, 16, 16, 0, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamReadCipherGenerator, ProtocolVersion[]>(new StreamReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<StreamWriteCipherGenerator, ProtocolVersion[]>(new StreamWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_12)}),
    B_DES("DES/CBC/NoPadding", CipherType.BLOCK_CIPHER, 8, 8, 8, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockReadCipherGenerator, ProtocolVersion[]>(new T10BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockReadCipherGenerator, ProtocolVersion[]>(new T11BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_11)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockWriteCipherGenerator, ProtocolVersion[]>(new T10BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockWriteCipherGenerator, ProtocolVersion[]>(new T11BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_11)}),
    B_3DES("DESede/CBC/NoPadding", CipherType.BLOCK_CIPHER, 24, 24, 8, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockReadCipherGenerator, ProtocolVersion[]>(new T10BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockReadCipherGenerator, ProtocolVersion[]>(new T11BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockWriteCipherGenerator, ProtocolVersion[]>(new T10BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockWriteCipherGenerator, ProtocolVersion[]>(new T11BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}),
    B_IDEA("IDEA", CipherType.BLOCK_CIPHER, 16, 16, 8, 0, false, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Object, ProtocolVersion[]>(null, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Object, ProtocolVersion[]>(null, ProtocolVersion.PROTOCOLS_TO_12)}),
    B_AES_128("AES/CBC/NoPadding", CipherType.BLOCK_CIPHER, 16, 16, 16, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockReadCipherGenerator, ProtocolVersion[]>(new T10BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockReadCipherGenerator, ProtocolVersion[]>(new T11BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockWriteCipherGenerator, ProtocolVersion[]>(new T10BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockWriteCipherGenerator, ProtocolVersion[]>(new T11BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}),
    B_AES_256("AES/CBC/NoPadding", CipherType.BLOCK_CIPHER, 32, 32, 16, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockReadCipherGenerator, ProtocolVersion[]>(new T10BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockReadCipherGenerator, ProtocolVersion[]>(new T11BlockReadCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T10BlockWriteCipherGenerator, ProtocolVersion[]>(new T10BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_TO_10), new AbstractMap.SimpleImmutableEntry<T11BlockWriteCipherGenerator, ProtocolVersion[]>(new T11BlockWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_11_12)}),
    B_AES_128_GCM("AES/GCM/NoPadding", CipherType.AEAD_CIPHER, 16, 16, 12, 4, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T12GcmReadCipherGenerator, ProtocolVersion[]>(new T12GcmReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T12GcmWriteCipherGenerator, ProtocolVersion[]>(new T12GcmWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_12)}),
    B_AES_256_GCM("AES/GCM/NoPadding", CipherType.AEAD_CIPHER, 32, 32, 12, 4, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T12GcmReadCipherGenerator, ProtocolVersion[]>(new T12GcmReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T12GcmWriteCipherGenerator, ProtocolVersion[]>(new T12GcmWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_12)}),
    B_AES_128_GCM_IV("AES/GCM/NoPadding", CipherType.AEAD_CIPHER, 16, 16, 12, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T13GcmReadCipherGenerator, ProtocolVersion[]>(new T13GcmReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T13GcmWriteCipherGenerator, ProtocolVersion[]>(new T13GcmWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_13)}),
    B_AES_256_GCM_IV("AES/GCM/NoPadding", CipherType.AEAD_CIPHER, 32, 32, 12, 0, true, false, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T13GcmReadCipherGenerator, ProtocolVersion[]>(new T13GcmReadCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<T13GcmWriteCipherGenerator, ProtocolVersion[]>(new T13GcmWriteCipherGenerator(), ProtocolVersion.PROTOCOLS_OF_13)});

    final String description;
    final String transformation;
    final String algorithm;
    final boolean allowed;
    final int keySize;
    final int expandedKeySize;
    final int ivSize;
    final int fixedIvSize;
    final boolean exportable;
    final CipherType cipherType;
    final int tagSize = 16;
    private final boolean isAvailable;
    private final Map.Entry<ReadCipherGenerator, ProtocolVersion[]>[] readCipherGenerators;
    private final Map.Entry<WriteCipherGenerator, ProtocolVersion[]>[] writeCipherGenerators;
    private static final HashMap<String, Long> cipherLimits;
    static final String[] tag;

    private SSLCipher(String string2, CipherType cipherType, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, Map.Entry<ReadCipherGenerator, ProtocolVersion[]>[] entryArray, Map.Entry<WriteCipherGenerator, ProtocolVersion[]>[] entryArray2) {
        this.transformation = string2;
        String[] stringArray = string2.split("/");
        this.algorithm = stringArray[0];
        this.cipherType = cipherType;
        this.description = this.algorithm + "/" + (n2 << 3);
        this.keySize = n2;
        this.ivSize = n4;
        this.fixedIvSize = n5;
        this.allowed = bl;
        this.expandedKeySize = n3;
        this.exportable = bl2;
        this.isAvailable = bl && SSLCipher.isUnlimited(n2, string2) && SSLCipher.isTransformationAvailable(string2);
        this.readCipherGenerators = entryArray;
        this.writeCipherGenerators = entryArray2;
    }

    private static boolean isTransformationAvailable(String string) {
        if (string.equals("NULL")) {
            return true;
        }
        try {
            JsseJce.getCipher(string);
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("Transformation " + string + " is not available.", new Object[0]);
            }
            return false;
        }
    }

    SSLReadCipher createReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
        if (this.readCipherGenerators.length == 0) {
            return null;
        }
        ReadCipherGenerator readCipherGenerator = null;
        for (Map.Entry<ReadCipherGenerator, ProtocolVersion[]> entry : this.readCipherGenerators) {
            for (ProtocolVersion protocolVersion2 : entry.getValue()) {
                if (protocolVersion != protocolVersion2) continue;
                readCipherGenerator = entry.getKey();
            }
        }
        if (readCipherGenerator != null) {
            return readCipherGenerator.createCipher(this, authenticator, protocolVersion, this.transformation, secretKey, ivParameterSpec, secureRandom);
        }
        return null;
    }

    SSLWriteCipher createWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
        if (this.writeCipherGenerators.length == 0) {
            return null;
        }
        WriteCipherGenerator writeCipherGenerator = null;
        for (Map.Entry<WriteCipherGenerator, ProtocolVersion[]> entry : this.writeCipherGenerators) {
            for (ProtocolVersion protocolVersion2 : entry.getValue()) {
                if (protocolVersion != protocolVersion2) continue;
                writeCipherGenerator = entry.getKey();
            }
        }
        if (writeCipherGenerator != null) {
            return writeCipherGenerator.createCipher(this, authenticator, protocolVersion, this.transformation, secretKey, ivParameterSpec, secureRandom);
        }
        return null;
    }

    boolean isAvailable() {
        return this.isAvailable;
    }

    private static boolean isUnlimited(int n, String string) {
        int n2 = n * 8;
        if (n2 > 128) {
            try {
                if (Cipher.getMaxAllowedKeyLength(string) < n2) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.description;
    }

    private static void addMac(Authenticator.MAC mAC, ByteBuffer byteBuffer, byte by) {
        if (mAC.macAlg().size != 0) {
            int n = byteBuffer.position();
            byte[] byArray = mAC.compute(by, byteBuffer, false);
            byteBuffer.limit(byteBuffer.limit() + byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.position(n);
        }
    }

    private static void checkStreamMac(Authenticator.MAC mAC, ByteBuffer byteBuffer, byte by, byte[] byArray) throws BadPaddingException {
        int n = mAC.macAlg().size;
        if (n != 0) {
            int n2 = byteBuffer.remaining() - n;
            if (n2 < 0) {
                throw new BadPaddingException("bad record");
            }
            if (SSLCipher.checkMacTags(by, byteBuffer, mAC, byArray, false)) {
                throw new BadPaddingException("bad record MAC");
            }
        }
    }

    private static void checkCBCMac(Authenticator.MAC mAC, ByteBuffer byteBuffer, byte by, int n, byte[] byArray) throws BadPaddingException {
        BadPaddingException badPaddingException = null;
        int n2 = mAC.macAlg().size;
        int n3 = byteBuffer.position();
        if (n2 != 0) {
            int n4 = byteBuffer.remaining() - n2;
            if (n4 < 0) {
                badPaddingException = new BadPaddingException("bad record");
                n4 = n - n2;
                byteBuffer.limit(n3 + n);
            }
            if (SSLCipher.checkMacTags(by, byteBuffer, mAC, byArray, false) && badPaddingException == null) {
                badPaddingException = new BadPaddingException("bad record MAC");
            }
            int n5 = SSLCipher.calculateRemainingLen(mAC, n, n4);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5 += mAC.macAlg().size);
            SSLCipher.checkMacTags(by, byteBuffer2, mAC, byArray, true);
        }
        if (badPaddingException != null) {
            throw badPaddingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMacTags(byte by, ByteBuffer byteBuffer, Authenticator.MAC mAC, byte[] byArray, boolean bl) {
        int n = mAC.macAlg().size;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n3 - n;
        byteBuffer.limit(n4);
        byte[] byArray2 = mAC.compute(by, byteBuffer, byArray, bl);
        if (byArray2 == null || n != byArray2.length) {
            throw new RuntimeException("Internal MAC error");
        }
        byteBuffer.position(n4);
        byteBuffer.limit(n3);
        try {
            int[] nArray = SSLCipher.compareMacTags(byteBuffer, byArray2);
            boolean bl2 = nArray[0] != 0;
            return bl2;
        }
        finally {
            byteBuffer.position(n2);
            byteBuffer.limit(n4);
        }
    }

    private static int[] compareMacTags(ByteBuffer byteBuffer, byte[] byArray) {
        int[] nArray = new int[]{0, 0};
        for (byte by : byArray) {
            if (byteBuffer.get() != by) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    private static int calculateRemainingLen(Authenticator.MAC mAC, int n, int n2) {
        int n3 = mAC.macAlg().hashBlockSize;
        int n4 = mAC.macAlg().minimalPaddingSize;
        return 1 + (int)(Math.ceil((double)(n += 13 - (n3 - n4)) / (1.0 * (double)n3)) - Math.ceil((double)(n2 += 13 - (n3 - n4)) / (1.0 * (double)n3))) * n3;
    }

    private static int addPadding(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = n2 + 1;
        if (n4 % n != 0) {
            n4 += n - 1;
            n4 -= n4 % n;
        }
        int n5 = n4 - n2;
        byteBuffer.limit(n4 + n3);
        n3 += n2;
        for (int i = 0; i < n5; ++i) {
            byteBuffer.put(n3++, (byte)(n5 - 1));
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n3);
        return n4;
    }

    private static int removePadding(ByteBuffer byteBuffer, int n, int n2, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n3;
        int n4;
        int n5;
        int n6 = byteBuffer.remaining();
        int n7 = n6 - ((n5 = byteBuffer.get(n4 = (n3 = byteBuffer.position()) + n6 - 1) & 0xFF) + 1);
        if (n7 - n < 0) {
            SSLCipher.checkPadding(byteBuffer.duplicate(), (byte)(n5 & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + n5);
        }
        int[] nArray = SSLCipher.checkPadding((ByteBuffer)byteBuffer.duplicate().position(n3 + n7), (byte)(n5 & 0xFF));
        if (protocolVersion.useTLS10PlusSpec()) {
            if (nArray[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (n5 > n2) {
            throw new BadPaddingException("Padding length (" + n5 + ") of SSLv3 message should not be bigger than the block size (" + n2 + ")");
        }
        byteBuffer.limit(n3 + n7);
        return n7;
    }

    private static int[] checkPadding(ByteBuffer byteBuffer, byte by) {
        if (!byteBuffer.hasRemaining()) {
            throw new RuntimeException("hasRemaining() must be positive");
        }
        int[] nArray = new int[]{0, 0};
        byteBuffer.mark();
        int n = 0;
        while (n <= 256) {
            while (byteBuffer.hasRemaining() && n <= 256) {
                if (byteBuffer.get() != by) {
                    nArray[0] = nArray[0] + 1;
                } else {
                    nArray[1] = nArray[1] + 1;
                }
                ++n;
            }
            byteBuffer.reset();
        }
        return nArray;
    }

    static {
        cipherLimits = new HashMap();
        tag = new String[]{"KEYUPDATE"};
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("jdk.tls.keyLimits");
            }
        });
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                long l;
                String[] stringArray2 = string2.trim().toUpperCase().split(" ");
                if (!stringArray2[1].contains(tag[0])) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.fine("jdk.tls.keyLimits:  Unknown action:  " + string2, new Object[0]);
                    continue;
                }
                int n = 0;
                int n2 = stringArray2[2].indexOf("^");
                try {
                    l = n2 >= 0 ? (long)Math.pow(2.0, Integer.parseInt(stringArray2[2].substring(n2 + 1))) : Long.parseLong(stringArray2[2]);
                    if (l < 1L || l > 0x4000000000000000L) {
                        throw new NumberFormatException("Length exceeded limits");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.fine("jdk.tls.keyLimits:  " + numberFormatException.getMessage() + ":  " + string2, new Object[0]);
                    continue;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine("jdk.tls.keyLimits:  entry = " + string2 + ". " + stringArray2[0] + ":" + tag[n] + " = " + l, new Object[0]);
                }
                cipherLimits.put(stringArray2[0] + ":" + tag[n], l);
            }
        }
    }

    private static final class NullReadCipherGenerator
    implements ReadCipherGenerator {
        private NullReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new NullReadCipher(authenticator, protocolVersion);
        }

        static final class NullReadCipher
        extends SSLReadCipher {
            NullReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion) {
                super(authenticator, protocolVersion);
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.checkStreamMac(mAC, byteBuffer, by, byArray);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n - n2 - n3;
            }

            @Override
            boolean isNullCipher() {
                return true;
            }
        }
    }

    private static final class NullWriteCipherGenerator
    implements WriteCipherGenerator {
        private NullWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new NullWriteCipher(authenticator, protocolVersion);
        }

        static final class NullWriteCipher
        extends SSLWriteCipher {
            NullWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion) {
                super(authenticator, protocolVersion);
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.addMac(mAC, byteBuffer, by);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                int n = byteBuffer.remaining();
                byteBuffer.position(byteBuffer.limit());
                return n;
            }

            @Override
            int getExplicitNonceSize() {
                return 0;
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n - n2 - n3;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n + n2 + n3;
            }

            @Override
            boolean isNullCipher() {
                return true;
            }
        }
    }

    static interface ReadCipherGenerator {
        public SSLReadCipher createCipher(SSLCipher var1, Authenticator var2, ProtocolVersion var3, String var4, Key var5, AlgorithmParameterSpec var6, SecureRandom var7) throws GeneralSecurityException;
    }

    static abstract class SSLReadCipher {
        final Authenticator authenticator;
        final ProtocolVersion protocolVersion;
        boolean keyLimitEnabled = false;
        long keyLimitCountdown = 0L;
        SecretKey baseSecret;

        SSLReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion) {
            this.authenticator = authenticator;
            this.protocolVersion = protocolVersion;
        }

        static final SSLReadCipher nullTlsReadCipher() {
            try {
                return B_NULL.createReadCipher(Authenticator.nullTlsMac(), ProtocolVersion.NONE, null, null, null);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Cannot create NULL SSLCipher", generalSecurityException);
            }
        }

        abstract Plaintext decrypt(byte var1, ByteBuffer var2, byte[] var3) throws GeneralSecurityException;

        void dispose() {
        }

        abstract int estimateFragmentSize(int var1, int var2);

        boolean isNullCipher() {
            return false;
        }

        public boolean atKeyLimit() {
            if (this.keyLimitCountdown >= 0L) {
                return false;
            }
            this.keyLimitEnabled = false;
            return true;
        }
    }

    static abstract class SSLWriteCipher {
        final Authenticator authenticator;
        final ProtocolVersion protocolVersion;
        boolean keyLimitEnabled = false;
        long keyLimitCountdown = 0L;
        SecretKey baseSecret;

        SSLWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion) {
            this.authenticator = authenticator;
            this.protocolVersion = protocolVersion;
        }

        abstract int encrypt(byte var1, ByteBuffer var2);

        static final SSLWriteCipher nullTlsWriteCipher() {
            try {
                return B_NULL.createWriteCipher(Authenticator.nullTlsMac(), ProtocolVersion.NONE, null, null, null);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Cannot create NULL SSL write Cipher", generalSecurityException);
            }
        }

        void dispose() {
        }

        abstract int getExplicitNonceSize();

        abstract int calculateFragmentSize(int var1, int var2);

        abstract int calculatePacketSize(int var1, int var2);

        boolean isCBCMode() {
            return false;
        }

        boolean isNullCipher() {
            return false;
        }

        public boolean atKeyLimit() {
            if (this.keyLimitCountdown >= 0L) {
                return false;
            }
            this.keyLimitEnabled = false;
            return true;
        }
    }

    private static final class StreamReadCipherGenerator
    implements ReadCipherGenerator {
        private StreamReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new StreamReadCipher(authenticator, protocolVersion, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class StreamReadCipher
        extends SSLReadCipher {
            private final Cipher cipher;

            StreamReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.cipher.init(2, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                int n = byteBuffer.remaining();
                int n2 = byteBuffer.position();
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    if (n != this.cipher.update(byteBuffer2, byteBuffer)) {
                        throw new RuntimeException("Unexpected number of plaintext bytes");
                    }
                    if (byteBuffer.position() != byteBuffer2.position()) {
                        throw new RuntimeException("Unexpected ByteBuffer position");
                    }
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                byteBuffer.position(n2);
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Plaintext after DECRYPTION", byteBuffer.duplicate());
                }
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.checkStreamMac(mAC, byteBuffer, by, byArray);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n - n2 - n3;
            }
        }
    }

    private static final class StreamWriteCipherGenerator
    implements WriteCipherGenerator {
        private StreamWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new StreamWriteCipher(authenticator, protocolVersion, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class StreamWriteCipher
        extends SSLWriteCipher {
            private final Cipher cipher;

            StreamWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.cipher.init(1, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.addMac(mAC, byteBuffer, by);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.finest("Padded plaintext before ENCRYPTION", byteBuffer.duplicate());
                }
                int n = byteBuffer.remaining();
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    if (n != this.cipher.update(byteBuffer2, byteBuffer)) {
                        throw new RuntimeException("Unexpected number of plaintext bytes");
                    }
                    if (byteBuffer.position() != byteBuffer2.position()) {
                        throw new RuntimeException("Unexpected ByteBuffer position");
                    }
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                return n;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return 0;
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n - n2 - n3;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n + n2 + n3;
            }
        }
    }

    private static final class T10BlockReadCipherGenerator
    implements ReadCipherGenerator {
        private T10BlockReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new BlockReadCipher(authenticator, protocolVersion, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class BlockReadCipher
        extends SSLReadCipher {
            private final Cipher cipher;

            BlockReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.cipher.init(2, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                BadPaddingException badPaddingException;
                block14: {
                    int n;
                    int n2;
                    Authenticator.MAC mAC;
                    block13: {
                        badPaddingException = null;
                        mAC = (Authenticator.MAC)((Object)this.authenticator);
                        n2 = byteBuffer.remaining();
                        n = mAC.macAlg().size;
                        if (n != 0 && !this.sanityCheck(n, byteBuffer.remaining())) {
                            badPaddingException = new BadPaddingException("ciphertext sanity check failed");
                        }
                        int n3 = byteBuffer.remaining();
                        int n4 = byteBuffer.position();
                        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                        try {
                            if (n3 != this.cipher.update(byteBuffer2, byteBuffer)) {
                                throw new RuntimeException("Unexpected number of plaintext bytes");
                            }
                            if (byteBuffer.position() != byteBuffer2.position()) {
                                throw new RuntimeException("Unexpected ByteBuffer position");
                            }
                        }
                        catch (ShortBufferException shortBufferException) {
                            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                        }
                        if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                            SSLLogger.fine("Padded plaintext after DECRYPTION", byteBuffer.duplicate().position(n4));
                        }
                        int n5 = this.cipher.getBlockSize();
                        byteBuffer.position(n4);
                        try {
                            SSLCipher.removePadding(byteBuffer, n, n5, this.protocolVersion);
                        }
                        catch (BadPaddingException badPaddingException2) {
                            if (badPaddingException != null) break block13;
                            badPaddingException = badPaddingException2;
                        }
                    }
                    try {
                        if (n != 0) {
                            SSLCipher.checkCBCMac(mAC, byteBuffer, by, n2, byArray);
                        } else {
                            this.authenticator.increaseSequenceNumber();
                        }
                    }
                    catch (BadPaddingException badPaddingException3) {
                        if (badPaddingException != null) break block14;
                        badPaddingException = badPaddingException3;
                    }
                }
                if (badPaddingException != null) {
                    throw badPaddingException;
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                return n - n2 - n3 - 1;
            }

            private boolean sanityCheck(int n, int n2) {
                int n3 = this.cipher.getBlockSize();
                if (n2 % n3 == 0) {
                    int n4 = n + 1;
                    n4 = n4 >= n3 ? n4 : n3;
                    return n2 >= n4;
                }
                return false;
            }
        }
    }

    private static final class T10BlockWriteCipherGenerator
    implements WriteCipherGenerator {
        private T10BlockWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new BlockWriteCipher(authenticator, protocolVersion, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class BlockWriteCipher
        extends SSLWriteCipher {
            private final Cipher cipher;

            BlockWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.cipher.init(1, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                int n = byteBuffer.position();
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.addMac(mAC, byteBuffer, by);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                int n2 = this.cipher.getBlockSize();
                int n3 = SSLCipher.addPadding(byteBuffer, n2);
                byteBuffer.position(n);
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Padded plaintext before ENCRYPTION", byteBuffer.duplicate());
                }
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    if (n3 != this.cipher.update(byteBuffer2, byteBuffer)) {
                        throw new RuntimeException("Unexpected number of plaintext bytes");
                    }
                    if (byteBuffer.position() != byteBuffer2.position()) {
                        throw new RuntimeException("Unexpected ByteBuffer position");
                    }
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                return n3;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return 0;
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int n4 = this.cipher.getBlockSize();
                int n5 = n - n2;
                n5 -= n5 % n4;
                --n5;
                return n5 -= n3;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int n4 = n + n3 + 1;
                int n5 = this.cipher.getBlockSize();
                if (n4 % n5 != 0) {
                    n4 += n5 - 1;
                    n4 -= n4 % n5;
                }
                return n2 + n4;
            }

            @Override
            boolean isCBCMode() {
                return true;
            }
        }
    }

    private static final class T11BlockReadCipherGenerator
    implements ReadCipherGenerator {
        private T11BlockReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new BlockReadCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class BlockReadCipher
        extends SSLReadCipher {
            private final Cipher cipher;

            BlockReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                if (algorithmParameterSpec == null) {
                    algorithmParameterSpec = new IvParameterSpec(new byte[sSLCipher.ivSize]);
                }
                this.cipher.init(2, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                BadPaddingException badPaddingException;
                block14: {
                    int n;
                    int n2;
                    Authenticator.MAC mAC;
                    block13: {
                        badPaddingException = null;
                        mAC = (Authenticator.MAC)((Object)this.authenticator);
                        n2 = byteBuffer.remaining();
                        n = mAC.macAlg().size;
                        if (n != 0 && !this.sanityCheck(n, byteBuffer.remaining())) {
                            badPaddingException = new BadPaddingException("ciphertext sanity check failed");
                        }
                        int n3 = byteBuffer.remaining();
                        int n4 = byteBuffer.position();
                        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                        try {
                            if (n3 != this.cipher.update(byteBuffer2, byteBuffer)) {
                                throw new RuntimeException("Unexpected number of plaintext bytes");
                            }
                            if (byteBuffer.position() != byteBuffer2.position()) {
                                throw new RuntimeException("Unexpected ByteBuffer position");
                            }
                        }
                        catch (ShortBufferException shortBufferException) {
                            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                        }
                        if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                            SSLLogger.fine("Padded plaintext after DECRYPTION", byteBuffer.duplicate().position(n4));
                        }
                        byteBuffer.position(n4 + this.cipher.getBlockSize());
                        n4 = byteBuffer.position();
                        int n5 = this.cipher.getBlockSize();
                        byteBuffer.position(n4);
                        try {
                            SSLCipher.removePadding(byteBuffer, n, n5, this.protocolVersion);
                        }
                        catch (BadPaddingException badPaddingException2) {
                            if (badPaddingException != null) break block13;
                            badPaddingException = badPaddingException2;
                        }
                    }
                    try {
                        if (n != 0) {
                            SSLCipher.checkCBCMac(mAC, byteBuffer, by, n2, byArray);
                        } else {
                            this.authenticator.increaseSequenceNumber();
                        }
                    }
                    catch (BadPaddingException badPaddingException3) {
                        if (badPaddingException != null) break block14;
                        badPaddingException = badPaddingException3;
                    }
                }
                if (badPaddingException != null) {
                    throw badPaddingException;
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int n4 = this.cipher.getBlockSize();
                return n - n2 - n4 - n3 - 1;
            }

            private boolean sanityCheck(int n, int n2) {
                int n3 = this.cipher.getBlockSize();
                if (n2 % n3 == 0) {
                    int n4 = n + 1;
                    n4 = n4 >= n3 ? n4 : n3;
                    return n2 >= (n4 += n3);
                }
                return false;
            }
        }
    }

    private static final class T11BlockWriteCipherGenerator
    implements WriteCipherGenerator {
        private T11BlockWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new BlockWriteCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class BlockWriteCipher
        extends SSLWriteCipher {
            private final Cipher cipher;
            private final SecureRandom random;

            BlockWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.random = secureRandom;
                if (algorithmParameterSpec == null) {
                    algorithmParameterSpec = new IvParameterSpec(new byte[sSLCipher.ivSize]);
                }
                this.cipher.init(1, key, algorithmParameterSpec, secureRandom);
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                int n = byteBuffer.position();
                Authenticator.MAC mAC = (Authenticator.MAC)((Object)this.authenticator);
                if (mAC.macAlg().size != 0) {
                    SSLCipher.addMac(mAC, byteBuffer, by);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                byte[] byArray = new byte[this.cipher.getBlockSize()];
                this.random.nextBytes(byArray);
                byteBuffer.position(n -= byArray.length);
                byteBuffer.put(byArray);
                byteBuffer.position(n);
                int n2 = this.cipher.getBlockSize();
                int n3 = SSLCipher.addPadding(byteBuffer, n2);
                byteBuffer.position(n);
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Padded plaintext before ENCRYPTION", byteBuffer.duplicate());
                }
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    if (n3 != this.cipher.update(byteBuffer2, byteBuffer)) {
                        throw new RuntimeException("Unexpected number of plaintext bytes");
                    }
                    if (byteBuffer.position() != byteBuffer2.position()) {
                        throw new RuntimeException("Unexpected ByteBuffer position");
                    }
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                return n3;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return this.cipher.getBlockSize();
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int n4 = this.cipher.getBlockSize();
                int n5 = n - n2 - n4;
                n5 -= n5 % n4;
                --n5;
                return n5 -= n3;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                int n3 = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int n4 = n + n3 + 1;
                int n5 = this.cipher.getBlockSize();
                if (n4 % n5 != 0) {
                    n4 += n5 - 1;
                    n4 -= n4 % n5;
                }
                return n2 + n5 + n4;
            }

            @Override
            boolean isCBCMode() {
                return true;
            }
        }
    }

    private static final class T12GcmReadCipherGenerator
    implements ReadCipherGenerator {
        private T12GcmReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new GcmReadCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class GcmReadCipher
        extends SSLReadCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] fixedIv;
            private final int recordIvSize;
            private final SecureRandom random;

            GcmReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.tagSize = sSLCipher.tagSize;
                this.key = key;
                this.fixedIv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                this.recordIvSize = sSLCipher.ivSize - sSLCipher.fixedIvSize;
                this.random = secureRandom;
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                int n;
                if (byteBuffer.remaining() < this.recordIvSize + this.tagSize) {
                    throw new BadPaddingException("Insufficient buffer remaining for AEAD cipher fragment (" + byteBuffer.remaining() + "). Needs to be more than or equal to IV size (" + this.recordIvSize + ") + tag size (" + this.tagSize + ")");
                }
                byte[] byArray2 = Arrays.copyOf(this.fixedIv, this.fixedIv.length + this.recordIvSize);
                byteBuffer.get(byArray2, this.fixedIv.length, this.recordIvSize);
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray2);
                try {
                    this.cipher.init(2, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                byte[] byArray3 = this.authenticator.acquireAuthenticationBytes(by, byteBuffer.remaining() - this.tagSize, byArray);
                this.cipher.updateAAD(byArray3);
                int n2 = byteBuffer.position();
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    n = this.cipher.doFinal(byteBuffer2, byteBuffer);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new RuntimeException("Cipher error in AEAD mode \"" + illegalBlockSizeException.getMessage() + " \"in JCE provider " + this.cipher.getProvider().getName());
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                byteBuffer.position(n2);
                byteBuffer.limit(n2 + n);
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Plaintext after DECRYPTION", byteBuffer.duplicate());
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                return n - n2 - this.recordIvSize - this.tagSize;
            }
        }
    }

    private static final class T12GcmWriteCipherGenerator
    implements WriteCipherGenerator {
        private T12GcmWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new GcmWriteCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        private static final class GcmWriteCipher
        extends SSLWriteCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] fixedIv;
            private final int recordIvSize;
            private final SecureRandom random;

            GcmWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.tagSize = sSLCipher.tagSize;
                this.key = key;
                this.fixedIv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                this.recordIvSize = sSLCipher.ivSize - sSLCipher.fixedIvSize;
                this.random = secureRandom;
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                int n;
                ByteBuffer byteBuffer2;
                int n2;
                byte[] byArray = this.authenticator.sequenceNumber();
                byte[] byArray2 = Arrays.copyOf(this.fixedIv, this.fixedIv.length + byArray.length);
                System.arraycopy(byArray, 0, byArray2, this.fixedIv.length, byArray.length);
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray2);
                try {
                    this.cipher.init(1, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                byte[] byArray3 = this.authenticator.acquireAuthenticationBytes(by, byteBuffer.remaining(), null);
                this.cipher.updateAAD(byArray3);
                byteBuffer.position(byteBuffer.position() - byArray.length);
                byteBuffer.put(byArray);
                int n3 = byteBuffer.position();
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Plaintext before ENCRYPTION", byteBuffer.duplicate());
                }
                if ((n2 = this.cipher.getOutputSize((byteBuffer2 = byteBuffer.duplicate()).remaining())) > byteBuffer.remaining()) {
                    byteBuffer.limit(n3 + n2);
                }
                try {
                    n = this.cipher.doFinal(byteBuffer2, byteBuffer);
                }
                catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
                    throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), generalSecurityException);
                }
                if (n != n2) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
                return n + byArray.length;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return this.recordIvSize;
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                return n - n2 - this.recordIvSize - this.tagSize;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                return n + n2 + this.recordIvSize + this.tagSize;
            }
        }
    }

    private static final class T13GcmReadCipherGenerator
    implements ReadCipherGenerator {
        private T13GcmReadCipherGenerator() {
        }

        @Override
        public SSLReadCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new GcmReadCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        static final class GcmReadCipher
        extends SSLReadCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] iv;
            private final SecureRandom random;

            GcmReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.tagSize = sSLCipher.tagSize;
                this.key = key;
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                this.random = secureRandom;
                this.keyLimitCountdown = cipherLimits.getOrDefault(string.toUpperCase() + ":" + tag[0], 0L);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine("KeyLimit read side: algorithm = " + string.toUpperCase() + ":" + tag[0] + "\ncountdown value = " + this.keyLimitCountdown, new Object[0]);
                }
                if (this.keyLimitCountdown > 0L) {
                    this.keyLimitEnabled = true;
                }
            }

            @Override
            public Plaintext decrypt(byte by, ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
                int n;
                int n2;
                if (by == ContentType.CHANGE_CIPHER_SPEC.id) {
                    return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
                }
                if (byteBuffer.remaining() <= this.tagSize) {
                    throw new BadPaddingException("Insufficient buffer remaining for AEAD cipher fragment (" + byteBuffer.remaining() + "). Needs to be more than tag size (" + this.tagSize + ")");
                }
                byte[] byArray2 = byArray;
                if (byArray2 == null) {
                    byArray2 = this.authenticator.sequenceNumber();
                }
                byte[] byArray3 = (byte[])this.iv.clone();
                int n3 = byArray3.length - byArray2.length;
                for (int i = 0; i < byArray2.length; ++i) {
                    int n4 = n3 + i;
                    byArray3[n4] = (byte)(byArray3[n4] ^ byArray2[i]);
                }
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray3);
                try {
                    this.cipher.init(2, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                byte[] byArray4 = this.authenticator.acquireAuthenticationBytes(by, byteBuffer.remaining(), byArray2);
                this.cipher.updateAAD(byArray4);
                int n5 = byteBuffer.position();
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                try {
                    n2 = this.cipher.doFinal(byteBuffer2, byteBuffer);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new RuntimeException("Cipher error in AEAD mode \"" + illegalBlockSizeException.getMessage() + " \"in JCE provider " + this.cipher.getProvider().getName());
                }
                catch (ShortBufferException shortBufferException) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), shortBufferException);
                }
                byteBuffer.position(n5);
                byteBuffer.limit(n5 + n2);
                for (n = byteBuffer.limit() - 1; n > 0 && byteBuffer.get(n) == 0; --n) {
                }
                if (n < n5 + 1) {
                    throw new BadPaddingException("Incorrect inner plaintext: no content type");
                }
                by = byteBuffer.get(n);
                byteBuffer.limit(n);
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Plaintext after DECRYPTION", byteBuffer.duplicate());
                }
                if (this.keyLimitEnabled) {
                    this.keyLimitCountdown -= (long)n2;
                }
                return new Plaintext(by, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, byteBuffer.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int n, int n2) {
                return n - n2 - this.tagSize;
            }
        }
    }

    private static final class T13GcmWriteCipherGenerator
    implements WriteCipherGenerator {
        private T13GcmWriteCipherGenerator() {
        }

        @Override
        public SSLWriteCipher createCipher(SSLCipher sSLCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
            return new GcmWriteCipher(authenticator, protocolVersion, sSLCipher, string, key, algorithmParameterSpec, secureRandom);
        }

        private static final class GcmWriteCipher
        extends SSLWriteCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] iv;
            private final SecureRandom random;

            GcmWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sSLCipher, String string, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = JsseJce.getCipher(string);
                this.tagSize = sSLCipher.tagSize;
                this.key = key;
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                this.random = secureRandom;
                this.keyLimitCountdown = cipherLimits.getOrDefault(string.toUpperCase() + ":" + tag[0], 0L);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine("KeyLimit write side: algorithm = " + string.toUpperCase() + ":" + tag[0] + "\ncountdown value = " + this.keyLimitCountdown, new Object[0]);
                }
                if (this.keyLimitCountdown > 0L) {
                    this.keyLimitEnabled = true;
                }
            }

            @Override
            public int encrypt(byte by, ByteBuffer byteBuffer) {
                int n;
                byte[] byArray = this.authenticator.sequenceNumber();
                byte[] byArray2 = (byte[])this.iv.clone();
                int n2 = byArray2.length - byArray.length;
                for (int i = 0; i < byArray.length; ++i) {
                    int n3 = n2 + i;
                    byArray2[n3] = (byte)(byArray2[n3] ^ byArray[i]);
                }
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray2);
                try {
                    this.cipher.init(1, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                int n4 = this.cipher.getOutputSize(byteBuffer.remaining());
                byte[] byArray3 = this.authenticator.acquireAuthenticationBytes(by, n4, byArray);
                this.cipher.updateAAD(byArray3);
                int n5 = byteBuffer.position();
                if (SSLLogger.isOn && SSLLogger.isOn("plaintext")) {
                    SSLLogger.fine("Plaintext before ENCRYPTION", byteBuffer.duplicate());
                }
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                if (n4 > byteBuffer.remaining()) {
                    byteBuffer.limit(n5 + n4);
                }
                try {
                    n = this.cipher.doFinal(byteBuffer2, byteBuffer);
                }
                catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
                    throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), generalSecurityException);
                }
                if (n != n4) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
                if (this.keyLimitEnabled) {
                    this.keyLimitCountdown -= (long)n;
                }
                return n;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return 0;
            }

            @Override
            int calculateFragmentSize(int n, int n2) {
                return n - n2 - this.tagSize;
            }

            @Override
            int calculatePacketSize(int n, int n2) {
                return n + n2 + this.tagSize;
            }
        }
    }

    static interface WriteCipherGenerator {
        public SSLWriteCipher createCipher(SSLCipher var1, Authenticator var2, ProtocolVersion var3, String var4, Key var5, AlgorithmParameterSpec var6, SecureRandom var7) throws GeneralSecurityException;
    }
}

