/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import jdk.internal.event.EventHelper;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.jfr.events.TLSHandshakeEvent;
import oracle.jrockit.jfr.VMJFR;

@InstrumentationTarget(value="sun.security.ssl.Finished")
final class FinishedInstrumentor {
    private FinishedInstrumentor() {
    }

    @InstrumentationMethod
    static void recordEvent(int n, String string, int n2, String string2, String string3) {
        if (!VMJFR.tlsHandshakeToken.isEnabled()) {
            FinishedInstrumentor.recordEvent(n, string, n2, string2, string3);
            return;
        }
        TLSHandshakeEvent tLSHandshakeEvent = new TLSHandshakeEvent(VMJFR.tlsHandshakeToken);
        if (tLSHandshakeEvent.shouldWrite() || EventHelper.isLoggingSecurity()) {
            if (tLSHandshakeEvent.shouldWrite()) {
                tLSHandshakeEvent.peerHost = string;
                tLSHandshakeEvent.peerPort = n2;
                tLSHandshakeEvent.cipherSuite = string2;
                tLSHandshakeEvent.protocolVersion = string3;
                tLSHandshakeEvent.certificateId = n;
                tLSHandshakeEvent.commit();
            }
            if (EventHelper.isLoggingSecurity()) {
                EventHelper.logTLSHandshakeEvent(null, string, n2, string2, string3, n);
            }
        }
    }

    @InstrumentationMethod
    private static boolean shouldRecord() {
        if (!VMJFR.tlsHandshakeToken.isEnabled()) {
            return FinishedInstrumentor.shouldRecord();
        }
        return true;
    }
}

