/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.impl;

import com.sun.xml.internal.bind.WhiteSpaceProcessor;
import com.sun.xml.internal.bind.util.Which;
import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.annotation.ClassLocatable;
import com.sun.xml.internal.bind.v2.model.annotation.Locatable;
import com.sun.xml.internal.bind.v2.model.core.ErrorHandler;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.PropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.PropertyKind;
import com.sun.xml.internal.bind.v2.model.core.Ref;
import com.sun.xml.internal.bind.v2.model.core.RegistryInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.internal.bind.v2.model.impl.ArrayInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.BuiltinLeafInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ElementInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.EnumLeafInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.Messages;
import com.sun.xml.internal.bind.v2.model.impl.ModelBuilderI;
import com.sun.xml.internal.bind.v2.model.impl.RegistryInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.SecureLoader;
import com.sun.xml.internal.bind.v2.model.impl.TypeInfoSetImpl;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.internal.bind.v2.runtime.IllegalAnnotationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;

public class ModelBuilder<T, C, F, M>
implements ModelBuilderI<T, C, F, M> {
    private static final Logger logger;
    final TypeInfoSetImpl<T, C, F, M> typeInfoSet;
    public final AnnotationReader<T, C, F, M> reader;
    public final Navigator<T, C, F, M> nav;
    private final Map<QName, TypeInfo> typeNames = new HashMap<QName, TypeInfo>();
    public final String defaultNsUri;
    final Map<String, RegistryInfoImpl<T, C, F, M>> registries = new HashMap<String, RegistryInfoImpl<T, C, F, M>>();
    private final Map<C, C> subclassReplacements;
    private ErrorHandler errorHandler;
    private boolean hadError;
    public boolean hasSwaRef;
    private final ErrorHandler proxyErrorHandler = new ErrorHandler(){

        @Override
        public void error(IllegalAnnotationException illegalAnnotationException) {
            ModelBuilder.this.reportError(illegalAnnotationException);
        }
    };
    private boolean linked;

    public ModelBuilder(AnnotationReader<T, C, F, M> annotationReader, Navigator<T, C, F, M> navigator, Map<C, C> map, String string) {
        this.reader = annotationReader;
        this.nav = navigator;
        this.subclassReplacements = map;
        if (string == null) {
            string = "";
        }
        this.defaultNsUri = string;
        annotationReader.setErrorHandler(this.proxyErrorHandler);
        this.typeInfoSet = this.createTypeInfoSet();
    }

    protected TypeInfoSetImpl<T, C, F, M> createTypeInfoSet() {
        return new TypeInfoSetImpl<T, C, F, M>(this.nav, this.reader, BuiltinLeafInfoImpl.createLeaves(this.nav));
    }

    public NonElement<T, C> getClassInfo(C c, Locatable locatable) {
        return this.getClassInfo(c, false, locatable);
    }

    public NonElement<T, C> getClassInfo(C c, boolean bl, Locatable locatable) {
        Object object;
        assert (c != null);
        T[] TArray = this.typeInfoSet.getClassInfo(c);
        if (TArray != null) {
            return TArray;
        }
        if (this.nav.isEnum(c)) {
            object = this.createEnumLeafInfo(c, locatable);
            this.typeInfoSet.add((EnumLeafInfoImpl<T, C, F, M>)object);
            TArray = object;
            this.addTypeName((NonElement<T, C>)TArray);
        } else {
            boolean bl2 = this.subclassReplacements.containsKey(c);
            if (bl2 && !bl) {
                TArray = this.getClassInfo(this.subclassReplacements.get(c), locatable);
            } else if (this.reader.hasClassAnnotation(c, XmlTransient.class) || bl2) {
                TArray = this.getClassInfo(this.nav.getSuperClass(c), bl, new ClassLocatable<C>(locatable, c, this.nav));
            } else {
                T[] TArray2 = this.createClassInfo(c, locatable);
                this.typeInfoSet.add((ClassInfoImpl<T, C, F, M>)TArray2);
                for (PropertyInfo<T, C> propertyInfo : TArray2.getProperties()) {
                    Object object2;
                    if (propertyInfo.kind() == PropertyKind.REFERENCE) {
                        this.addToRegistry(c, (Locatable)((Object)propertyInfo));
                        object2 = this.getParametrizedTypes(propertyInfo);
                        if (object2 != null) {
                            for (Object object3 : object2) {
                                if (object3 == c) continue;
                                this.addToRegistry(object3, (Locatable)((Object)propertyInfo));
                            }
                        }
                    }
                    object2 = propertyInfo.ref().iterator();
                    while (object2.hasNext()) {
                        TypeInfo typeInfo = (TypeInfo)object2.next();
                    }
                }
                TArray2.getBaseClass();
                TArray = TArray2;
                this.addTypeName((NonElement<T, C>)TArray);
            }
        }
        object = this.reader.getClassAnnotation(XmlSeeAlso.class, c, locatable);
        if (object != null) {
            for (Object object2 : this.reader.getClassArrayValue((Annotation)object, "value")) {
                this.getTypeInfo(object2, (Locatable)object);
            }
        }
        return TArray;
    }

    private void addToRegistry(C c, Locatable locatable) {
        C c2;
        String string = this.nav.getPackageName(c);
        if (!this.registries.containsKey(string) && (c2 = this.nav.loadObjectFactory(c, string)) != null) {
            this.addRegistry(c2, locatable);
        }
    }

    private Class[] getParametrizedTypes(PropertyInfo propertyInfo) {
        try {
            ParameterizedType parameterizedType;
            Type type = ((RuntimePropertyInfo)propertyInfo).getIndividualType();
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == JAXBElement.class) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Class[] classArray = new Class[typeArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    classArray[i] = (Class)typeArray[i];
                }
                return classArray;
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error in ModelBuilder.getParametrizedTypes. " + exception.getMessage());
        }
        return null;
    }

    private void addTypeName(NonElement<T, C> nonElement) {
        QName qName = nonElement.getTypeName();
        if (qName == null) {
            return;
        }
        TypeInfo typeInfo = this.typeNames.put(qName, nonElement);
        if (typeInfo != null) {
            this.reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_TYPE_MAPPING.format(nonElement.getTypeName()), typeInfo, nonElement));
        }
    }

    public NonElement<T, C> getTypeInfo(T t, Locatable locatable) {
        NonElement<T, C> nonElement = this.typeInfoSet.getTypeInfo(t);
        if (nonElement != null) {
            return nonElement;
        }
        if (this.nav.isArray(t)) {
            ArrayInfoImpl<T, C, F, M> arrayInfoImpl = this.createArrayInfo(locatable, t);
            this.addTypeName(arrayInfoImpl);
            this.typeInfoSet.add(arrayInfoImpl);
            return arrayInfoImpl;
        }
        C c = this.nav.asDecl(t);
        assert (c != null) : t.toString() + " must be a leaf, but we failed to recognize it.";
        return this.getClassInfo(c, locatable);
    }

    public NonElement<T, C> getTypeInfo(Ref<T, C> ref) {
        assert (!ref.valueList);
        C c = this.nav.asDecl(ref.type);
        if (c != null && this.reader.getClassAnnotation(XmlRegistry.class, c, null) != null) {
            if (!this.registries.containsKey(this.nav.getPackageName(c))) {
                this.addRegistry(c, null);
            }
            return null;
        }
        return this.getTypeInfo(ref.type, null);
    }

    protected EnumLeafInfoImpl<T, C, F, M> createEnumLeafInfo(C c, Locatable locatable) {
        return new EnumLeafInfoImpl(this, locatable, c, this.nav.use(c));
    }

    protected ClassInfoImpl<T, C, F, M> createClassInfo(C c, Locatable locatable) {
        return new ClassInfoImpl(this, locatable, c);
    }

    protected ElementInfoImpl<T, C, F, M> createElementInfo(RegistryInfoImpl<T, C, F, M> registryInfoImpl, M m) throws IllegalAnnotationException {
        return new ElementInfoImpl<T, C, F, M>(this, registryInfoImpl, m);
    }

    protected ArrayInfoImpl<T, C, F, M> createArrayInfo(Locatable locatable, T t) {
        return new ArrayInfoImpl(this, locatable, t);
    }

    public RegistryInfo<T, C> addRegistry(C c, Locatable locatable) {
        return new RegistryInfoImpl(this, locatable, c);
    }

    public RegistryInfo<T, C> getRegistry(String string) {
        return this.registries.get(string);
    }

    public TypeInfoSet<T, C, F, M> link() {
        assert (!this.linked);
        this.linked = true;
        for (ElementInfoImpl<T, C, F, M> typeInfoImpl : this.typeInfoSet.getAllElements()) {
            typeInfoImpl.link();
        }
        for (ClassInfoImpl classInfoImpl : this.typeInfoSet.beans().values()) {
            classInfoImpl.link();
        }
        for (EnumLeafInfoImpl enumLeafInfoImpl : this.typeInfoSet.enums().values()) {
            enumLeafInfoImpl.link();
        }
        if (this.hadError) {
            return null;
        }
        return this.typeInfoSet;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final void reportError(IllegalAnnotationException illegalAnnotationException) {
        this.hadError = true;
        if (this.errorHandler != null) {
            this.errorHandler.error(illegalAnnotationException);
        }
    }

    public boolean isReplaced(C c) {
        return this.subclassReplacements.containsKey(c);
    }

    @Override
    public Navigator<T, C, F, M> getNavigator() {
        return this.nav;
    }

    @Override
    public AnnotationReader<T, C, F, M> getReader() {
        return this.reader;
    }

    static {
        try {
            XmlSchema xmlSchema = null;
            xmlSchema.location();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Messages messages = SecureLoader.getClassClassLoader(XmlSchema.class) == null ? Messages.INCOMPATIBLE_API_VERSION_MUSTANG : Messages.INCOMPATIBLE_API_VERSION;
            throw new LinkageError(messages.format(Which.which(XmlSchema.class), Which.which(ModelBuilder.class)));
        }
        try {
            WhiteSpaceProcessor.isWhiteSpace("xyz");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new LinkageError(Messages.RUNNING_WITH_1_0_RUNTIME.format(Which.which(WhiteSpaceProcessor.class), Which.which(ModelBuilder.class)));
        }
        logger = Logger.getLogger(ModelBuilder.class.getName());
    }
}

