/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public ArrayType(byte by, int n) {
        this(BasicType.getType(by), n);
    }

    public ArrayType(String string, int n) {
        this(ObjectType.getInstance(string), n);
    }

    public ArrayType(Type type, int n) {
        super((byte)13, "<dummy>");
        Object object;
        if (n < 1 || n > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n);
        }
        switch (type.getType()) {
            case 13: {
                object = (ArrayType)type;
                this.dimensions = n + ((ArrayType)object).dimensions;
                this.basic_type = ((ArrayType)object).basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n;
                this.basic_type = type;
            }
        }
        object = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            ((StringBuilder)object).append('[');
        }
        ((StringBuilder)object).append(this.basic_type.getSignature());
        super.setSignature(((StringBuilder)object).toString());
    }

    public Type getBasicType() {
        return this.basic_type;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int hashCode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.dimensions == this.dimensions && arrayType.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

