/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    private byte type;
    private int index = -1;
    private ConstantPool constant_pool;

    StackMapType(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readByte(), -1, constantPool);
        if (this.hasIndex()) {
            this.index = dataInput.readShort();
        }
        this.constant_pool = constantPool;
    }

    public StackMapType(byte by, int n, ConstantPool constantPool) {
        if (by < 0 || by > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + by);
        }
        this.type = by;
        this.index = n;
        this.constant_pool = constantPool;
    }

    public void setType(byte by) {
        if (by < 0 || by > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + by);
        }
        this.type = by;
    }

    public byte getType() {
        return this.type;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        if (this.hasIndex()) {
            dataOutputStream.writeShort(this.getIndex());
        }
    }

    public final boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constant_pool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    public final String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }

    public StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }
}

