/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimpleElementValue
extends ElementValue {
    private int index;

    public SimpleElementValue(int n, int n2, ConstantPool constantPool) {
        super(n, constantPool);
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getValueString() {
        if (super.getType() != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.getIndex(), (byte)1);
        return constantUtf8.getBytes();
    }

    public int getValueInt() {
        if (super.getType() != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return constantInteger.getBytes();
    }

    public byte getValueByte() {
        if (super.getType() != 66) {
            throw new RuntimeException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return (byte)constantInteger.getBytes();
    }

    public char getValueChar() {
        if (super.getType() != 67) {
            throw new RuntimeException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex(), (byte)3);
        return (char)constantInteger.getBytes();
    }

    public long getValueLong() {
        if (super.getType() != 74) {
            throw new RuntimeException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong constantLong = (ConstantLong)super.getConstantPool().getConstant(this.getIndex());
        return constantLong.getBytes();
    }

    public float getValueFloat() {
        if (super.getType() != 70) {
            throw new RuntimeException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat constantFloat = (ConstantFloat)super.getConstantPool().getConstant(this.getIndex());
        return constantFloat.getBytes();
    }

    public double getValueDouble() {
        if (super.getType() != 68) {
            throw new RuntimeException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble constantDouble = (ConstantDouble)super.getConstantPool().getConstant(this.getIndex());
        return constantDouble.getBytes();
    }

    public boolean getValueBoolean() {
        if (super.getType() != 90) {
            throw new RuntimeException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return constantInteger.getBytes() != 0;
    }

    public short getValueShort() {
        if (super.getType() != 83) {
            throw new RuntimeException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return (short)constantInteger.getBytes();
    }

    @Override
    public String toString() {
        return this.stringifyValue();
    }

    @Override
    public String stringifyValue() {
        ConstantPool constantPool = super.getConstantPool();
        int n = super.getType();
        switch (n) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)constantPool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)constantPool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)constantPool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)constantPool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)constantPool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)constantPool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)constantPool.getConstant(this.getIndex(), (byte)3);
                return String.valueOf((char)constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)constantPool.getConstant(this.getIndex(), (byte)3);
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(this.getIndex(), (byte)1);
                return constantUtf8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValue class does not know how to stringify type " + n);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n = super.getType();
        dataOutputStream.writeByte(n);
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.getIndex());
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValue doesnt know how to write out type " + n);
            }
        }
    }
}

