/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodType
extends Constant {
    private int descriptor_index;

    public ConstantMethodType(ConstantMethodType constantMethodType) {
        this(constantMethodType.getDescriptorIndex());
    }

    ConstantMethodType(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantMethodType(int n) {
        super((byte)16);
        this.descriptor_index = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantMethodType(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.descriptor_index);
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public void setDescriptorIndex(int n) {
        this.descriptor_index = n;
    }

    @Override
    public final String toString() {
        return super.toString() + "(descriptor_index = " + this.descriptor_index + ")";
    }
}

