/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Annotations
extends Attribute {
    private AnnotationEntry[] annotation_table;
    private final boolean isRuntimeVisible;

    Annotations(byte by, int n, int n2, DataInput dataInput, ConstantPool constantPool, boolean bl) throws IOException {
        this(by, n, n2, (AnnotationEntry[])null, constantPool, bl);
        int n3 = dataInput.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[n3];
        for (int i = 0; i < n3; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(dataInput, constantPool, bl);
        }
    }

    public Annotations(byte by, int n, int n2, AnnotationEntry[] annotationEntryArray, ConstantPool constantPool, boolean bl) {
        super(by, n, n2, constantPool);
        this.annotation_table = annotationEntryArray;
        this.isRuntimeVisible = bl;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotation(this);
    }

    public final void setAnnotationTable(AnnotationEntry[] annotationEntryArray) {
        this.annotation_table = annotationEntryArray;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final int getNumAnnotations() {
        if (this.annotation_table == null) {
            return 0;
        }
        return this.annotation_table.length;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(DataOutputStream dataOutputStream) throws IOException {
        if (this.annotation_table == null) {
            return;
        }
        dataOutputStream.writeShort(this.annotation_table.length);
        for (AnnotationEntry annotationEntry : this.annotation_table) {
            annotationEntry.dump(dataOutputStream);
        }
    }
}

