.\" Automatically generated by Pod::Man 2.22 (Pod::Simple 3.10)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "VILE-PERL-API 1"
.TH VILE-PERL-API 1 "2010-01-03" "perl v5.10.1" "User Contributed Perl Documentation"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
vile\-perl\-api       \-\- Vile/Perl interface reference
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
This document describes the interface by which by Perl scripts may
access the \fIvile\fR editor's internals when run from an editor in which
Perl has been embedded.
.PP
There are presently two packages which comprise this interface.  They
are:
.IP "Vile" 4
.IX Item "Vile"
Subroutines for accessing and controlling vile in general.
.IP "Vile::Buffer" 4
.IX Item "Vile::Buffer"
Subroutines and methods for accessing individual buffers.
.IP "Vile::Window" 4
.IX Item "Vile::Window"
Subroutines and methods for manipulating Vile's windows.
.SS "Calling Perl from Vile"
.IX Subsection "Calling Perl from Vile"
The perl interpreter may be invoked from \fIvile\fR using either
the \fIperl\fR or \fIperldo\fR commands.
.IP ":perl \s-1STMTS\s0" 4
.IX Item ":perl STMTS"
The \fIperl\fR command will cause perl to execute one or more
perl statements.  The user is usually prompted for the statments
to execute immediately after \*(L":perl \*(R" is entered.  The user is
expected to enter legal perl statements or expressions.  These
statements must all fit on one line.  (Vile's :\-line will scroll
horizontally though, so don't worry about running out of space.)
.Sp
The perl command may also appear in macros in vile's internal
macro language, in which case the perl statements to execute must
appear as a double quoted string to the perl command.  The user
is not prompted in this case.
.Sp
Regardless, prior to execution, the global variable,
\&\f(CW$Vile::\fR\f(CW\*(C`current_buffer\*(C'\fR is set to an object of type \f(CW\*(C`Vile::Buffer\*(C'\fR
which represents the current buffer.  The statements to be executed
may choose to act either directly or indirectly on the current
buffer via this variable or a suitable alias.
.Sp
Normally, the cursor's current position, also referred to as \fIdot\fR,
is left unchanged upon return from perl.  It can be propagated
back to a viewable window by explicitly setting via the
\&\f(CW\*(C`Vile::Buffer::\*(C'\fR\f(CW\*(C`dot\*(C'\fR method.
.Sp
For purposes of reading from the buffer, there is always a region
associated with the buffer object.  By default, this region is the
entire buffer.  (Which means that potentially, the entire buffer
may be acted upon.) This range may be restricted by the user in
the normal way through the use of a range specification which
precedes the perl command.   E.g,
.Sp
.Vb 1
\&    30,40perl @l = <$Vile::current_buffer>
.Ve
.Sp
will cause lines 30 thru 40 to be placed into the \f(CW@l\fR array.
.IP ":perldo \s-1STMTS\s0 <Enter> \s-1OPTIONS\s0" 4
.IX Item ":perldo STMTS <Enter> OPTIONS"
The \fIperldo\fR command is like the perl command, but it takes
various options making it possible to write \*(L"one liners\*(R" to
operate on the current buffer in much the same way that you might
write a one line perl command at the prompt of your favorite shell
to operate on a file.  The options even mimic those provided by
the perl interpreter, so if you are familiar with one, you'll be
familiar with the other.
.Sp
After entering the perldo command (preceded by an optional range
specification) on the :\-line, the user will be prompted for some
perl statements to execute.  These should usually be written to
operate on the \f(CW$_\fR variable and leave the result in \f(CW$_\fR.
.Sp
After pressing the \fBEnter\fR key, you'll be prompted for a set
of options.  The default options are \-lpi and will even be displayed
as such.  The \fB\-i\fR switch causes the buffer to be edited in place.
The \fB\-p\fR switch causes the user supplied statements to be placed
in a loop which fetches lines one by one place them in \f(CW$_\fR for each
iteration of the loop along with a trailing \f(CW\*(C`print\*(C'\fR which'll cause
whatever's left in \f(CW$_\fR to be put back into the buffer.  The \fB\-l\fR switch
causes an initial chomp to be done on each line after it is read.
It will also cause the output record separator to be set so that
when \f(CW$_\fR is written back to the buffer, it will end up on a line of
its own.
.Sp
For example, the command:
.Sp
.Vb 2
\&    :25,30perldo $_ = sprintf("%4d",$lnum++) . $_
\&                 \-lpi
.Ve
.Sp
will cause each line in between 20 and 30 inclusive to be prefixed
with a the number given by \f(CW$lnum\fR, which is also incremented for
each line processed.  You'll probably want to initialize \f(CW$lnum\fR to
some appropriate value via the \fIperl\fR command first, perhaps
like this:
.Sp
.Vb 1
\&    :perl $lnum = 142;
.Ve
.Sp
[I include this example, because this is something that I've
wanted to do from time to time, when citing snippets of code
which I want to discuss in an email message.]
.IP "perldo options" 4
.IX Item "perldo options"
.RS 4
.PD 0
.IP "\-n" 4
.IX Item "-n"
.PD
Enclose the perl statement(s) in a loop which iterates of the records
(usually lines) of the region.  Each record in the region will
be placed in \f(CW$_\fR.
.IP "\-p" 4
.IX Item "-p"
Like \fB\-n\fR, but do a print (of \f(CW$_\fR) at the end of the loop.
.IP "\-i" 4
.IX Item "-i"
Enable the \fIinplace_edit\fR flag for the buffer.  When used with
either \fB\-n\fR or \fB\-p\fR, this will cause the lines to be deleted from the
buffer as they are read.
.Sp
Unlike the corresponding perl command line switch, it is not possible
to specify a backup file.  If you don't like what happens, just hit
the '\fBu\fR' key to undo it.
.IP "\-l" 4
.IX Item "-l"
Only meaningful when used with either \fB\-n\fR or \fB\-p\fR.  This will
perform an initial chomp on \f(CW$_\fR after a record has been read.
.IP "\-0" 4
.IX Item "-0"
This must be followed by one or more digits which represent the
value with which to set $/ (which is the input record separator).
The special value \fB00\fR indicates that $/ should be set to the
empty string which will cause Perl to slurp input in paragraph
mode.  The special value 0777 indicates that perl should slurp
the entire region without paying attention to record separators.
Normally, $/ is set to '\en' which corresponds to \-012
.IP "\-a" 4
.IX Item "-a"
Turn on autosplit mode.  Upon being read, each record is split
into the \f(CW@F\fR array.
.IP "\-F" 4
.IX Item "-F"
When used with \fB\-a\fR, specify an alternate pattern to split on.
.RE
.RS 4
.Sp
The default region for the perldo command is the line on which
the cursor is currently on.  The reason for this is that it is
often used like vile's builtin substitute operator is and this
is the default region for the substitute command.  You can of
course use any of the standard means to operate over larger
regions, e.g,
.Sp
.Vb 1
\&    :1,$perldo s/a/b/g
.Ve
.RE
.SS "Loading Perl Modules from Vile"
.IX Subsection "Loading Perl Modules from Vile"
A perl module that is usable by vile should probably be
located some place on the \f(CW@INC\fR path.  For vile, the \f(CW@INC\fR
array has been augmented to include \f(CW$HOME\fR/.vile/perl and
/usr/local/share/vile.  (This latter path may differ depending
upon your machine and configuration options.)  If you want to
see what exactly what these paths are, just issue the following
command from within vile:
.PP
.Vb 1
\&    :perl print join \*(Aq:\*(Aq, @INC[0,1]
.Ve
.PP
Let us suppose that the following script is stored in
\&\f(CW$HOME\fR/.vile/perl/number_lines.pl.
.PP
.Vb 2
\&    sub number_lines {
\&        my ($lnum, $width) = @_;
\&
\&        $lnum = 1 unless defined($lnum);
\&        $width = 4 unless defined($width);
\&
\&        $Vile::current_buffer\->inplace_edit(1);
\&
\&        while (<$Vile::current_buffer>) {
\&            print $Vile::current_buffer
\&                  \*(Aq \*(Aq x ($width \- length($lnum) \- 1),
\&                  $lnum, \*(Aq \*(Aq, $_;
\&            $lnum++;
\&        }
\&    }
\&
\&    1;
.Ve
.PP
Note the trailing \*(L"1;\*(R" at the end.  The reason for this is so
that \fItrue\fR is returned as the result of the script.  If things
are not done this way, the loading mechansim might flag an
error.  (All it needs to do is return a true value somehow.)
.PP
Assuming the above code has been placed in the file
\&'number_lines.pl', the following vile command may be used
to load it:
.PP
.Vb 1
\&        :perl require \*(Aqnumber_lines.pl\*(Aq
.Ve
.PP
When writing a new script, I will often test it in the same
editor session that I've created the script in.  My script
may have a bug in it and I'll fix it.  In order to reload
the script, you can do the following:
.PP
.Vb 1
\&        :perl do \*(Aqnumber_lines.pl\*(Aq
.Ve
.PP
Perl's builtin 'require' function wouldn't have worked to
reload the file because it keeps track of files that have
been loaded via this facility and refuses to load a file
twice.  The 'do' function on the other hand is a more general
facility for executing the contents of a file and doesn't
care how often it's called.
.PP
Caveat: Sometimes it's better to start with a clean slate,
particularly if you've renamed your subroutines or if there
are global variables involved.  Just start a fresh copy of
vile and start over.
.PP
Now to invoke our number_lines program, we do it as follows:
.PP
.Vb 1
\&        :perl number_lines(1)
.Ve
.PP
It is also possible to use vile's builtin macro language to
load perl modules and call them.  The hgrep.pl module comes
with the \fIvile\fR distribution.  You may want to put the following
line in your \fI.vilerc\fR file:
.PP
perl \*(L"use hgrep\*(R"
.PP
See also the Vile::\f(CW\*(C`register\*(C'\fR functions.
.SS "Package Vile"
.IX Subsection "Package Vile"
The \fBVile\fR package contains subroutines and methods of a
general nature.  They range from providing an interface to
\&\fIvile's\fR modes to providing facilities for obtaining user input.
.SS "Package Vile Subroutines and Methods"
.IX Subsection "Package Vile Subroutines and Methods"
.IP "Warn" 4
.IX Item "Warn"
Print a warning message
.IP "beep" 4
.IX Item "beep"
Rings terminal bell (or equivalent).
.IP "buffers" 4
.IX Item "buffers"
Returns a list of the editor's buffers.
.IP "command \s-1CMDLINE\s0" 4
.IX Item "command CMDLINE"
executes the given vile command line (as if it were typed on the :
line).
.Sp
This is not exactly safe in all contexts.  (It is easy to cause
seg faults.) If you need access to some portion of vile that would
lead you to want to use this subroutine, let me know and I will
work on suitable facilities.
.IP "keystroke" 4
.IX Item "keystroke"
.PD 0
.IP "keystroke \s-1WAITVAL\s0" 4
.IX Item "keystroke WAITVAL"
.PD
Returns a single, fairly raw keystroke from the keyboard.
.Sp
The optional \s-1WAITVAL\s0 indicates if the editor should wait for the
next keystroke.  When \s-1WAITVAL\s0 is false, undef will
be returned if no input is ready.
.IP "mlreply \s-1PROMPT\s0" 4
.IX Item "mlreply PROMPT"
.PD 0
.IP "mlreply \s-1PROMPT\s0, \s-1INITIALVALUE\s0" 4
.IX Item "mlreply PROMPT, INITIALVALUE"
.PD
Prompts the user with the given prompt and (optional) supplied
initial value.  Certain characters that the user may input have
special meanings to mlreply and may have to be escaped by the
user to be input.  If this is unacceptable, use mlreply_no_opts
instead.
.Sp
Returns the user's response string.  If the user aborts
(via the use of the escape key) the query, an undef is
returned.
.IP "mlreply_no_opts \s-1PROMPT\s0" 4
.IX Item "mlreply_no_opts PROMPT"
.PD 0
.IP "mlreply_no_opts \s-1PROMPT\s0, \s-1INITIALVALUE\s0" 4
.IX Item "mlreply_no_opts PROMPT, INITIALVALUE"
.PD
Prompts the user with the given prompt and (optional) supplied
initial value.  All printable characters may be entered by the
user without any special escapes.
.Sp
Returns the user's response string.  If the user aborts
(via the use of the escape key) the query, an undef is
returned.
.IP "mlreply_shell \s-1PROMPT\s0" 4
.IX Item "mlreply_shell PROMPT"
.PD 0
.IP "mlreply_shell \s-1PROMPT\s0, \s-1INITIALVALUE\s0" 4
.IX Item "mlreply_shell PROMPT, INITIALVALUE"
.PD
Like mlreply, but provide completions suitable for fetching shell
commands.
.IP "mlreply_dir \s-1PROMPT\s0" 4
.IX Item "mlreply_dir PROMPT"
.PD 0
.IP "mlreply_dir \s-1PROMPT\s0, \s-1INITIALVALUE\s0" 4
.IX Item "mlreply_dir PROMPT, INITIALVALUE"
.PD
Prompts the user for a directory name with the given prompt
and (optional) initial value.  Filename completion (via the
\&\s-1TAB\s0 key, if enabled) may be used to assist in entering
the directory name.
.Sp
Returns the user's response string.  If the user aborts
(via the use of the escape key) the query, an undef is
returned.
.IP "mlreply_file \s-1PROMPT\s0" 4
.IX Item "mlreply_file PROMPT"
.PD 0
.IP "mlreply_file \s-1PROMPT\s0, \s-1INITIALVALUE\s0" 4
.IX Item "mlreply_file PROMPT, INITIALVALUE"
.PD
Prompts the user for a filename with the given prompt and
(optional) initial value.  Filename completion (via the
\&\s-1TAB\s0 key, if enabled) may be used to assist in entering
the filename.
.Sp
Returns the user's response string.  If the user aborts
(via the use of the escape key) the query, an undef is
returned.
.IP "selection_buffer" 4
.IX Item "selection_buffer"
.PD 0
.IP "selection_buffer \s-1BUFOBJ\s0" 4
.IX Item "selection_buffer BUFOBJ"
.IP "Vile::Buffer::set_selection \s-1BUFOBJ\s0" 4
.IX Item "Vile::Buffer::set_selection BUFOBJ"
.PD
Gets or sets the buffer associated with the current selection.
.Sp
When getting the selection, the buffer object that has the current
selection is returned and its region is set to be the same region
as is occupied by the selection.  If there is no current selection, undef
is returned.
.Sp
When setting the selection, a buffer object must be passed in.  The
editor's selection is set to the region associated with the buffer object.
If successful, the buffer object is returned; otherwise undef will be
returned.
.Sp
Examples:
.Sp
\&\f(CW$sel\fR = Vile\->selection_buffer\->fetch;
                                    # Put the current selection in \f(CW$sel\fR
.Sp
.Vb 3
\&    Vile\->selection_buffer($Vile::current_buffer);
\&                                    # Set the selection to the region
\&                                    # contained in the current buffer
.Ve
.Sp
Vile::Buffer::set_selection is an alias for Vile::selection_buffer, but
can only function as a setter.  It may be used like this:
.Sp
.Vb 4
\&    Vile\->current_buffer\->set_region(\*(Aqw\*(Aq)\->set_selection;
\&                                    # set the selection to be the word
\&                                    # starting at the current position
\&                                    # in the current buffer
\&
\&    Vile\->current_buffer\->motion(\*(Aq?\e/\e*\*(Aq . "\en")
\&                        \->set_region(\*(Aq%\*(Aq)
\&                        \->set_selection();
\&                                    # set the selection to be the nearest
\&                                    # C\-style comment above or at the
\&                                    # current position.
.Ve
.IP "set \s-1PAIRLIST\s0" 4
.IX Item "set PAIRLIST"
.PD 0
.IP "get \s-1LIST\s0" 4
.IX Item "get LIST"
.IP "Vile::Buffer::set \s-1BUFOBJ\s0 \s-1PAIRLIST\s0" 4
.IX Item "Vile::Buffer::set BUFOBJ PAIRLIST"
.IP "Vile::Buffer::get \s-1BUFOBJ\s0 \s-1LIST\s0" 4
.IX Item "Vile::Buffer::get BUFOBJ LIST"
.PD
Provides access to Vile's various modes, buffer and otherwise.
.Sp
For the set methods, \s-1PAIRLIST\s0 should be a list of key => value
pairs, where key is a mode name and value is an appropriate value
for that mode.  When used in an array context, the resulting key =>
value pairs are returned.  (The value may be a different, but
equivalent string than originally specified.) When used in a scalar
context, either the package name or buffer object is returned
(depending on how it was invoked) in order that the result may be
used as the target of further method calls.
.Sp
When one of the get forms is used, a list of modes should be
supplied.  When used in an array context, a list of key => value
pairs is returned.  When used in a scalar context, only one mode
name may be supplied and the value associated with this mode is
returned.
.Sp
The methods in Vile::Buffer attempt to get the local modes
associated with the buffer (falling back to the global ones if no
specific local mode has been specified up to this point).
.Sp
Note:  Access to certain internal attributes such as the buffer
name and file name are not provided via this mechanism yet.  There
is no good reason for this other than that vile does not provide
access to these attributes via its set command.
.IP "update" 4
.IX Item "update"
Update the editor's display.  It is usually not necessary to
call this if you're returning to the editor in fairly short
order.  It will be necessary to call this, for example, if
you write an input loop in perl which writes things to some
on-screen buffers, but does not return to the editor immediately.
.IP "working" 4
.IX Item "working"
.PD 0
.IP "working \s-1VAL\s0" 4
.IX Item "working VAL"
.PD
Returns value 1 if working message will be printed during
substantial pauses, 0 if disabled.
.Sp
When passed an argument, modifies value of the working message.
.IP "register \s-1NAME\s0, [\s-1SUB\s0, \s-1HELP\s0, \s-1REQUIRE\s0]" 4
.IX Item "register NAME, [SUB, HELP, REQUIRE]"
Register a subroutine \s-1SUB\s0 as Vile function \s-1NAME\s0.  Once registered,
the subroutine may then be invoked as a named command and bound to
keystrokes.
.Sp
\&\s-1SUB\s0 may be given either as a string to eval, or a reference to a
subroutine.  If omitted, \s-1SUB\s0 defaults to \s-1NAME\s0.
.Sp
\&\s-1HELP\s0 provides a description of the subroutine for the [Binding
List] functions.
.Sp
An optional file to require may be given.
.Sp
Example:
.Sp
.Vb 1
\&    Vile::register grep => \*(Aqhgrep\*(Aq, \*(Aqrecursive grep\*(Aq, \*(Aqhgrep.pl\*(Aq;
.Ve
.Sp
or
.Sp
.Vb 2
\&    require \*(Aqhgrep.pl\*(Aq;
\&    Vile::register grep => \e&hgrep, \*(Aqrecursive grep\*(Aq;
.Ve
.Sp
also
.Sp
.Vb 4
\&    sub foo { print "foo" }
\&    Vile::register \*(Aqfoo\*(Aq;
\&    Vile::register bar => \*(Aqprint "bar"\*(Aq;
\&    Vile::register quux => sub { print "quux" };
.Ve
.IP "register_motion \s-1NAME\s0, [\s-1SUB\s0, \s-1HELP\s0, \s-1REQUIRE\s0]" 4
.IX Item "register_motion NAME, [SUB, HELP, REQUIRE]"
.PD 0
.IP "register_oper \s-1NAME\s0, [\s-1SUB\s0, \s-1HELP\s0, \s-1REQUIRE\s0]" 4
.IX Item "register_oper NAME, [SUB, HELP, REQUIRE]"
.PD
These synonyms for Vile::\f(CW\*(C`register\*(C'\fR allow perl subroutines to
behave as motions and operators.  For example, these subroutines
behave like their builtin counterparts:
.Sp
.Vb 4
\&    *cb = \e$Vile::current_buffer;
\&    Vile::register_motion \*(Aqmy\-forward\-line\-at\-bol\*(Aq => sub {
\&        $cb\->dot((scalar $cb\->dot) + 1, 0);
\&    };
\&
\&    Vile::register_oper \*(Aqmy\-delete\-til\*(Aq => sub { $cb\->delete };
.Ve
.IP "watchfd \s-1FD\s0, \s-1WATCHTYPE\s0, \s-1CALLBACK\s0" 4
.IX Item "watchfd FD, WATCHTYPE, CALLBACK"
Adds a callback so that when the file descriptor \s-1FD\s0 is available
for a particular type of I/O activity (specified by \s-1WATCHTYPE\s0),
the callback associated with \s-1CALLBACK\s0 is called.
.Sp
\&\s-1WATCHTYPE\s0 must be one of 'read', 'write', or 'except' and have
the obvious meanings.
.Sp
The callback should either be a string representing a vile
command to execute (good luck) or (more usefully) a Perl subroutine
reference.
.IP "unwatchfd \s-1FD\s0" 4
.IX Item "unwatchfd FD"
Removes the callback associated with \s-1FD\s0 and frees up the
associated data structures.
.SS "Package Vile::Buffer"
.IX Subsection "Package Vile::Buffer"
The Vile::Buffer package contains methods for creating new buffers
and for accessing already existing buffers in various ways.
.PP
A Vile::Buffer object may be viewed as a filehandle.  Therefore,
the usual sorts of methods for reading from and writing to
filehandles will work as expected.
.PP
Example:
.PP
A word count program that you might invoke from your favorite
shell could be written as follows:
.PP
.Vb 1
\&    #!/usr/local/bin/perl \-w
\&
\&    my $words;
\&    while (<>) {
\&        $words += split;
\&    }
\&    print "$words words\en";
.Ve
.PP
A programmer accustomed to the above, will find Vile's perl
interface to be a comfortable one.  Here is the above script
modified slightly to count the words in the current buffer:
.PP
.Vb 7
\&    sub wc {
\&        my $words;
\&        while (<$Vile::current_buffer>) {
\&            $words+=split;
\&        }
\&        print "$words words";
\&    }
.Ve
.SS "Package Vile::Buffer Methods"
.IX Subsection "Package Vile::Buffer Methods"
.IP "<\s-1BUFOBJ\s0>" 4
.IX Item "<BUFOBJ>"
When used in a scalar context, returns the next line or portion of
thereof in the current region.
.Sp
When used in an array context, returns the rest of the lines (or
portions thereof) in the current region.
.Sp
The current region is either set with set_region or set by default
for you when perl is invoked from vile.  This region will either
be the region that the user specified or the whole buffer if not
user specified.  Unless you know for sure that the region is set
properly, it is probably best to set it explicitly.
.Sp
After a line is read, \s-1DOT\s0 is left at the next location in the
buffer at which to start reading.  Note, however, that the value
of \s-1DOT\s0 (which a convenient name for the current position in the
buffer) is not propogated back to any of the users windows unless
it has been explicitly set by calling dot (the method).
.Sp
When the \fIinplace_edit\fR flag has been set via the \f(CW\*(C`inplace_edit\*(C'\fR
method, text that is retrieved from the buffer is deleted
immediately after retrieval.
.Sp
Examples:
.Sp
.Vb 2
\&    # Example 1: Put all lines of the current buffer into
\&    #            an array
\&
\&    $Vile::current_buffer\->set_region(1,\*(Aq$$\*(Aq);
\&                                    # Set the region to be the
\&                                    # entire buffer.
\&    my @lines = <$Vile::current_buffer>;
\&                                    # Fetch all lines and put them
\&                                    # in the @lines array.
\&    print $lines[$#lines/2] if @lines;
\&                                    # Print the middle line to
\&                                    # the status line
\&
\&
\&    # Example 2: Selectively delete lines from a buffer
\&
\&    my $curbuf = $Vile::current_buffer;
\&                                    # get an easier to type handle
\&                                    # for the current buffer
\&    $curbuf\->inplace_edit(1);       # set the inplace_edit flag
\&                                    # so that lines will be deleted
\&                                    # as they are read
\&
\&    while (<$curbuf>) {             # fetch line into $_
\&        unless (/MUST\es+DELETE/) {  # see if we should keep the line
\&            print $curbuf $_;       # put it back if we should keep it
\&        }
\&    }
.Ve
.IP "attribute \s-1BUFOBJ\s0 \s-1LIST\s0" 4
.IX Item "attribute BUFOBJ LIST"
Attach an attributed region to the region associated with \s-1BUFOBJ\s0
with the attributes found in \s-1LIST\s0.
.Sp
These attributes may be any of the following:
.Sp
.Vb 11
\&    \*(Aqcolor\*(Aq => NUM          (where NUM is the color number
\&                             from 0 to 15)
\&    \*(Aqunderline\*(Aq
\&    \*(Aqbold\*(Aq
\&    \*(Aqreverse\*(Aq
\&    \*(Aqitalic\*(Aq
\&    \*(Aqhyper\*(Aq => HYPERCMD     (where HYPERCMD is a string
\&                            representing a vile command to
\&                            execute.  It may also be a
\&                            (perl) subroutine reference.
\&    \*(Aqnormal\*(Aq
.Ve
.Sp
Normal is a special case.  It will override any other arguments
passed in and remove all attributes associated with the region.
.IP "attribute_cntl_a_sequences \s-1BUFOBJ\s0" 4
.IX Item "attribute_cntl_a_sequences BUFOBJ"
Causes the editor to attach attributes to the <Ctrl>A
sequences found in the buffer for the current region (which
may be set via set_region).
.Sp
Returns the buffer object.
.IP "buffername \s-1BUFOBJ\s0" 4
.IX Item "buffername BUFOBJ"
Returns the buffer name associated with \s-1BUFOBJ\s0.
.IP "buffername \s-1BUFOBJ\s0 \s-1BUFNAME\s0" 4
.IX Item "buffername BUFOBJ BUFNAME"
Sets the buffer name associated with \s-1BUFOBJ\s0 to the string
given by \s-1BUFNAME\s0.  This string must be unique.  If the name
given is already being used by another buffer, or if it's
malformed in some way, undef will be returned.  Otherwise
the name of the buffer will be returned.
.Sp
Note: The name of the buffer returned may be different than
that passed in due some adjustments that may be done on the
buffer name.  (It will be trimmed of spaces and a length limit
is imposed.)
.IP "filename \s-1BUFOBJ\s0" 4
.IX Item "filename BUFOBJ"
Returns the file name associated with \s-1BUFOBJ\s0.
.IP "filename \s-1BUFOBJ\s0 \s-1FILENAME\s0" 4
.IX Item "filename BUFOBJ FILENAME"
Sets the name of the file associated with \s-1BUFOBJ\s0 to the string
given by \s-1FILENAME\s0.
.IP "command \s-1BUFOBJ\s0 \s-1CMDLINE\s0" 4
.IX Item "command BUFOBJ CMDLINE"
Executes the given vile command line (as if it were typed
on the : line) with \s-1BUFOBJ\s0 as the current buffer.
.Sp
Returns \s-1BUFOBJ\s0 if successful, otherwise returns undef.
.IP "current_buffer" 4
.IX Item "current_buffer"
.PD 0
.IP "current_buffer \s-1BUFOBJ\s0" 4
.IX Item "current_buffer BUFOBJ"
.IP "current_buffer \s-1PKGNAME\s0" 4
.IX Item "current_buffer PKGNAME"
.IP "current_buffer \s-1BUFOBJ\s0   \s-1NEWBUFOBJ\s0" 4
.IX Item "current_buffer BUFOBJ   NEWBUFOBJ"
.IP "current_buffer \s-1PKGNAME\s0  \s-1NEWBUFOBJ\s0" 4
.IX Item "current_buffer PKGNAME  NEWBUFOBJ"
.PD
Returns the current buffer.  When first entering perl from a vile
session, the current buffer is the one that the user is actively
editing.  Several buffers may be on the screen at once, but only one
of them is current.  The current one will be the one in which the
cursor appears.
.Sp
This method may also be used to set the current buffer.  When used in
the form
.Sp
.Vb 1
\&    $oldbuf\->current_buffer($newbuf)
.Ve
.Sp
then \f(CW$newbuf\fR will replace \f(CW$oldbuf\fR in one of the visible windows.
(This only makes sense when \f(CW$oldbuf\fR was visible in some window on the
screen.  If it wasn't visible, it'll just replace whatever buffer was
last both current and visible.)
.Sp
When used as a setter, the current buffer is still returned.  In this
case it will be the new buffer object which becomes the current
buffer.
.Sp
Note also that the current_buffer method is in both the Vile package
and the Vile::Buffer package.  I couldn't decide which package it should
be in so I put it into both.  It seemed like a real hassle to have to
say
.Sp
.Vb 1
\&    my $curbuf = Vile::Buffer\->current_buffer
.Ve
.Sp
So instead, you can just say
.Sp
.Vb 1
\&    my $curbuf = Vile\->current_buffer;
.Ve
.Sp
current_buffer is also a variable, so you can also do it this way:
.Sp
.Vb 1
\&    my $curbuf = $Vile::current_buffer;
.Ve
.Sp
If you want \f(CW$main::curbuf\fR (or some other variable) to be an alias to
the current buffer, you can do it like this:
.Sp
.Vb 1
\&    *main::curbuf = \e$Vile::current_buffer;
.Ve
.Sp
Put this in some bit of initialization code and then you'll never have
to call the current_buffer method at all.
.Sp
One more point, since \f(CW$Vile::current_buffer\fR is magical, the alias
above will be magical too, so you'll be able to do
.Sp
.Vb 1
\&    $curbuf = $newbuf;
.Ve
.Sp
in order to set the buffer.  (Yeah, this looks obvious, but realize
that doing the assignment actually causes some vile specific code to
run which will cause \f(CW$newbuf\fR to become the new current buffer upon
return.)
.IP "delete \s-1BUFOBJ\s0" 4
.IX Item "delete BUFOBJ"
Deletes the currently set region.
.Sp
Returns the buffer object if all went well, undef otherwise.
.IP "dot \s-1BUFOBJ\s0" 4
.IX Item "dot BUFOBJ"
.PD 0
.IP "dot \s-1BUFOBJ\s0 \s-1LINENUM\s0" 4
.IX Item "dot BUFOBJ LINENUM"
.IP "dot \s-1BUFOBJ\s0 \s-1LINENUM\s0, \s-1OFFSET\s0" 4
.IX Item "dot BUFOBJ LINENUM, OFFSET"
.PD
Returns the current value of dot (which represents the the current
position in the buffer).  When used in a scalar context, returns
the line number of dot.  When used in an array context, returns
the line number and position within the line.
.Sp
When supplied with one argument, the line number, dot is set to
the beginning of that line.  When supplied with two arguments,
both the line number and offset components are set.
.Sp
Either the line number or offset (or both) may be the special
string '$' which represents the last line in the buffer and the
last character on a line.
.Sp
Often times, however, the special string '$$' will be more useful.
It truly represents the farthest that it possible to go in both
the vertical and horizontal directions.  As a line number, this
represents the line beyond the last line of the buffer.
Characters inserted at this point will form a new line.  As an
offset, '$$' refers to the newline character at the end of a line.
Characters inserted at this point will be inserted before the
newline character.
.Sp
Examples:
.Sp
.Vb 2
\&    my $cb = $Vile::current_buffer; # Provide a convenient handle
\&                                    # for the current buffer.
\&
\&    $linenum = $cb\->dot;            # Fetch the line number at which dot
\&                                    # is located.
\&
\&    $cb\->dot($cb\->dot+1);           # Advance dot by one line
\&    $cb\->dot($cb\->dot(\*(Aq$\*(Aq) \- 1);
\&                                    # Set dot to the penultimate line of
\&                                    # the buffer.
\&
\&    $cb\->dot(25, 6);                # Set dot to line 25, character 6
\&
\&    ($ln,$off) = $cb\->dot;          # Fetch the current position
\&    $cb\->dot($ln+1,$off\-1);         # and advance one line, but
\&                                    # back one character.
\&
\&    $cb\->inplace_edit(1);
\&    $cb\->set_region(scalar($cb\->dot), $cb\->dot+5);
\&    @lines = <$cb>;
\&    $cb\->dot($cb\->dot \- 1);
\&    print $cb @lines;
\&                                    # The above block takes (at
\&                                    # most) six lines starting at
\&                                    # the line DOT is on and moves
\&                                    # them before the previous
\&                                    # line.
.Ve
.Sp
Note: current_position is an alias for dot.
.IP "dotq \s-1BUFOBJ\s0" 4
.IX Item "dotq BUFOBJ"
.PD 0
.IP "dotq \s-1BUFOBJ\s0 \s-1LINENUM\s0" 4
.IX Item "dotq BUFOBJ LINENUM"
.IP "dotq \s-1BUFOBJ\s0 \s-1LINENUM\s0, \s-1OFFSET\s0" 4
.IX Item "dotq BUFOBJ LINENUM, OFFSET"
.PD
Like \fBdot\fR except that it's \*(L"quiet\*(R" in its operation in the sense
that it doesn't attempt to propagate the \s-1API\s0's concept of where the
current position is back to the editor when control is returned.
.Sp
This could be useful in situations where you want your Perl script
to quietly add some text to a buffer without disturbing any of the
user's windows into that buffer.
.IP "fetch \s-1BUFOBJ\s0" 4
.IX Item "fetch BUFOBJ"
Returns the current region or remainder thereof.  The same effect
could be achieved by setting $/ to undef and then evaluating the
buffer object between angle brackets.
.Sp
Example:
.Sp
.Vb 2
\&    $word = $Vile::current_buffer\->set_region(\*(Aqw\*(Aq)\->fetch;
\&                            # Fetch the next word and put it in $word
.Ve
.IP "inplace_edit \s-1BUFOBJ\s0" 4
.IX Item "inplace_edit BUFOBJ"
.PD 0
.IP "inplace_edit \s-1BUFOBJ\s0 \s-1VALUE\s0" 4
.IX Item "inplace_edit BUFOBJ VALUE"
.PD
Sets the value of the \*(L"inplace edit\*(R" flag (either true of false).
Returns the old value.  When used without an argument, merely
returns current value without modifying the current value.
.Sp
This flag determines whether a line is deleted after being read.
E.g,
.Sp
.Vb 6
\&    my $curbuf = $Vile::current_buffer;
\&    $curbuf\->inplace_edit(1);
\&    while (<$curbuf>) {
\&        s/foo/bar/g;
\&        print;
\&    }
.Ve
.Sp
The <$curbuf> operation will cause one line to be read and
deleted.  \s-1DOT\s0 will be left at the beginning of the next line.  The
print statment will cause \f(CW$_\fR to get inserted prior the the next
line.
.Sp
Setting this flag to true is very similar to setting the
\&\f(CW$INPLACE_EDIT\fR flag (or $^I) for normal filehandles or using the \fB\-i\fR
switch from the command line.
.Sp
Setting it to false (which is its default value) will cause the
lines that are read to be left alone.
.IP "motion \s-1BUFOBJ\s0 \s-1MOTIONSTR\s0" 4
.IX Item "motion BUFOBJ MOTIONSTR"
Moves dot (the current position) by the given \s-1MOTIONSTR\s0 in
\&\s-1BUFOBJ\s0.
.Sp
When used in an array context, returns a 4\-tuple containing
the beginning and ending positions.  This 4\-tuple is suitable
for passing to \f(CW\*(C`set_region\*(C'\fR.
.Sp
When used in a scalar context, returns the buffer object that
it was called with.
.Sp
In either an array or scalar context, if the motion string was
bad, and undef is returned.  Motions that don't work are okay,
such as 'h' when you're already at the left edge of a line.  But
attempted \*(L"motions\*(R" like 'inewstring' will result in an error.
.Sp
Example:
.Sp
.Vb 3
\&    # The following code deletes the previous 2 words and then
\&    # positions the cursor at the next occurrence of the word
\&    # "foo".
\&
\&    my $cb = $Vile::current_buffer;
\&    $cb\->set_region($cb\->motion("2b"))\->delete;
\&                    # delete the previous two words
\&
\&    $cb\->set_region("2b")\->delete;
\&                    # another way to delete the previous
\&                    # two words
\&
\&    $cb\->motion("/foo/");
\&                    # position DOT at the beginning of
\&                    # "foo".
\&
\&    $cb\->dot($cb\->dot);
\&                    # Make sure DOT gets propogated back.
\&                    # (It won\*(Aqt get propogated unless
\&                    # explicitly set.)
.Ve
.IP "new \s-1BUFOBJ\s0" 4
.IX Item "new BUFOBJ"
.PD 0
.IP "new \s-1PKGNAME\s0" 4
.IX Item "new PKGNAME"
.IP "new \s-1BUFOBJ\s0  \s-1FILENAME\s0" 4
.IX Item "new BUFOBJ  FILENAME"
.IP "new \s-1PKGNAME\s0 \s-1FILENAME\s0" 4
.IX Item "new PKGNAME FILENAME"
.IP "edit \s-1BUFOBJ\s0" 4
.IX Item "edit BUFOBJ"
.IP "edit \s-1PKGNAME\s0" 4
.IX Item "edit PKGNAME"
.IP "edit \s-1BUFOBJ\s0  \s-1FILENAME\s0" 4
.IX Item "edit BUFOBJ  FILENAME"
.IP "edit \s-1PKGNAME\s0 \s-1FILENAME\s0" 4
.IX Item "edit PKGNAME FILENAME"
.PD
These methods create a new buffer and return it.
.Sp
When no filename is supplied, an anonymous buffer is created.
These buffer's will be named [unnamed\-1], [unnamed\-2], etc.  and
will not have a file name associated with them.
.Sp
When a name is supplied as an argument to new or edit, a check is
made to see if the name is the same as an already existing buffer.
If so, that buffer is returned.  Otherwise, the name is taken to
be a file name.  If the file exists, it is opened and read into
the newly created buffer.  If the file does not exist, a new
buffer will be created with the associated file name.  The name of
the buffer will be based on the file name.  The file will be
created when the buffer is first written out to disk.
.Sp
new and edit are synonyms.  In each case, \s-1PKGNAME\s0 is Vile::Buffer.
There is no difference between Vile::Buffer\->new($fname) and
\&\f(CW$buf\fR\->new($fname).  These two different forms are merely provided
for convenience.
.Sp
Example:
.Sp
.Vb 3
\&    $Vile::current_buffer = new Vile::Buffer \*(Aqmakefile\*(Aq;
\&                                    # open makefile and make it visible
\&                                    # on the screen.
\&
\&    $abuf = new Vile::Buffer;       # Create an anonymous buffer
\&    print $abuf "Hello";            # put something in it
\&    Vile\->current_buffer($abuf);    # make the anonymous buffer current
\&                                    #   (viewable).
\&
\&    Vile\->current_buffer($abuf\->edit(\*(Aqmakefile\*(Aq));
\&                                    # Now makefile is the current
\&                                    #   buffer
\&    $abuf\->current_buffer(Vile::Buffer\->new(\*(Aqmakefile\*(Aq));
\&                                    # Same thing
.Ve
.IP "print \s-1BUFOBJ\s0 \s-1STR1\s0,..,STRN" 4
.IX Item "print BUFOBJ STR1,..,STRN"
.PD 0
.IP "insert \s-1BUFOBJ\s0 \s-1STR1\s0,...,STRN" 4
.IX Item "insert BUFOBJ STR1,...,STRN"
.PD
Inserts one or more strings the buffer object at the current
position of \s-1DOT\s0.  \s-1DOT\s0 will be left at the end of the strings
just inserted.
.Sp
When \s-1STDERR\s0 or \s-1STDOUT\s0 are printed to, the output will be
directed to the message line.
.Sp
Examples:
.Sp
.Vb 5
\&    print "Hello, world!";          # Print a well known greeting on
\&                                    # the message line.
\&    print $Vile::current_buffer "new text";
\&                                    # put some new text in the current
\&                                    # buffer.
\&
\&    my $passbuf = new Vile::Buffer \*(Aq/etc/passwd\*(Aq;
\&                                    # Fetch the password file
\&    $passbuf\->dot(\*(Aq$$\*(Aq);            # Set the position at the end
\&    print $passbuf "joeuser::1000:100:Joe User:/home/joeuser:/bin/bash
\&                                    # Add \*(Aqjoeuser\*(Aq to the this buffer
\&    Vile\->current_buffer($passbuf); # Make it visible to the user.
.Ve
.IP "set_region \s-1BUFOBJ\s0" 4
.IX Item "set_region BUFOBJ"
.PD 0
.IP "set_region \s-1BUFOBJ\s0 \s-1MOTIONSTR\s0" 4
.IX Item "set_region BUFOBJ MOTIONSTR"
.IP "set_region \s-1BUFOBJ\s0 \s-1STARTLINE\s0, \s-1ENDLINE\s0" 4
.IX Item "set_region BUFOBJ STARTLINE, ENDLINE"
.IP "set_region \s-1BUFOBJ\s0 \s-1STARTLINE\s0, \s-1STARTOFFSET\s0, \s-1ENDLINE\s0, \s-1ENDOFFSET\s0" 4
.IX Item "set_region BUFOBJ STARTLINE, STARTOFFSET, ENDLINE, ENDOFFSET"
.IP "set_region \s-1BUFOBJ\s0 \s-1STARTLINE\s0, \s-1STARTOFFSET\s0, \s-1ENDLINE\s0, \s-1ENDOFFSET\s0, 'rectangle'" 4
.IX Item "set_region BUFOBJ STARTLINE, STARTOFFSET, ENDLINE, ENDOFFSET, 'rectangle'"
.IP "set_region \s-1BUFOBJ\s0 \s-1STARTLINE\s0, \s-1STARTOFFSET\s0, \s-1ENDLINE\s0, \s-1ENDOFFSET\s0, 'exact'" 4
.IX Item "set_region BUFOBJ STARTLINE, STARTOFFSET, ENDLINE, ENDOFFSET, 'exact'"
.PD
Sets the region upon which certain other methods will operate and
sets \s-1DOT\s0 to the beginning of the region.
.Sp
Either the line number or offset (or both) may be the special
string '$' which represents the last line in the buffer and the
last character on a line.
.Sp
Often times, however, the special string '$$' will be more useful.
It truly represents the farthest that it possible to go in both
the vertical and horizontal directions.  As a line number, this
represents the line beyond the last line of the buffer.
Characters inserted at this point will form a new line.  As an
offset, '$$' refers to the newline character at the end of a line.
Characters inserted at this point will be inserted before the
newline character.
.Sp
When used in an array context, returns a five element array with
the start line, start offset, end line, end offset, and a string
indicating the type of region (one of 'line', 'rectangle', or
\&'exact').
.Sp
When used in a scalar context, returns the buffer object so that
cascading method calls may be performed, i.e,
.Sp
.Vb 2
\&    $Vile::current_buffer\->set_region(3,4)
\&                         \->attribute_cntl_a_sequences;
.Ve
.Sp
There is a special form of set_region which may be used as follows:
.Sp
.Vb 1
\&    $Vile::current_buffer\->set_region(\*(Aqj2w\*(Aq);
.Ve
.Sp
The above statement will set the region beginning at the current
location of \s-1DOT\s0 and ending at the location arrived at by moving
down one line and over two words.  This may be viewed as a
shorthand way of expressing the following (somewhat cumbersome)
statement:
.Sp
.Vb 2
\&    $Vile::current_buffer\->set_region(
\&            $Vile::current_buffer\->motion(\*(Aqj2w\*(Aq));
.Ve
.Sp
Notes:
.IP "1" 4
.IX Item "1"
rectangular regions are not implemented yet.
.IP "2" 4
.IX Item "2"
setregion is an alias for set_region.
.IP "unmark" 4
.IX Item "unmark"
Clear the \*(L"modified\*(R" status of the buffer.
.Sp
Returns the buffer object.
.SS "Package Vile::Window"
.IX Subsection "Package Vile::Window"
The Vile::Window package contains methods for manipulating windows
in various ways.  For the purposes of this discussion, a window is
one of the areas of the screen in which a portion of a buffer may
be viewed by the user.
.PP
This \s-1API\s0 allows you to do the following things to one of these
windows:
.IP "\(bu" 4
Create new windows (by splitting an existing window)
.IP "\(bu" 4
Delete windows
.IP "\(bu" 4
Obtain the buffer (Vile::Buffer) object associated
with a given window
.IP "\(bu" 4
Change the buffer associated with a window
.IP "\(bu" 4
Obtain list of all windows
.IP "\(bu" 4
Obtain window characteristics (width, height)
.IP "\(bu" 4
Change window characteristics (height)
.IP "\(bu" 4
Get/Set \s-1DOT\s0 for buffer associated with the window
.IP "\(bu" 4
Get/Set top line
.PP
In the documentation below, \s-1WINOBJ\s0 refers to an object of
Vile::Window and \s-1BUFOBJ\s0 refers to an object of Vile::Buffer.
.SS "Package Vile::Window Methods"
.IX Subsection "Package Vile::Window Methods"
.IP "buffer \s-1WINOBJ\s0" 4
.IX Item "buffer WINOBJ"
Returns the buffer associated with \s-1WINOBJ\s0.
.Sp
E.g,
.Sp
.Vb 1
\&    $buf = Vile::current_window\->buffer
.Ve
.Sp
would get you the buffer associated with the current window.
.IP "buffer \s-1WINOBJ\s0 \s-1BUFOBJ\s0" 4
.IX Item "buffer WINOBJ BUFOBJ"
Sets the buffer associated with \s-1WINOBJ\s0 to \s-1BUFOBJ\s0.  Returns
\&\s-1BUFOBJ\s0.
.IP "current_window" 4
.IX Item "current_window"
Returns the Vile::Window object representing the current window.
.Sp
Note: This method is also in the Vile:: package.
.IP "current_window \s-1WINOBJ\s0" 4
.IX Item "current_window WINOBJ"
Sets the current window (window with focus) to \s-1WINOBJ\s0; Returns
\&\s-1WINOBJ\s0.
.Sp
Note:  You'd say
.Sp
.Vb 1
\&    $curwin = Vile::current_window;
.Ve
.Sp
to retrieve the current window and
.Sp
.Vb 1
\&    $mywin\->current_window;
.Ve
.Sp
to set it.
.IP "delete \s-1WINOBJ\s0" 4
.IX Item "delete WINOBJ"
Removes the window in question.  Screen real estate allocated to
the window will be returned to the window from whence it came.
.Sp
Returns 1 if successful, undef otherwise.
.IP "dot \s-1WINOBJ\s0" 4
.IX Item "dot WINOBJ"
.PD 0
.IP "current_position \s-1WINOBJ\s0" 4
.IX Item "current_position WINOBJ"
.PD
Retrieves \s-1DOT\s0 (the current position) for the current window.
In a scalar context, only the line number is returned.  In
an array context, a list containing both the line number and
offset within the line are returned.
.IP "dot \s-1WINOBJ\s0 \s-1LINENUM\s0, \s-1OFFSET\s0" 4
.IX Item "dot WINOBJ LINENUM, OFFSET"
.PD 0
.IP "current_position \s-1WINOBJ\s0 \s-1LINENUM\s0, \s-1OFFSET\s0" 4
.IX Item "current_position WINOBJ LINENUM, OFFSET"
.PD
Sets \s-1DOT\s0 (the current position) to the indicated values.
.Sp
When used in a scalar context, returns the line number.  When
used in a list context, returns both the line number and the
offset with in the line.
.Sp
Note: dot and current_position are aliases for each other.  Neither
provides any additional functionality over the other.
.IP "index \s-1WINOBJ\s0" 4
.IX Item "index WINOBJ"
Returns the index of \s-1WINOBJ\s0.  This will be a small integer, with
0 representing the first (top-most) window, 1 representing the
window below it, and so on.
.IP "new Vile::Window" 4
.IX Item "new Vile::Window"
Allocates and returns a new window.  The editor will choose
where the window will be located.  (It will likely choose a
large window to split.)  If a new window could not be allocated,
return undef.
.IP "new Vile::Window \s-1BUFOBJ\s0" 4
.IX Item "new Vile::Window BUFOBJ"
Like above, but associate \s-1BUFOBJ\s0 with the new window.
.IP "new \s-1WINOBJ\s0" 4
.IX Item "new WINOBJ"
Allocate and return a new window, using \s-1WINOBJ\s0 as the window
to split.  If this cannot be done, return undef.  If the split
is possible, the new window returned will be located below
\&\s-1WINOBJ\s0.
.IP "new \s-1WINOBJ\s0 \s-1BUFOBJ\s0" 4
.IX Item "new WINOBJ BUFOBJ"
Like above, but associate \s-1BUFOBJ\s0 with the new window.
.IP "size \s-1WINOBJ\s0" 4
.IX Item "size WINOBJ"
In a scalar context, return the height of a window.  In a list
context, return both the height and width.
.IP "size \s-1WINOBJ\s0 \s-1HEIGHT\s0" 4
.IX Item "size WINOBJ HEIGHT"
Set the height of a window.  It will attempt to change a windows
size by either adding or stealing lines from the window below.
(This means that the bottommost window can't be directly changed
since it doesn't have a window below it.)
.Sp
Returns the new size of the window.
.IP "size \s-1WINOBJ\s0 \s-1HEIGHT\s0 \s-1WIDTH\s0" 4
.IX Item "size WINOBJ HEIGHT WIDTH"
Unimplemented.  It is not possible to change the width at the
moment, but if the feature ever becomes available, this method
will do it.
.IP "topline \s-1WINOBJ\s0" 4
.IX Item "topline WINOBJ"
Returns the line number of the top line in the window.
.IP "window_at N" 4
.IX Item "window_at N"
Returns the Nth (starting at 0 from the top-most window) Vile::Window
object.  If there is no Nth window, undef is returned instead.
.Sp
Note: This method also appears in the Vile:: package.
.IP "window_count" 4
.IX Item "window_count"
Returns number of (visible) windows.
.Sp
Note:  Non-visible windows are used to represent buffers
for the perl \s-1API\s0.  They are also used for other purposes in
which modification of a buffer is desired, but disturbing
the position of the buffer within one of its windows is
not.
.Sp
Note: This method also appears in the Vile:: package.
