#!/bin/csh -f
###
### CSH version of cFilt.flx.  
###
### We're basically using csh as a substitute for the C preprocessor.
### PJM 950402

### First block, mostly code
###
cat << END1 > cFilt.flx
%x COMMENT

%{
/* Filter to add vile "attribution" sequences to selected bits of C/C++ */
/* input text. */

/* You gotta use flex for this beast - hence the COMMENT start state */
/* written by Alistair G. Crooks (agc@uts.amdahl.com) */

/*
 * PJM = Phil Mercurio (mercurio@acm.org)
 *
 * PJM 950331 	Colors changed and additional keywords added
 * PJM 950402 	Added types
 * PJM 950403	Added specials 
 */

#include <stdio.h>


#define BOLD	"B"
#define ULINE	"U"
#define ITALIC	"I"
#define COLOR1	"C1"
#define COLOR2	"C2"
#define COLOR3	"C3"
#define COLOR4	"C4"
#define COLOR5	"C5"

/* customize here, using the above set of defines... */

char special_attr[] = COLOR5;
char type_attr[] = COLOR4;
char keyword_attr[] = COLOR3;
char preproc_attr[] = COLOR2;
char comment_attr[] = COLOR1;

/* ...end customization */

#define CTL_A	'\001'

int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	extern FILE	*yyin;

	if (argc == 1) {
		yyin = stdin;
	} else if ((yyin = fopen(argv[1], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open %s\n", argv[1]);
		exit(1);
	}
	while (yylex() > 0) {
	}
	exit(0);
}

%}

%%

#[ \t]*if	|
#[ \t]*if(n)?def	|
#[ \t]*else	|
#[ \t]*endif	|
#[ \t]*define	|
#[ \t]*error	|
#[ \t]*include	|
#[ \t]*pragma	|
#[ \t]*undef	{ printf("%c%i%s:%s", CTL_A, yyleng, preproc_attr, yytext); }

END1

### Keywords, including user.keys
cat user.keys >> cFilt.flx

cat << END2 >> cFilt.flx
auto		|
break		|
case		|
class		|
const		|
continue	|
default		|
delete		|
do		|
else		|
enum		|
extern		|
for		|
friend		|
goto		|
if		|
inline		|
new		|
operator	|
overload	|
private		|
protected	|
public		|
register	|
return		|
sizeof		|
static		|
struct		|
switch		|
typedef		|
union		|
virtual		|
volatile	|
"}"		|
"{"		|
"<<"		|
">>"		|
while		{ printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }

END2

### Types, including user.types
cat user.types >> cFilt.flx

cat << END3 >> cFilt.flx
bool		|
char		|
double		|
float		|
int		|
long		|
short		|
unsigned	|
void		{ printf("%c%i%s:%s", CTL_A, yyleng, type_attr, yytext); }

END3

### Specials, including user.special, then the comments rules
cat user.special >> cFilt.flx

cat << END4 >> cFilt.flx
this		{ printf("%c%i%s:%s", CTL_A, yyleng, special_attr, yytext); }


"/*"		{ printf("%c2%s:/*", CTL_A, comment_attr); BEGIN(COMMENT); }
<COMMENT>[^*]*	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"*"+[^*/]*	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"*"+"/"	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); BEGIN(0); }

"//".*\$		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }

[a-zA-Z_][a-zA-Z_0-9]*	|
\"(\\\.|[^\"])*\"	{ printf("%s", yytext); }

END4
