%x COMMENT 

%{
/* Filter to add vile "attribution" sequences to selected bits of PERL */
/* input text. */

/* You gotta use flex for this beast - hence the COMMENT start state */
/* written by Pierre Dittgen (dittgen@univ-mlv.fr)    */

#include <stdio.h>


#define COLOR1	"C1"
#define COLOR2	"C2"
#define COLOR3	"C3"
#define COLOR4	"C4"
#define COLOR5	"C5"
#define COLOR6	"C6"
#define COLOR6	"C6"

/* customize here, using the above set of defines... */

char comment_attr[] = COLOR1;
char preproc_attr[] = COLOR2;
char keyword_attr[] = COLOR3;
char ident_attr[]   = COLOR4;
char chaine_attr[]  = COLOR5;
char number_attr[]  = COLOR6;

/* ...end customization */

#define CTL_A	'\001'

int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	extern FILE	*yyin;

	if (argc == 1) {
		yyin = stdin;
	} else if ((yyin = fopen(argv[1], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open %s\n", argv[1]);
		exit(1);
	}
	while (yylex() > 0) {
	}
	exit(0);
}

%}

NOSTRBRK	"\\\""
STRING		\"([^"]|{NOSTRBRK})*\"
IDENT		\$[a-zA-Z_][a-zA-Z_0-9]*
INTEGER		[-+]?([0-9]+)
REAL		[-+]?([0-9]*\.[0-9]+)([eE][+-]?[0-9]+)?

%%

^[ \t]*#!.*$	{ printf("%c%i%s:%s", CTL_A, yyleng, preproc_attr, yytext); }

cmp	|
eq	|
ge	|
gt	|
le	|
lt	|
ne	|
chop		|
close		|
die		|
each		|
else		|
elsif		|
for		|
foreach		|
grep		|
if		|
keys		|
last		|
local		|
map		|
my		|
next		|
open		|
package		|
print		|
pop		|
push		|
redo		|
require		|
reverse		|
shift		|
sort		|
sub		|
unless		|
unshift		|
until		|
values		|
while		{ printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }


^[ \t]*"#".*$	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }


			
{INTEGER}	|
{REAL}		{ printf("%c%i%s:%s", CTL_A, yyleng, number_attr, yytext); }

{IDENT}		{ printf("%c%i%s:%s", CTL_A, yyleng, ident_attr, yytext); }

{STRING}	{ printf("%c%i%s:%s", CTL_A, yyleng, chaine_attr, yytext); }

[a-zA-Z]+	{ printf("%s", yytext); }
