%x MATH MATHC

%{
/* LaTeX Filter......................................................... */
/* Filter to add vile "attribution" sequences to selected bits of LaTeX  */
/* input text.								 */

/* You gotta use flex for this beast - hence the COMMENT start state 	*/
/* First version written by Pierre Dittgen (dittgen@univ-mlv.fr)    	*/
/* modified by Vanessa Conchodon (conchodo@univ-mlv.fr) 		*/

#include <stdio.h>


#define COLOR1	"C1"
#define COLOR2	"C2"
#define COLOR3	"C3"
#define COLOR4	"C4"
#define COLOR5	"C5"
#define COLOR6	"C6"
#define COLOR6	"C6"
#define COLOR7	"C7"
#define COLOR8	"C8"
#define COLOR9	"C9"

/* customize here, using the above set of defines... */

char comment_attr[] = COLOR1;	/* comment */
char math_attr[] = COLOR2;	/* math formula [$...$]*/
char keyword_attr[] = COLOR3;	/* LaTeX keywords (\keyword) */
char ident_attr[]   = COLOR7;	/* LaTeX special character (\' \` ...) */ 
char chaine_attr[]  = COLOR5;   /* */
char number_attr[]  = COLOR6;   /* Number */
char math_c_attr[]  = COLOR4;	/* math formula (2) [$$...$$]*/
char subsection_attr[]  = COLOR8; /* section */
char section_attr[]  = COLOR9;	/* subsection */

/* ...end customization */

#define CTL_A	'\001'

int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	extern FILE	*yyin;

	if (argc == 1) {
		yyin = stdin;
	} else if ((yyin = fopen(argv[1], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open %s\n", argv[1]);
		exit(1);
	}
	while (yylex() > 0) {
	}
	exit(0);
}

%}

INTEGER		[-+]?([0-9]+)
REAL		[-+]?([0-9]*\.[0-9]+)([eE][+-]?[0-9]+)?

%%

\\"section" { printf("%c%i%s:%s", CTL_A, yyleng, section_attr, yytext); }
\\"subsection" { printf("%c%i%s:%s", CTL_A, yyleng, subsection_attr, yytext); }

\\[a-zA-Z][a-zA-Z]* { printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }
\\[^\a-zA-z][ a-zA-Z] { printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }


\\.[^ ] 	{ printf("%c%i%s:%s", CTL_A, yyleng-1, ident_attr, yytext); }

\$[^\$] 	{ printf("%c%i%s:%s", CTL_A, yyleng, math_attr, yytext); 
		  BEGIN(MATH);}
<MATH>[^\$/\n]+ { printf("%c%i%s:%s", CTL_A, yyleng, math_attr, yytext); }
<MATH>\$ 	{ printf("%c%i%s:%s", CTL_A, yyleng, math_attr, yytext); 
                  BEGIN(0);
		  }

\$\$	 	{ printf("%c%i%s:%s", CTL_A, yyleng, math_c_attr, yytext); 
		  BEGIN(MATHC);}
<MATHC>[^\$/\n]+ { printf("%c%i%s:%s", CTL_A, yyleng, math_c_attr, yytext); }
<MATHC>\$\$ 	{ printf("%c%i%s:%s", CTL_A, yyleng, math_c_attr, yytext); 
                  BEGIN(0);
		  }

" "*\{	 	{ printf("%c%i%s:%s", CTL_A, yyleng, chaine_attr, yytext); }

" "*\} 		{ printf("%c%i%s:%s", CTL_A, yyleng, chaine_attr, yytext); }


"%".*$		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }


			
{INTEGER}	|
{REAL}		{ printf("%c%i%s:%s", CTL_A, yyleng, number_attr, yytext); }

[a-zA-Z]+	{ printf("%s", yytext); }
