%x COMMENT CODE

%{
/* Filter to add vile "attribution" sequences to selected bits of HTML */
/* input text. */

/* You gotta use flex for this beast - hence the COMMENT start state */
/* written by Pierre Dittgen (dittgen@univ-mlv.fr)    */

#include <stdio.h>


#define COLOR1	"C1"
#define COLOR2	"C2"
#define COLOR3	"C3"
#define COLOR4	"C4"
#define COLOR5	"C5"
#define COLOR6	"C6"

/* customize here, using the above set of defines... */

char comment_attr[] = COLOR1;
char preproc_attr[] = COLOR2;
char keyword_attr[] = COLOR4;
char type_attr[]    = COLOR4;
char chaine_attr[]  = COLOR5;
char nombre_attr[]  = COLOR6;

/* ...end customization */

#define CTL_A	'\001'

int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	extern FILE	*yyin;

	if (argc == 1) {
		yyin = stdin;
	} else if ((yyin = fopen(argv[1], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open %s\n", argv[1]);
		exit(1);
	}
	while (yylex() > 0) {
	}
	exit(0);
}

/* In the following, you have a list with the whole alphabet
 * It is useful to recognize the keywords in lowcase or upcase
 * or a combination of the both
 * My filter can recognize IMG, img, Img or even ImG or iMg
 */
%}

INTEGER		[-+]?([0-9]+)
REAL		[-+]?([0-9]*\.[0-9]+)([eE][+-]?[0-9]+)? 
IDENT		[a-zA-Z_][a-zA-Z_0-9]*
NOSTRBRK	"\\\""
STRING		\"([^"]|{NOSTRBRK})*\"

a		[aA]
b		[bB]
c		[cC]
d		[dD]
e		[eE]
f		[fF]
g		[gG]
h		[hH]
i		[iI]
j		[jJ]
k		[kK]
l		[lL]
m		[mM]
n		[nN]
o		[oO]
p		[pP]
q		[qQ]
r		[rR]
s		[sS]
t		[tT]
u		[uU]
v		[vV]
w		[wW]
x		[xX]
y		[yY]
z		[zZ]

%%


"<"		{ printf("%c1%s:<", CTL_A, keyword_attr); BEGIN(CODE); }
<CODE>">"	{ printf("%c1%s:>", CTL_A, keyword_attr); BEGIN(0);    }


<CODE>(\/)?{a}					|
<CODE>(\/)?{a}{d}{r}{e}{s}{s}			|
<CODE>(\/)?{b}{l}{i}{n}{k}			|
<CODE>(\/)?{b}{l}{o}{c}{k}{q}{u}{o}{t}{e}	|
<CODE>(\/)?{b}{o}{d}{y}				|
<CODE>(\/)?{c}{a}{p}{t}{i}{o}{n}		|
<CODE>(\/)?{c}{e}{n}{t}{e}{r}			|
<CODE>(\/)?{c}{i}{t}{e}				|
<CODE>(\/)?{c}{o}{d}{e}				|
<CODE>(\/)?{d}{l}				|
<CODE>(\/)?{e}{m}				|
<CODE>(\/)?{f}{o}{n}{t}				|
<CODE>(\/)?{f}{o}{r}{m}				|
<CODE>(\/)?{h}[1-6]				|
<CODE>(\/)?{h}{e}{a}{d}				|
<CODE>(\/)?{h}{r}				|
<CODE>(\/)?{h}{t}{m}{l}				|
<CODE>(\/)?{i}					|
<CODE>(\/)?{k}{b}{d}				|
<CODE>(\/)?{o}{l}				|
<CODE>(\/)?{p}					|
<CODE>(\/)?{p}{r}{e}				|
<CODE>(\/)?{s}{a}{m}{p}				|
<CODE>(\/)?{s}{t}{r}{o}{n}{g}			|
<CODE>(\/)?{s}{u}{b}				|
<CODE>(\/)?{s}{u}{p}				|
<CODE>(\/)?{t}{a}{b}{l}{e}			|
<CODE>(\/)?{t}{i}{t}{l}{e}			|
<CODE>(\/)?{t}{h}				|
<CODE>(\/)?{t}{r}				|
<CODE>(\/)?{t}{t}				|
<CODE>(\/)?{u}{l}				|
<CODE>(\/)?{v}{a}{r}				|	

<CODE>{a}{c}{t}{i}{o}{n}		|
<CODE>{a}{l}{i}{g}{n}			|
<CODE>{a}{l}{i}{n}{k}			|
<CODE>{a}{l}{t}				|
<CODE>{a}{d}{d}_{d}{a}{t}{e}		|
<CODE>{b}{a}{c}{k}{g}{r}{o}{u}{n}{d}	|
<CODE>{b}{a}{s}{e}			|
<CODE>{b}{g}{c}{o}{l}{o}{r}		|
<CODE>{b}{o}{t}{t}{o}{m}		|
<CODE>{b}{o}{r}{d}{e}{r}		|
<CODE>{b}{r}				|
<CODE>{c}{o}{l}{o}{r}			|
<CODE>{c}{o}{l}{s}			|
<CODE>{c}{o}{l}{s}{p}{a}{n}		|
<CODE>{d}{t}				|
<CODE>{h}{e}{i}{g}{h}{t}		|
<CODE>{h}{r}{e}{f}			|
<CODE>{i}{m}{g}				|
<CODE>{i}{n}{p}{u}{t}			|
<CODE>{l}{i}				|
<CODE>{l}{i}{n}{k}			|
<CODE>{l}{e}{f}{t}			|
<CODE>{m}{a}{p}         		|
<CODE>{m}{e}{t}{h}{o}{d}		|
<CODE>{m}{i}{d}{d}{l}{e}		|
<CODE>{n}{a}{m}{e}			|
<CODE>{n}{o}{s}{h}{a}{d}{e}		|
<CODE>{o}{p}{t}{i}{o}{n}		|
<CODE>{r}{e}{v}				|
<CODE>{r}{o}{w}{s}			|
<CODE>{r}{o}{w}{s}{p}{a}{n}		|
<CODE>{r}{i}{g}{h}{t}      		|
<CODE>{s}{e}{l}{e}{c}{t}		|
<CODE>{s}{i}{z}{e}			|
<CODE>{s}{r}{c}				|
<CODE>{t}{e}{x}{t}			|
<CODE>{t}{e}{x}{t}{a}{r}{e}{a}		|
<CODE>{t}{o}{p}				|
<CODE>{t}{y}{p}{e}			|
<CODE>{v}{a}{l}{i}{g}{n}		|
<CODE>{v}{a}{l}{u}{e}			|
<CODE>{v}{l}{i}{n}{k}			|
<CODE>{w}{i}{d}{t}{h}			{ printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }


"<!--"			{ printf("%c4%s:<!--", CTL_A, comment_attr); 
			  BEGIN(COMMENT);                                           }
<COMMENT>[^-]+		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"-"+[^->]*	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"-->"		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); 
			  BEGIN(0);                                                 }

{IDENT}		{ printf("%s", yytext); }
<CODE>{STRING}	{ printf("%c%i%s:%s", CTL_A, yyleng, chaine_attr, yytext); }
