%x COMMENT PREP_COM

%{
/* CWEBx Filter.........................................................*/
/* Filter to add vile "attribution" sequences to selected bits of Cwebx */
/* input text. Also useful for Cweb				        */

/* You gotta use flex for this beast - hence the COMMENT start state    */
/* Written by Vanessa Conchodon (conchodo@univ-mlv.fr)                  */

#include <stdio.h>


#define COLOR1	"C1"
#define COLOR2	"C2"
#define COLOR3	"C3"
#define COLOR4	"C4"
#define COLOR5	"C5"
#define COLOR6	"C6"
#define COLOR7	"C7"
#define COLOR8	"C8"
#define COLOR9	"C8"
#define COLOR10	"C9"
#define COLOR11	"C8"

/* customize here, using the above set of defines... */

char comment_attr[] = COLOR1;
char preproc_attr[] = COLOR2;
char keyword_attr[] = COLOR3;
char type_attr[]    = COLOR4;
char chaine_attr[]  = COLOR5;
char nombre_attr[]  = COLOR6;
char TeX_mot_cle[]  = COLOR7;
char TeX_comment[]  = COLOR8;
char Cweb_nom_module[]  = COLOR9;
char Cweb_code_titre[]  = COLOR10;
char Cweb_code_autre[]  = COLOR11;

/* ...end customization */

#define CTL_A	'\001'

int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	extern FILE	*yyin;

	if (argc == 1) {
		yyin = stdin;
	} else if ((yyin = fopen(argv[1], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open %s\n", argv[1]);
		exit(1);
	}
	while (yylex() > 0) {
	}
	exit(0);
}

%}

INTEGER		[-+]?([0-9]+)
REAL		[-+]?([0-9]*\.[0-9]+)([eE][+-]?[0-9]+)? 
IDENT		[a-zA-Z_][a-zA-Z_0-9]*
STRING		\"(\\\.|[^\"])*\"
RC		\n

%%

#[ \t]*if[ \t]+"0"   { printf("%c%i%s:%s", CTL_A, yyleng, preproc_attr, yytext); 
			  BEGIN(PREP_COM);                                          }
<PREP_COM>^[^#{RC}].*$      { printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<PREP_COM>^{RC}     { printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext);  }
<PREP_COM>#[ \t]*endif  { printf("%c%i%s:%s", CTL_A, yyleng, preproc_attr, yytext); 
			  BEGIN(0);                                                 }

#[ \t]*if	|
#[ \t]*if(n)?def	|
#[ \t]*else	|
#[ \t]*endif	|
#[ \t]*define	|
#[ \t]*error	|
#[ \t]*include[ \t]*<(\\\.|[^>])*>    |
#[ \t]*include[ \t]*\"(\\\.|[^\"])*\" |
#[ \t]*undef	{ printf("%c%i%s:%s", CTL_A, yyleng, preproc_attr, yytext); }

auto		|
break		|
case		|
continue	|
default		|
do		|
else		|
extern		|
for		|
goto		|
if		|
return		|
sizeof		|
static		|
switch		|
volatile	|
while		|

catch		|
class		|
delete		|
friend		|
inline		|
new		|
operator	|
overload	|
private		|
protected	|
public		|
template	|
this		|
virtual		{ printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext); }


char		|
const		|
double		|
enum		|
float		|
int		|
long		|
struct		|
typedef		|
union		|
unsigned	|
void		{ printf("%c%i%s:%s", CTL_A, yyleng, type_attr, yytext); }


"/*"			{ printf("%c2%s:/*", CTL_A, comment_attr); 
			  BEGIN(COMMENT);                                           }
<COMMENT>[^\*\n]+	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"*"+[^\*/\n]*	{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }
<COMMENT>"*"+"*/"		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); 
			  BEGIN(0);                                                 }
<COMMENT>"*/"		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); 
			  BEGIN(0);                                                 }

"//".*$		{ printf("%c%i%s:%s", CTL_A, yyleng, comment_attr, yytext); }


{REAL} 		|
{INTEGER}	{ printf("%c%i%s:%s", CTL_A, yyleng, nombre_attr, yytext);}


{IDENT}		{ printf("%s", yytext); }
{STRING}	{ printf("%c%i%s:%s", CTL_A, yyleng, chaine_attr, yytext); }

\\[a-zA-Z][a-zA-Z]* { printf("%c%i%s:%s", CTL_A, yyleng, TeX_mot_cle, yytext); }
\\[^\a-zA-z][ a-zA-Z] { printf("%c%i%s:%s", CTL_A, yyleng, keyword_attr, yytext)
; }


"@*"[1-9]*[ ]*[^\.]*"." { printf("%c%i%s:%s", CTL_A, yyleng, Cweb_code_titre, yytext); }

"@<"[^@]*"@>" { printf("%c%i%s:%s", CTL_A, yyleng, Cweb_nom_module, yytext); }

"@".		{ printf("%c%i%s:%s", CTL_A, yyleng, Cweb_code_autre, yytext); }

%%

/*
"%".*$		{ printf("%c%i%s:%s", CTL_A, yyleng, TeX_comment, yytext); }
*/
