// Maximum number of UARTs at one time
#define MAX_UARTS				32

// Limits of the buffers
#define MIN_INBUF_SIZE		256
#define MAX_INBUF_SIZE		32768
#define MIN_OUTBUF_SIZE		64
#define MAX_OUTBUF_SIZE		32768

// Suggested values
#define NRM_INBUF_SIZE		2048
#define NRM_OUTBUF_SIZE		1024

// Values for UART_set_bps_rate()
#define BPS_115200	1
#define BPS_57600		2
#define BPS_38400		3
#define BPS_19200		6
#define BPS_9600		12
#define BPS_2400		48
#define BPS_1200		96
#define BPS_600		192
#define BPS_300		384

// Values for UART_set_line_params()  (can be combined with |)
#define LP_5BITS			0x00
#define LP_6BITS			0x01
#define LP_7BITS			0x02
#define LP_8BITS			0x03
#define LP_1STOP			0x00
#define LP_2STOP			0x04
#define LP_NO_PARITY		0x00
#define LP_ODD_PARITY	0x08
#define LP_EVEN_PARITY	0x18
#define LP_MARK_PARITY	0x28
#define LP_SPACE_PARITY	0x38

// Values for base addresses
#define BASE_COM1			(*(unsigned far *)0x00400000UL)
#define BASE_COM2			(*(unsigned far *)0x00400002UL)
#define BASE_COM3			(*(unsigned far *)0x00400004UL)
#define BASE_COM4			(*(unsigned far *)0x00400006UL)

// Values for the RX FIFO triggerlevel
#define FIFO_1				0x00
#define FIFO_4				0x40
#define FIFO_8				0x80
#define FIFO_14			0xC0

// Values for line status test
#define LS_DR				0x01		// data ready
#define LS_OE				0x02		// overrun error
#define LS_PE				0x04		// parity error
#define LS_FE				0x08		// framing error
#define LS_BI				0x10		// break indicator
#define LS_THRE			0x20		// transmitter holding register empty
#define LS_TEMT			0x40		// transmitter empty
#define LS_PENDING		0x80		// error pending in FIFO (16550+ only)

// Values for modem status test
#define MS_DELTA_CTS		0x01
#define MS_DELTA_DSR		0x02
#define MS_TERI			0x04
#define MS_DELTA_DCD		0x08
#define MS_CTS				0x10
#define MS_DSR				0x20
#define MS_RI				0x40
#define MS_DCD				0x80

// Values for handshaking mode
#define HS_NONE			0x00
#define HS_RTSCTS			0x01
#define HS_XONXOFF		0x02

// Values for errors
#define UE_OK					0		// OK
#define UE_ERROR				-1		// unspecific error condition
#define UE_BAD_HANDLE		-2		// given handle has never been defined
#define UE_NO_HANDLES		-3		// no free handles left (too many ports)
#define UE_NO_FREE_MEMORY	-4		// not enough free memory for buffers
#define UE_BAD_INBUF_SIZE	-5		// illegal size given for inbuf
#define UE_BAD_OUTBUF_SIZE	-6		// illegal size given for outbuf
#define UE_BAD_HANDSHAKING	-7		// illegal handshaking mode specified
#define UE_BAD_INTLEVEL		-8		// illegal interrupt level
#define UE_TIMEOUT			-9		// any kind of timeout condition appeared
#define UE_BAD_FIFO			-10	// it's a 16550 (no A), FIFO not enabled
#define UE_BAD_HANDLER		-11	// NULL pointer given for handler address

// Values for UART detection routine
#define UD_NONE				-1		//   -1 if no UART is installed at the given base address
#define UD_8250				0		//    0 - 8250
#define UD_16450				1		//    1 - 16450
#define UD_16550_NOSCR		2		//    2 - 16550 w/o SCR
#define UD_16550				3		//    3 - 16550
#define UD_16550A_NOSCR		4		//    4 - 16550A w/o SCR
#define UD_16550A				5		//    5 - 16550A


// Prototypes for detection
int cdecl uart_detect_type(unsigned baseaddr);
int cdecl uart_detect_intlevel(unsigned baseaddr);

// Prototypes for general uart access
int cdecl uart_set_bps_rate(unsigned baseaddr, unsigned divisor);
int cdecl uart_set_line_params(unsigned baseaddr, unsigned lineparams);
void cdecl uart_set_break(unsigned baseaddr);
void cdecl uart_clear_break(unsigned baseaddr);
void cdecl uart_set_dtr(unsigned baseaddr);
void cdecl uart_clear_dtr(unsigned baseaddr); 
void cdecl uart_set_rts(unsigned baseaddr);
void cdecl uart_clear_rts(unsigned baseaddr); 
void cdecl uart_set_local_loopback(unsigned baseaddr);
void cdecl uart_clear_local_loopback(unsigned baseaddr);
int cdecl uart_enable_fifo(unsigned baseaddr, unsigned triggerlevel);
void cdecl uart_disable_fifo(unsigned baseaddr);

// Prototypes for polled mode operation
int cdecl uart_poll_receive_byte(unsigned baseaddr);
int cdecl uart_poll_send_byte(unsigned baseaddr, int character);
int cdecl uart_poll_send_string(unsigned baseaddr, char *string);
int cdecl uart_poll_send_block(unsigned baseaddr, void *block, unsigned blocksize);
int cdecl uart_get_line_status(unsigned baseaddr);
int cdecl uart_get_modem_status(unsigned baseaddr);
int cdecl uart_read_scratch_register(unsigned baseaddr);
void cdecl uart_write_scratch_register(unsigned baseaddr, int value);

// Prototypes for interrupt mode operation
int cdecl uart_int_define_port(unsigned baseaddr, unsigned intlevel, unsigned inbuf_size,
										unsigned outbuf_size, unsigned handshake);
int cdecl uart_int_undef_port(int handle);
int cdecl uart_int_receive_byte(int handle);
int cdecl uart_int_send_byte(int handle, int byte);
int cdecl uart_int_set_break(int handle);
int cdecl uart_int_clear_break(int handle);
int cdecl uart_int_set_dtr(int handle);
int cdecl uart_int_clear_dtr(int handle);
int cdecl uart_int_set_rts(int handle);
int cdecl uart_int_clear_rts(int handle);
int cdecl uart_int_set_local_loopback(int handle);
int cdecl uart_int_clear_local_loopback(int handle);
int cdecl uart_int_clear_receive_buffer(int handle);
int cdecl uart_int_clear_send_buffer(int handle);
int cdecl uart_int_set_bps_rate(int handle, unsigned bpsrate);
int cdecl uart_int_set_line_params(int handle, int lineparams);
int cdecl uart_int_read_line_params(int handle);
int cdecl uart_int_write_scr(int handle, int value);
int cdecl uart_int_read_scr(int handle);
int cdecl uart_int_send_string(int handle, char *buf);
int cdecl uart_int_send_block(int handle, void *pointer, unsigned count);
int cdecl uart_int_set_handshake(int handle, unsigned handshake);
int cdecl uart_int_set_msi_handler(int handle, void (*msihandler)(int handle, unsigned baseaddr, int msr));
int cdecl uart_int_set_lsi_handler(int handle, void (*lsihandler)(int handle, unsigned baseaddr, int lsr));
int cdecl uart_int_default_handler(int handle, unsigned baseaddr, int value);
void cdecl uart_int_enable(void);
void cdecl uart_int_disable(void);
unsigned cdecl uart_int_get_baseaddr(int handle);


