/*************************************************************************/
/* This is a small example program that uses the UART lib to communicate */
/* with my modem on COM4. Use two computers and this small program for a */
/* small talk via a null-modem cable (define CREXPAND then).             */
/*************************************************************************/

/* INTERRUPT VERSION */
/* Different from EXAMPLE2.C, this one doesn't lose characters, even at
	high rates like 57600 bps as long as the buffers don't overflow. And
	even this could be easily avoided by using flow control. */

#include <stdio.h>
#include <conio.h>
#include <uart.h>

#define BASE 	BASE_COM4	/* whatever you like ... */
#define RATE   BPS_57600	/* dito */
#define LINE	(LP_8BITS|LP_NO_PARITY|LP_1STOP)

#undef CREXPAND				/* define this if you want CRs to be expanded */


void main()
{
	int h;
	int x;
	int il;

	il=uart_detect_intlevel(BASE);
	if (il<0) {
		printf("Error: intlevel could not be detected.\n");
		return;
		}
	printf("UART at base address 0x%3X uses interrupt level %d.\n",BASE,il);
	h=uart_int_define_port(BASE,il,NRM_INBUF_SIZE,NRM_OUTBUF_SIZE,HS_NONE);
					/* note that I didn't use flow control here; use HS_RTSCTS or
						HS_XONXOFF instead of HS_NONE if you like */
	if (h<0) {
		printf("Error #%d\n",h);
		return;
		}
	printf("Press Esc to quit.\n");
	uart_int_set_bps_rate(h,RATE);
	uart_int_set_line_params(h,LINE);
	uart_int_set_rts(h);
	uart_int_enable();
	while (1) {
		if (kbhit()) {
			x=getch();
			if (x==27) break;
#ifdef CREXPAND
			if (x==0xd) {
				uart_int_send_byte(h,0xd);
				uart_int_send_byte(h,0xa);
				}
			else
#endif
				uart_int_send_byte(h,x);
			}
		x=uart_int_receive_byte(h);
		if (x!=UE_ERROR) {
			putchar(x);
			}
		}
}

