/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_scanw.c
**
**	The routines scanw(), wscanw() and friend.
**
** $Log:	RCS/lib_scanw.v $
 * Revision 2.1  82/10/25  14:48:51  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/25  13:49:07  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_scanw.v  Revision 2.1  82/10/25  14:48:51  pavel  Exp$";

#include "curses.h"
#include "curses.priv.h"


scanw(fmt, args)
char	*fmt;
int	args;
{
#ifdef TRACE
	if (_tracing)
	    _tracef("scanw(%s,...) called", fmt);
#endif

	return(sscans(stdscr, fmt, &args));
}



wscanw(win, fmt, args)
WINDOW	*win;
char	*fmt;
int	args;
{
#ifdef TRACE
	if (_tracing)
	    _tracef("wscanw(%o,%s,...) called", win, fmt);
#endif

	return(sscans(win, fmt, &args));
}



mvscanw(y, x, fmt, args)
int	y, x;
char	*fmt;
int	args;
{
	return(move(y, x) == OK ? sscanw(stdscr, fmt, &args) : ERR);
}



mvwscanw(win, y, x, fmt, args)
WINDOW	*win;
int	y, x;
char	*fmt;
int	args;
{
	return(wmove(win, y, x) == OK ? sscanw(win, fmt, &args) : ERR);
}



/*
**	This routine actually executes the scanf from the window.
**
**	This is really a modified version of "sscanf".  As such,
** it assumes that sscanf interfaces with the other scanf functions
** in a certain way.  If this is not how your system works, you
** will have to modify this routine to use the interface that your
** "sscanf" uses.
*/

static
sscans(win, fmt, args)
WINDOW	*win;
char	*fmt;
int	*args;
{
	char	buf[100];
	FILE	junk;

	junk._flag = _IOREAD|_IOSTRG;
	junk._base = junk._ptr = buf;

	if (wgetstr(win, buf) == ERR)
	    return(ERR);

	junk._cnt = strlen(buf);

	return(_doscan(&junk, fmt, args));
}
