/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_printw.c
**
**	The routines printw(), wprintw() and friend.
**
** $Log:	RCS/lib_printw.v $
 * Revision 2.1  82/10/25  14:48:38  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/25  13:48:22  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_printw.v  Revision 2.1  82/10/25  14:48:38  pavel  Exp$";

#include "curses.h"
#include "curses.priv.h"


printw(fmt, args)
char	*fmt;
int	args;
{
#ifdef TRACE
	if (_tracing)
	    _tracef("printw(%s,...) called", fmt);
#endif

	return(sprintw(stdscr, fmt, &args));
}



wprintw(win, fmt, args)
WINDOW	*win;
char	*fmt;
int	args;
{
#ifdef TRACE
	if (_tracing)
	    _tracef("wprintw(%o,%s,...) called", win, fmt);
#endif

	return(sprintw(win, fmt, &args));
}



mvprintw(y, x, fmt, args)
int		y, x;
char		*fmt;
int		args;
{
	return(move(y, x) == OK ? sprintw(stdscr, fmt, &args) : ERR);
}



mvwprintw(win, y, x, fmt, args)
WINDOW	*win;
int	y, x;
char	*fmt;
int	args;
{
	return(wmove(win, y, x) == OK ? sprintw(win, fmt, &args) : ERR);
}



/*
**	This routine actually executes the printf and adds it to the window
**
**	This is really a modified version of "sprintf".  As such,
** it assumes that sprintf interfaces with the other printf functions
** in a certain way.  If this is not how your system works, you
** will have to modify this routine to use the interface that your
** "sprintf" uses.
*/

static
sprintw(win, fmt, args)
WINDOW	*win;
char	*fmt;
int	*args;
{
	FILE	junk;
	char	buf[512];

	junk._flag = _IOWRT + _IOSTRG;
	junk._ptr = buf;
	junk._cnt = 32767;

	_doprnt(fmt, args, &junk);
	putc('\0', &junk);

	return(waddstr(win, buf));
}
