/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_insch.c
**
**	The routine winsch().
**
** $Log:	RCS/lib_insch.v $
 * Revision 2.1  82/10/25  14:47:39  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/25  13:46:02  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_insch.v  Revision 2.1  82/10/25  14:47:39  pavel  Exp$";

#include "curses.h"
#include "curses.priv.h"


winsch(win, c)
WINDOW	*win;
char	c;
{
	chtype	*temp1, *temp2;
	chtype	*end;

#ifdef TRACE
	if (_tracing)
	    _tracef("winsch(%o,'%c') called", win, c);
#endif

	end = &win->_line[win->_cury][win->_curx];
	temp1 = &win->_line[win->_cury][win->_maxx];
	temp2 = temp1 - 1;

	while (temp1 > end)
	    *temp1-- = *temp2--;

	*temp1 = c | win->_attrs;

	win->_lastchar[win->_cury] = win->_maxx;
	if (win->_firstchar[win->_cury] == _NOCHANGE
	    			||  win->_firstchar[win->_cury] > win->_curx)
	    win->_firstchar[win->_cury] = win->_curx;
}
