/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
 *	fixterm.c
 *
 *	Routines:
 *		fixterm()
 *		resetterm()
 *		saveterm()
 *		gettmode()
 *		setterm()
 *		baudrate()
 *		erasechar()
 *		killchar()
 *		flushinp()
 *		savetty()
 *		resetty()
 *
 *  $Log:	RCS/lib_fixterm.v $
 * Revision 2.1  82/10/25  14:47:22  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/24  15:17:36  pavel
 * Beta-one Test Release
 * 
 * Revision 1.3  82/08/23  22:30:27  pavel
 * The REAL Alpha-one Release Version
 * 
 * Revision 1.2  82/08/19  19:11:21  pavel
 * Alpha Test Release One
 * 
 * Revision 1.1  82/08/12  18:40:30  pavel
 * Initial revision
 * 
 *
 */

static char RCSid[] =
	"$Header:   RCS/lib_fixterm.v  Revision 2.1  82/10/25  14:47:22  pavel  Exp$";

#include <sys/ioctl.h>
#include "curses.h"
#include "curses.priv.h"
#include "term.h"


/*
 *	fixterm()
 *	resetterm()
 *
 *	fixterm() establishes the tty modes contained in cur_term->Nttyb.
 *	resetterm() establishes those in cur_term->Ottyb.
 *
 */


fixterm()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("fixterm() called");
#endif
        stty(cur_term->Filedes, &cur_term->Nttyb);
}


resetterm()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("resetterm() called");
#endif
        stty(cur_term->Filedes, &cur_term->Ottyb);
}



saveterm()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("saveterm() called");
#endif
	gtty(cur_term->Filedes, &cur_term->Nttyb);
}



/*
 *	gettmode()
 *	setterm(type)
 *
 *	These are kept around for backward compatibilty.  gettmode() does
 *	nothing.  setterm() results in a proper call to setupterm()
 *
 */

gettmode()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("gettmode() called");
#endif
}


setterm(type)
char	*type;
{
#ifdef TRACE
	if (_tracing)
	    _tracef("setterm() called");
#endif
    	setupterm(type, 1, 0);
}




/*
 *	erasechar()
 *
 *	Return erase character as given in cur_term->Ottyb.
 *
 */

char
erasechar()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("erasechar() called");
#endif
    return(cur_term->Ottyb.sg_erase);
}



/*
 *	killchar()
 *
 *	Return kill character as given in cur_term->Ottyb.
 *
 */

char
killchar()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("killchar() called");
#endif
    return(cur_term->Ottyb.sg_kill);
}



/*
 *	flushinp()
 *
 *	Flush any input on cur_term->Filedes
 *
 */

flushinp()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("flushinp() called");
#endif
        ioctl(cur_term->Filedes, TIOCFLUSH, 0);
    
        if (SP)
	    SP->_backcnt = 0;
}



/*
 *	int
 *	baudrate()
 *
 *	Returns the current terminal's baud rate.
 *
 */

static int speeds[] =
{
	0, 50, 75, 110, 134, 150, 200, 300, 600,
	1200, 1800, 2400, 4800, 9600, 19200, 38400
};

int
baudrate()
{
#ifdef UNDEFINED
	if (_tracing)
	    _tracef("baudrate() called");
#endif
	return(speeds[cur_term->Nttyb.sg_ospeed]);
}


/*
**	savetty()  and  resetty()
**
**	Kept around for compatibility.
**	
*/

static struct sgttyb	sgbuf;

savetty()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("savetty() called");
#endif

    gtty(cur_term->Filedes, &sgbuf);
}

resetty()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("resetty() called");
#endif

    stty(cur_term->Filedes, &sgbuf);
}
