/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_endwin.c
**
**	The routine endwin().
**
** $Log:	RCS/lib_endwin.v $
 * Revision 2.1  82/10/25  14:47:13  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/25  13:45:05  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_endwin.v  Revision 2.1  82/10/25  14:47:13  pavel  Exp$";

#include "term.h"
#include "curses.h"
#include "curses.priv.h"


static
outc(ch)
char	ch;
{
    	putc(ch, SP->_ofp);
}


endwin()
{
#ifdef TRACE
	if (_tracing)
	    _tracef("endwin() called");
#endif

	resetterm();

	mvcur(-1, -1, LINES - 1, 0);

	if (exit_ca_mode)
	    tputs(exit_ca_mode, 1, outc);

	if (curscr  &&  (curscr->_attrs != A_NORMAL))
	{
	    vidputs(A_NORMAL, outc);

	    curscr->_attrs = A_NORMAL;
	}

	fflush(SP->_ofp);
}
