/*********************************************************************
*                         COPYRIGHT NOTICE                           *
**********************************************************************
*        This software is copyright (C) 1982 by Pavel Curtis         *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this file by any means so long as no fee is charged         *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Pavel Curtis                                        *
*                Computer Science Dept.                              *
*                405 Upson Hall                                      *
*                Cornell University                                  *
*                Ithaca, NY 14853                                    *
*                                                                    *
*                Ph- (607) 256-4934                                  *
*                                                                    *
*                Pavel.Cornell@Udel-Relay   (ARPAnet)                *
*                decvax!cornell!pavel       (UUCPnet)                *
*********************************************************************/

/*
**	lib_delwin.c
**
**	The routine delwin().
**
** $Log:	RCS/lib_delwin.v $
 * Revision 2.1  82/10/25  14:47:01  pavel
 * Added Copyright Notice
 * 
 * Revision 2.0  82/10/25  13:44:21  pavel
 * Beta-one Test Release
 * 
**
*/

static char RCSid[] =
	"$Header:   RCS/lib_delwin.v  Revision 2.1  82/10/25  14:47:01  pavel  Exp$";

#include "curses.h"
#include "curses.priv.h"


delwin(win)
WINDOW	*win;
{
	int	i;

#ifdef TRACE
	if (_tracing)
	    _tracef("delwin(%o) called", win);
#endif

	if (! (win->_flags & _SUBWIN))
	{
	    for (i = 0; i <= win->_maxy  &&  win->_line[i]; i++)
		cfree(win->_line[i]);
	}

	cfree(win->_numchngd);
	cfree(win->_firstchar);
	cfree(win->_lastchar);
	cfree(win->_line);
	cfree(win);
}
